/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.timestamp.verify;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESTimeStampSigner;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.timestamp.verify.VerifyTimeStampRequest;
import org.demoiselle.signer.serpro.desktop.command.timestamp.verify.VerifyTimeStampResponse;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.timestamp.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyTimeStamp
extends AbstractCommand<VerifyTimeStampRequest, VerifyTimeStampResponse> {
    private static final Logger logger = LoggerFactory.getLogger(VerifyTimeStamp.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyTimeStampResponse doCommand(VerifyTimeStampRequest request) throws Throwable {
        this.validateRequest(request);
        VerifyTimeStampResponse verifyResponse = new VerifyTimeStampResponse();
        Statistics instaSta = new Statistics();
        boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
        try {
            Main.showLoadingScreen(request.getHostConnectedPrefix());
            CAdESTimeStampSigner varCAdESTimeStampSigner = new CAdESTimeStampSigner();
            List<Object> listTimeStamp = new ArrayList();
            String varTipo = request.getType();
            switch (varTipo.toLowerCase()) {
                case "hash": {
                    logger.info("verificando Hash");
                    instaSta.setType("verify hash");
                    byte[] byteArrayOriginalInputData = Base64Utils.base64Decode(request.getInputData());
                    byte[] byteArrayOriginalInputTimeStamp = Base64Utils.base64Decode(request.getInputTimeStamp());
                    instaSta.setStart(System.currentTimeMillis());
                    Timestamp varTimeStamp = varCAdESTimeStampSigner.checkTimeStampWithHash(byteArrayOriginalInputTimeStamp, byteArrayOriginalInputData);
                    listTimeStamp.add(varTimeStamp);
                    instaSta.setEnd(System.currentTimeMillis());
                    break;
                }
                case "text": {
                    logger.info("verificando TimeStamp para Texto");
                    instaSta.setType("verify timestamp text");
                    byte[] byteArrayOriginalInputData = this.contentToBytes(request.getInputData(), request.getTextEncoding());
                    byte[] byteArrayOriginalInputTimeStamp = Base64Utils.base64Decode(request.getInputTimeStamp());
                    instaSta.setStart(System.currentTimeMillis());
                    Timestamp varTimeStamp = varCAdESTimeStampSigner.checkTimeStampWithContent(byteArrayOriginalInputTimeStamp, byteArrayOriginalInputData);
                    instaSta.setEnd(System.currentTimeMillis());
                    listTimeStamp.add(varTimeStamp);
                    byteArrayOriginalInputTimeStamp = new byte[]{};
                    byteArrayOriginalInputData = new byte[]{};
                    varTimeStamp = null;
                    break;
                }
                case "base64": {
                    logger.info("verificando timeStamp para conte\u00fado base64");
                    instaSta.setType("verify timestamp base64");
                    byte[] byteArrayOriginalInputTimeStamp = Base64Utils.base64Decode(request.getInputTimeStamp());
                    byte[] byteArrayOriginalInputData = Base64Utils.base64Decode(request.getInputData());
                    instaSta.setStart(System.currentTimeMillis());
                    Timestamp varTimeStamp = varCAdESTimeStampSigner.checkTimeStampWithContent(byteArrayOriginalInputTimeStamp, byteArrayOriginalInputData);
                    listTimeStamp.add(varTimeStamp);
                    instaSta.setEnd(System.currentTimeMillis());
                    byteArrayOriginalInputTimeStamp = new byte[]{};
                    byteArrayOriginalInputData = new byte[]{};
                    varTimeStamp = null;
                    break;
                }
                case "signature": {
                    logger.info("verificando timestamp em assinatura");
                    instaSta.setType("verify timestamp signature");
                    byte[] byteArrayOriginalInputTimeStamp = Base64Utils.base64Decode(request.getInputTimeStamp());
                    instaSta.setStart(System.currentTimeMillis());
                    listTimeStamp = varCAdESTimeStampSigner.checkTimeStampOnSignature(byteArrayOriginalInputTimeStamp);
                    instaSta.setEnd(System.currentTimeMillis());
                    byteArrayOriginalInputTimeStamp = new byte[]{};
                    break;
                }
                default: {
                    logger.error("tipo n\u00e3o permitido");
                    byte[] byteArrayOriginalInputTimeStamp = new byte[]{};
                    byte[] byArray = new byte[]{};
                }
            }
            verifyResponse.setRequestId(request.getRequestId());
            if (!listTimeStamp.isEmpty()) {
                instaSta.setSuccess(true);
                int numberOfSignature = 0;
                for (Timestamp timestamp : listTimeStamp) {
                    ++numberOfSignature;
                    String text = "Carimbo do Tempo emitido em:" + timestamp.getTimeStamp() + ", Pela autoridade:" + timestamp.getTimeStampAuthorityInfo() + ") N\u00famero de s\u00e9rie:" + timestamp.getSerialNumber();
                    verifyResponse.getTimeStampValidations().add(text);
                }
                verifyResponse.setNumberOfSignatures(numberOfSignature);
            } else {
                verifyResponse.setValid(false);
                verifyResponse.setHasError(true);
                instaSta.setSuccess(false);
            }
            instaSta.setWeb(fromWeb);
            Thread trVerify = new Thread(instaSta);
            trVerify.start();
            VerifyTimeStampResponse verifyTimeStampResponse = verifyResponse;
            return verifyTimeStampResponse;
        }
        catch (Throwable error) {
            Main.hideLoadingScreen();
            verifyResponse.setValid(false);
            verifyResponse.setHasError(true);
            verifyResponse.setMsgErro(error.getMessage());
            instaSta.setSuccess(false);
            instaSta.setWeb(fromWeb);
            Thread trVerify = new Thread(instaSta);
            trVerify.start();
            if (error.getCause() != null && error.getCause() instanceof InvocationTargetException) {
                logger.error(error.getMessage());
                throw new RuntimeException(error.getMessage(), error);
            }
            logger.error("Erro na valida\u00e7\u00e3o" + error.getMessage());
            VerifyTimeStampResponse verifyTimeStampResponse = verifyResponse;
            return verifyTimeStampResponse;
        }
        finally {
            Main.hideLoadingScreen();
        }
    }

    private void validateRequest(VerifyTimeStampRequest request) throws Exception {
        if (request.getType().isEmpty()) {
            logger.error("N\u00e3o foi informado um tipo de verifica\u00e7\u00e3o, use: Signature, Base64, Hash, Text ");
            throw new Exception("N\u00e3o foi informado um tipo de verifica\u00e7\u00e3o, use: Signature, Base64, Hash, Text ");
        }
        if (request.getType().equalsIgnoreCase("base64") || request.getType().equalsIgnoreCase("hash") || request.getType().equalsIgnoreCase("text") || request.getType().equalsIgnoreCase("signature")) {
            if (request.getInputTimeStamp().trim().isEmpty() && !request.getType().equalsIgnoreCase("signature")) {
                logger.error("N\u00e3o foi fornecido o Carimbo do Tempo inputTimeStamp!");
                throw new Exception("N\u00e3o foi fornecido o Carimbo do Tempo!");
            }
            if (request.getInputData().trim().isEmpty()) {
                logger.error("N\u00e3o foi fornecido o Conte\u00fado ou Assinatura para valida\u00e7\u00e3o do carimbo do tempo, no campo inputData!");
                throw new Exception("N\u00e3o foi fornecido o Conte\u00fado ou Assinatura para valida\u00e7\u00e3o do carimbo do tempo, no campo inputData!");
            }
        } else {
            logger.error("N\u00e3o foi informado um tipo de verifica\u00e7\u00e3o v\u00e1lido, use: Signature, Base64, Hash, Text ");
            throw new Exception("N\u00e3o foi informado um tipo de verifica\u00e7\u00e3o v\u00e1lido, use: Signature, Base64, Hash, Text ");
        }
    }
}

