/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.timestamp;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESTimeStampSigner;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCerts;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsRequest;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsResponse;
import org.demoiselle.signer.serpro.desktop.command.timestamp.ReqTimeStamp;
import org.demoiselle.signer.serpro.desktop.command.timestamp.RespTimeStamp;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.ListCertificateData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStamp
extends AbstractCommand<ReqTimeStamp, RespTimeStamp> {
    private static final Logger logger = LoggerFactory.getLogger(TimeStamp.class);
    private RespTimeStamp respTimeStampForSignature = new RespTimeStamp();
    String alias;
    PrivateKey privateKey;
    SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();

    @Override
    public RespTimeStamp doCommand(ReqTimeStamp request) throws Throwable {
        this.validateRequest(request);
        byte[] byteArrayInputData = request.getType().equalsIgnoreCase("text") ? this.contentToBytes(request.getInputData(), request.getTextEncoding()) : Base64Utils.base64Decode(request.getInputData());
        if (byteArrayInputData == null || byteArrayInputData.length <= 0) {
            Main.hideLoadingScreen();
            logger.error("Erro ao recuperar a conte\u00fado (" + request.getType() + ") para requisitar o carimbo do tempo: o conte\u00fado enviado est\u00e1 vazio!");
            throw new Exception("Erro ao recuperar a conte\u00fado (" + request.getType() + ") para requisitar o carimbo do tempo: o conte\u00fado enviado est\u00e1 vazio!");
        }
        ListCertsRequest requestCert = new ListCertsRequest();
        requestCert.setUseCertFor("Requisitar Carimbo do Tempo");
        ListCerts ls = new ListCerts();
        ListCertsResponse lr = ls.doCommand(requestCert);
        if (lr.getCertificates().isEmpty()) {
            logger.error("Nenhum certificado foi encontrado, verifique se seu token esta conectar ao computador, caso esteja feche e abra novamente o assinador.");
            throw new RuntimeException("Nenhum certificado foi encontrado, verifique se seu token esta conectar ao computador, caso esteja feche e abra novamente o assinador.");
        }
        if (lr.getCertificates().size() > 1) {
            ListCertificateData lcd = new ListCertificateData(lr);
            lcd.init();
            this.alias = lcd.getAlias();
            if (this.alias == null || this.alias.equals("")) {
                this.respTimeStampForSignature.setActionCanceled(true);
                return this.respTimeStampForSignature;
            }
        } else {
            ArrayList list = (ArrayList)lr.getCertificates();
            Certificate cert = (Certificate)list.iterator().next();
            this.alias = cert.getAlias();
        }
        KeyStore keyStore = ls.getKeyStore();
        this.privateKey = this.configSigner.isUseCertificateFile() || this.configSigner.isChooseFileCertificate() ? (PrivateKey)keyStore.getKey(this.alias, ls.getPass()) : (PrivateKey)keyStore.getKey(this.alias, null);
        CAdESTimeStampSigner varCAdESTimeStampSigner = new CAdESTimeStampSigner();
        varCAdESTimeStampSigner.setCertificates(keyStore.getCertificateChain(this.alias));
        varCAdESTimeStampSigner.setPrivateKey(this.privateKey);
        logger.info("Usando provider: " + keyStore.getProvider().getName());
        Statistics instaSta = new Statistics();
        switch (request.getSignaturePolicy()) {
            case "RB": {
                throw new Exception("Para carimbo do tempo n\u00e3o pode ser informada a pol\u00edtica RB!");
            }
            case "RT": {
                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3.name());
                varCAdESTimeStampSigner.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3);
                break;
            }
            case "RV": {
                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3.name());
                varCAdESTimeStampSigner.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3);
                break;
            }
            case "RC": {
                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3.name());
                varCAdESTimeStampSigner.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3);
                break;
            }
            case "RA": {
                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4.name());
                varCAdESTimeStampSigner.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4);
                break;
            }
            default: {
                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3.name());
                varCAdESTimeStampSigner.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3);
            }
        }
        instaSta.setAction("TimeStamp");
        instaSta.setType(request.getType());
        instaSta.setLengthOriginalContent(byteArrayInputData.length);
        instaSta.setStart(System.currentTimeMillis());
        try {
            instaSta.setToken(keyStore.getProvider().getName());
            BasicCertificate bc = new BasicCertificate((X509Certificate)keyStore.getCertificate(this.alias));
            instaSta.setCaURL(bc.getAuthorityInfoAccess().iterator().next());
        }
        catch (Throwable bc) {
            // empty catch block
        }
        byte[] signatureWithTimeStamp = null;
        switch (request.getType().toLowerCase()) {
            case "signature": {
                signatureWithTimeStamp = varCAdESTimeStampSigner.doTimeStampForSignature(byteArrayInputData);
                break;
            }
            case "raw": {
                signatureWithTimeStamp = varCAdESTimeStampSigner.doTimeStampForContent(byteArrayInputData);
                break;
            }
            case "base64": {
                signatureWithTimeStamp = varCAdESTimeStampSigner.doTimeStampForContent(byteArrayInputData);
                break;
            }
            case "hash": {
                signatureWithTimeStamp = varCAdESTimeStampSigner.doTimeStampFromHashContent(byteArrayInputData);
                break;
            }
            case "text": {
                signatureWithTimeStamp = varCAdESTimeStampSigner.doTimeStampForContent(byteArrayInputData);
                break;
            }
            default: {
                throw new Exception("Tipo n\u00e3o reconhecido! Use: hash||text||raw||signature");
            }
        }
        byteArrayInputData = new byte[]{};
        instaSta.setEnd(System.currentTimeMillis());
        instaSta.setLengthSignature(signatureWithTimeStamp.length);
        instaSta.setSuccess(true);
        Thread trFCoSig = new Thread(instaSta);
        trFCoSig.start();
        this.respTimeStampForSignature.setRequestId(request.getRequestId());
        this.respTimeStampForSignature.setSignatureWithTimeStamp(Base64Utils.base64Encode(signatureWithTimeStamp));
        signatureWithTimeStamp = new byte[]{};
        return this.respTimeStampForSignature;
    }

    private void validateRequest(ReqTimeStamp request) throws Exception {
        if (request.getType().equals("")) {
            Main.hideLoadingScreen();
            logger.error("N\u00e3o foi informado o tipo do Cont\u00e9udo para requisitar o Carimbo de Tempo (Signature, Base64, Hash ou Text");
            throw new Exception("N\u00e3o foi informado o tipo do Cont\u00e9udo para requisitar o Carimbo de Tempo (Signature, Base64, Hash ou Text");
        }
        switch (request.getType().toLowerCase()) {
            case "hash": {
                if (!request.getInputData().trim().isEmpty()) break;
                throw new Exception("N\u00e3o foi fornecido um resumo de arquivo (Hash) em base64 para o qual ser\u00e1 gerado o carimbo do tempo!");
            }
            case "text": {
                if (!request.getInputData().equals("")) break;
                throw new Exception("N\u00e3o foi fornecido um texto para o qual ser\u00e1 gerado um carimbo do Tempo!");
            }
            case "signature": {
                if (!request.getInputData().trim().isEmpty()) break;
                throw new Exception("N\u00e3o foi fornecido uma Assinatura  em base64 para a qual ser\u00e1 gerado o carimbo do tempo!");
            }
            case "raw": {
                if (!request.getInputData().trim().isEmpty()) break;
                throw new Exception("N\u00e3o foi fornecido uma Assinatura  em base64 para a qual ser\u00e1 gerado o carimbo do tempo!");
            }
            case "base64": {
                if (!request.getInputData().trim().isEmpty()) break;
                throw new Exception("N\u00e3o foi fornecido uma Assinatura  em base64 para a qual ser\u00e1 gerado o carimbo do tempo!");
            }
            default: {
                throw new Exception("Tipo n\u00e3o reconhecido! Use: hash||text||raw||signature");
            }
        }
    }
}

