/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.signer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.security.auth.login.LoginException;
import javax.swing.JFileChooser;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.cades.factory.PKCS7Factory;
import org.demoiselle.signer.policy.impl.cades.pkcs7.PKCS7Signer;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESTimeStampSigner;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.CertUtils;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.cert.LogoutPKCS11;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.command.signer.SignResponse;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.demoiselle.signer.serpro.desktop.ui.PinHandlerFile;
import org.demoiselle.signer.serpro.desktop.ui.commons.FileChooserSigner;
import org.demoiselle.signer.serpro.desktop.ui.pdf.WebIntegratedSignature;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sign
extends AbstractCommand<SignRequest, SignResponse> {
    private static final Logger logger = LoggerFactory.getLogger(Sign.class);
    private SignResponse response = new SignResponse();
    private boolean oldRequest = false;
    SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
    private Date certExpDate;

    private String getStringType(String type) {
        if (type.equalsIgnoreCase("text")) {
            return "Texto";
        }
        if (type.equalsIgnoreCase("hash")) {
            return "Somente Resumo (Hash)";
        }
        if (type.equalsIgnoreCase("file")) {
            return "Arquivo";
        }
        if (type.equalsIgnoreCase("base64")) {
            return "Conte\u00fado em Base64";
        }
        if (type.equalsIgnoreCase("PDF")) {
            return "Arquivo PDF";
        }
        if (type.equalsIgnoreCase("timeStampOnly")) {
            return "Carimbo do Tempo";
        }
        return "Desconhecido";
    }

    @Override
    public SignResponse doCommand(SignRequest request) throws Exception {
        return this.doCommand(request, new BatchSignatureContext());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignResponse doCommand(SignRequest request, BatchSignatureContext batchSignatureContext) throws Exception {
        Object fileName;
        this.validateRequest(request);
        boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
        String prefix = request.getHostConnectedPrefix();
        String varAction = "Assinar ";
        if (request.getType().equalsIgnoreCase("timeStampOnly")) {
            varAction = "Requisitar ";
        }
        PinHandlerFile pinFile = new PinHandlerFile(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
        PinHandler pinToken = new PinHandler(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
        char[] pass = null;
        Statistics instaSta = new Statistics();
        KeyStore keyStore = null;
        try {
            PKCS7Signer signer;
            PrivateKey privateKey;
            X509Certificate cert;
            String alias;
            block122: {
                byte[] byteArrayOriginalInputData;
                Object fileChooser;
                block133: {
                    block131: {
                        Object oldHashReturn;
                        block128: {
                            block126: {
                                Iterator<String> iterator;
                                String oldSignReturn;
                                String varSO;
                                block124: {
                                    File selectedFile2;
                                    int returnValue;
                                    block132: {
                                        block130: {
                                            block129: {
                                                block127: {
                                                    block125: {
                                                        block123: {
                                                            Map.Entry<String, String> item;
                                                            Main.showLoadingScreen(prefix);
                                                            if (this.configSigner.isUseCertificateFile() || this.configSigner.isChooseFileCertificate()) {
                                                                File filep12;
                                                                pinToken = null;
                                                                Main.hideLoadingScreen();
                                                                if (this.configSigner.isChooseFileCertificate()) {
                                                                    if (batchSignatureContext != null && batchSignatureContext.isKeyStoreSelected()) {
                                                                        filep12 = new File(batchSignatureContext.getKeyStore());
                                                                        pass = this.configSigner.getCertificateFilePass();
                                                                    } else {
                                                                        filep12 = FileUtil.selectA1Certificate();
                                                                        pinFile.init();
                                                                        if (pinFile.getActionCanceled()) {
                                                                            logger.info("Assinatura cancelada pelo Usu\u00e1rio");
                                                                            throw new RuntimeException("Assinatura cancelada pelo usu\u00e1rio");
                                                                        }
                                                                        pass = pinFile.getPwd();
                                                                        this.configSigner.setCertificateFilePass(pass);
                                                                    }
                                                                } else {
                                                                    filep12 = new File(this.configSigner.getCertificateFilePath());
                                                                    if (this.configSigner.isSaveCertificateFilePass()) {
                                                                        pass = this.configSigner.getCertificateFilePass();
                                                                    } else {
                                                                        pinFile.init();
                                                                        if (pinFile.getActionCanceled()) {
                                                                            logger.info("Assinatura cancelada pelo usu\u00e1rio");
                                                                            throw new RuntimeException("Assinatura cancelada pelo usu\u00e1rio");
                                                                        }
                                                                        pass = pinFile.getPwd();
                                                                    }
                                                                }
                                                                KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader(filep12);
                                                                keyStore = loader.getKeyStore(String.copyValueOf(pass));
                                                                if (batchSignatureContext != null && !batchSignatureContext.isKeyStoreSelected()) {
                                                                    batchSignatureContext.setKeyStore(filep12.getAbsolutePath());
                                                                }
                                                            } else {
                                                                KeystoreSelection ks;
                                                                Iterator<Map.Entry<String, String>> it;
                                                                pinFile = null;
                                                                if (this.configSigner.isLogOffToken()) {
                                                                    new LogoutPKCS11().doCommand((Request)null);
                                                                }
                                                                if (this.configSigner.isUseNeoId()) {
                                                                    it = Configuration.getInstance().getDrivers().entrySet().iterator();
                                                                    while (it.hasNext()) {
                                                                        item = it.next();
                                                                        if (item.getKey().contains("neoid")) continue;
                                                                        it.remove();
                                                                    }
                                                                }
                                                                if (this.configSigner.isSelectedToken()) {
                                                                    it = Configuration.getInstance().getDrivers().entrySet().iterator();
                                                                    while (it.hasNext()) {
                                                                        item = it.next();
                                                                        if (item.getKey().equalsIgnoreCase(this.configSigner.getTokenNameSelected())) continue;
                                                                        it.remove();
                                                                    }
                                                                }
                                                                if ((keyStore = (ks = new KeystoreSelection(pinToken, batchSignatureContext)).getKeyStore()) == null) {
                                                                    this.response.setActionCanceled(true);
                                                                    item = this.response;
                                                                    return item;
                                                                }
                                                            }
                                                            alias = CertUtils.getAlias(request.getAlias(), keyStore, batchSignatureContext);
                                                            if (this.response.getActionCanceled()) {
                                                                item = this.response;
                                                                return item;
                                                            }
                                                            fileName = "";
                                                            if (!request.getType().equalsIgnoreCase("file")) {
                                                                String homeUser = System.getProperty("user.home");
                                                                fileName = homeUser + File.separator + GregorianCalendar.getInstance().getTimeInMillis();
                                                            }
                                                            cert = (X509Certificate)keyStore.getCertificate(alias);
                                                            privateKey = null;
                                                            privateKey = this.configSigner.isUseCertificateFile() || this.configSigner.isChooseFileCertificate() ? (PrivateKey)keyStore.getKey(alias, pass) : (PrivateKey)keyStore.getKey(alias, null);
                                                            signer = PKCS7Factory.getInstance().factoryDefault();
                                                            signer.setCertificates(keyStore.getCertificateChain(alias));
                                                            signer.setPrivateKey(privateKey);
                                                            varSO = System.getProperty("os.name");
                                                            try {
                                                                signer.setAlgorithm(SignerAlgorithmEnum.valueOf(request.getAlgorithm()));
                                                                if (varSO.contains("indows")) {
                                                                    logger.info("Windows detected, Algorithm setted to SHA256");
                                                                    signer.setAlgorithm(SignerAlgorithmEnum.SHA256withRSA);
                                                                }
                                                            }
                                                            catch (Throwable error) {
                                                                signer.setAlgorithm(SignerAlgorithmEnum.DEFAULT);
                                                            }
                                                            switch (request.getSignaturePolicy()) {
                                                                case "RB": {
                                                                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                                                                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                                                                    break;
                                                                }
                                                                case "RT": {
                                                                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3.name());
                                                                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3);
                                                                    break;
                                                                }
                                                                case "RV": {
                                                                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3.name());
                                                                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3);
                                                                    break;
                                                                }
                                                                case "RC": {
                                                                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3.name());
                                                                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3);
                                                                    break;
                                                                }
                                                                case "RA": {
                                                                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4.name());
                                                                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4);
                                                                    break;
                                                                }
                                                                default: {
                                                                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                                                                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                                                                }
                                                            }
                                                            if (this.configSigner.isLcrOff()) {
                                                                ConfigurationRepo.getInstance().setValidateLCR(false);
                                                                logger.warn("Assinando sem valida\u00e7\u00e3o de LCR!");
                                                            }
                                                            if (!request.getType().equalsIgnoreCase("hash")) break block123;
                                                            instaSta.setType("hash");
                                                            Main.showLoadingScreen(prefix);
                                                            oldHashReturn = "";
                                                            oldSignReturn = "";
                                                            iterator = request.getListOfInputData().iterator();
                                                            break block124;
                                                        }
                                                        if (!request.getType().equalsIgnoreCase("securefile")) break block125;
                                                        instaSta.setType("secureFile");
                                                        Main.showLoadingScreen(prefix);
                                                        oldHashReturn = request.getListOfInputData().iterator();
                                                        break block126;
                                                    }
                                                    if (!request.getType().equalsIgnoreCase("text")) break block127;
                                                    instaSta.setType("text");
                                                    Main.showLoadingScreen(prefix);
                                                    oldHashReturn = request.getListOfInputData().iterator();
                                                    break block128;
                                                }
                                                if (!request.getType().equalsIgnoreCase("file")) break block129;
                                                instaSta.setType("file");
                                                fileChooser = new FileChooserSigner();
                                                ((JFileChooser)fileChooser).setDialogTitle("Escolha o arquivo que ser\u00e1 assinado");
                                                returnValue = -1;
                                                if (request.getFileName().isEmpty()) {
                                                    returnValue = ((JFileChooser)fileChooser).showOpenDialog(null);
                                                } else {
                                                    ((JFileChooser)fileChooser).setSelectedFile(new File(request.getFileName()));
                                                    returnValue = 0;
                                                }
                                                if (returnValue == 0) {
                                                    long fileLimite;
                                                    Main.showLoadingScreen(prefix);
                                                    selectedFile2 = ((JFileChooser)fileChooser).getSelectedFile();
                                                    fileName = selectedFile2.getAbsolutePath();
                                                    byte[] byteFile = null;
                                                    if (selectedFile2.length() == 0L) {
                                                        throw new Exception("O arquivo est\u00e1 vazio, favor verificar.");
                                                    }
                                                    long fileSize = selectedFile2.length();
                                                    if (fileSize > (fileLimite = (long)(0x100000 * this.configSigner.getSizePDF()))) {
                                                        logger.info("O arquivo n\u00e3o pode ser maior que " + this.configSigner.getSizePDF() + " MB !");
                                                        throw new Exception("O arquivo n\u00e3o pode ser maior que " + this.configSigner.getSizePDF() + " MB ! \n Verifique suas configura\u00e7\u00f5es");
                                                    }
                                                    FileInputStream is = new FileInputStream(selectedFile2);
                                                    byteFile = new byte[(int)selectedFile2.length()];
                                                    is.read(byteFile);
                                                    is.close();
                                                    instaSta.setLengthOriginalContent(byteFile.length);
                                                    instaSta.setStart(System.currentTimeMillis());
                                                    boolean varAttached = Boolean.parseBoolean(request.getAttached().toLowerCase());
                                                    byte[] temp = varAttached ? signer.doAttachedSign(byteFile) : signer.doDetachedSign(byteFile);
                                                    instaSta.setEnd(System.currentTimeMillis());
                                                    instaSta.setLengthSignature(temp.length);
                                                    String signature = Base64Utils.base64Encode(temp);
                                                    this.response.getListOfSignatures().add(signature);
                                                    this.response.setSignature(signature);
                                                    signature = null;
                                                    if (request.getOutputDataType().equalsIgnoreCase("file")) {
                                                        this.response.getListOfOriginalContents().add((String)fileName);
                                                        this.response.setOriginal((String)fileName);
                                                        this.response.setOriginalFileName((String)fileName);
                                                        fileName = (String)fileName + ".p7s";
                                                        File fw = new File((String)fileName);
                                                        FileOutputStream os = new FileOutputStream(fw);
                                                        os.write(temp);
                                                        os.flush();
                                                        os.close();
                                                        this.response.setSignature((String)fileName);
                                                    } else {
                                                        MessageDigest md = MessageDigest.getInstance("SHA-256");
                                                        byte[] hashOriginal = md.digest(byteFile);
                                                        String fileOriginal = Base64Utils.base64Encode(byteFile);
                                                        String hashOriginalHex = Hex.toHexString(hashOriginal);
                                                        hashOriginal = new byte[]{};
                                                        this.response.getListOfOriginalContents().add(hashOriginalHex);
                                                        this.response.setOriginal(fileOriginal);
                                                        this.response.setOriginalFileName((String)fileName);
                                                    }
                                                    byteFile = new byte[]{};
                                                    temp = new byte[]{};
                                                    break block122;
                                                } else if (returnValue == 1) {
                                                    this.response.setActionCanceled(true);
                                                    SignResponse selectedFile2 = this.response;
                                                    return selectedFile2;
                                                }
                                                break block122;
                                            }
                                            if (!request.getType().equalsIgnoreCase("base64")) break block130;
                                            instaSta.setType("base64");
                                            Main.showLoadingScreen(prefix);
                                            fileChooser = request.getListOfInputData().iterator();
                                            break block131;
                                        }
                                        if (!request.getType().equalsIgnoreCase("PDF")) break block132;
                                        instaSta.setType("PDF");
                                        Main.showLoadingScreen(prefix);
                                        fileChooser = request.getListOfInputData().iterator();
                                        break block133;
                                    }
                                    if (request.getType().equalsIgnoreCase("timeStampOnly")) {
                                        instaSta.setType("timeStampOnly");
                                        fileChooser = new FileChooserSigner();
                                        ((JFileChooser)fileChooser).setDialogTitle("Escolha o arquivo para gerar o Carimbo do Tempo");
                                        returnValue = ((JFileChooser)fileChooser).showOpenDialog(null);
                                        if (returnValue == 0) {
                                            long fileLimite;
                                            Main.showLoadingScreen(prefix);
                                            selectedFile2 = ((JFileChooser)fileChooser).getSelectedFile();
                                            fileName = selectedFile2.getAbsolutePath();
                                            byte[] byteFile = null;
                                            if (selectedFile2.length() == 0L) {
                                                throw new Exception("O arquivo est\u00e1 vazio, favor verificar.");
                                            }
                                            long fileSize = selectedFile2.length();
                                            if (fileSize > (fileLimite = (long)(0x100000 * this.configSigner.getSizePDF()))) {
                                                logger.error("O arquivo n\u00e3o pode ser maior que " + this.configSigner.getSizePDF() + " MB!");
                                                throw new Exception("O arquivo n\u00e3o pode ser maior que " + this.configSigner.getSizePDF() + " MB!\n Verifique suas configura\u00e7\u00f5es");
                                            }
                                            FileInputStream is = new FileInputStream(selectedFile2);
                                            byteFile = new byte[(int)selectedFile2.length()];
                                            is.read(byteFile);
                                            is.close();
                                            instaSta.setLengthOriginalContent(byteFile.length);
                                            instaSta.setStart(System.currentTimeMillis());
                                            CAdESTimeStampSigner varCAdESTimeStampSigner = new CAdESTimeStampSigner();
                                            varCAdESTimeStampSigner.setCertificates(keyStore.getCertificateChain(alias));
                                            varCAdESTimeStampSigner.setPrivateKey(privateKey);
                                            byte[] temp = varCAdESTimeStampSigner.doTimeStampForContent(byteFile);
                                            byteFile = new byte[]{};
                                            instaSta.setEnd(System.currentTimeMillis());
                                            instaSta.setLengthSignature(temp.length);
                                            if (request.getOutputDataType().equalsIgnoreCase("file")) {
                                                fileName = (String)fileName + ".timestamp.p7s";
                                                File fw = new File((String)fileName);
                                                FileOutputStream os = new FileOutputStream(fw);
                                                os.write(temp);
                                                os.flush();
                                                os.close();
                                                if (this.oldRequest) {
                                                    this.response.setOriginal((String)fileName);
                                                } else {
                                                    this.response.getListOfOriginalContents().add((String)fileName);
                                                }
                                                this.response.setOriginalFileName((String)fileName);
                                                this.response.setSignature((String)fileName);
                                            } else {
                                                if (this.oldRequest) {
                                                    this.response.setSignature(Base64Utils.base64Encode(temp));
                                                } else {
                                                    this.response.getListOfSignatures().add(Base64Utils.base64Encode(temp));
                                                }
                                                MessageDigest md = MessageDigest.getInstance("SHA-256");
                                                byte[] hashOriginal = md.digest(byteFile);
                                                String hashOriginalHex = Hex.toHexString(hashOriginal);
                                                hashOriginal = new byte[]{};
                                                if (this.oldRequest) {
                                                    this.response.setOriginal(hashOriginalHex);
                                                } else {
                                                    this.response.getListOfOriginalContents().add(hashOriginalHex);
                                                }
                                            }
                                            byteFile = new byte[]{};
                                            temp = new byte[]{};
                                            break block122;
                                        } else if (returnValue == 1) {
                                            ConfigurationRepo.getInstance().setValidateLCR(true);
                                            this.response.setActionCanceled(true);
                                            SignResponse selectedFile3 = this.response;
                                            return selectedFile3;
                                        }
                                    }
                                    break block122;
                                }
                                while (iterator.hasNext()) {
                                    SignResponse signResponse;
                                    String hash = iterator.next();
                                    logger.debug("Hash a ser assinado: " + hash);
                                    if (varSO.contains("indows")) {
                                        if (hash.length() > 44) {
                                            this.response.setRequestId(request.getRequestId());
                                            this.response.setHasError(true);
                                            this.response.setMsgError("O HASH para assinatura em ambiente Windows deve ser SHA-256!");
                                            logger.error("O HASH para assinatura em ambiente Windows deve ser SHA-256!, input: " + hash);
                                            signResponse = this.response;
                                            return signResponse;
                                        }
                                    } else if (hash.length() < 88) {
                                        this.response.setRequestId(request.getRequestId());
                                        this.response.setHasError(true);
                                        this.response.setMsgError("O HASH para assinatura em ambiente Linux ou MAC deve ser SHA-512!");
                                        logger.error("O HASH para assinatura em ambiente Linux ou MAC deve ser SHA-512!, input: " + hash);
                                        signResponse = this.response;
                                        return signResponse;
                                    }
                                    if (this.oldRequest) {
                                        oldHashReturn = oldHashReturn + hash + " ";
                                    } else {
                                        this.response.getListOfOriginalContents().add(hash);
                                    }
                                    byte[] byteArrayOriginalInputData2 = Base64Utils.base64Decode(hash);
                                    instaSta.setLengthOriginalContent(byteArrayOriginalInputData2.length);
                                    instaSta.setStart(System.currentTimeMillis());
                                    byte[] temp = signer.doHashSign(byteArrayOriginalInputData2);
                                    instaSta.setEnd(System.currentTimeMillis());
                                    instaSta.setLengthSignature(temp.length);
                                    if (this.oldRequest) {
                                        oldSignReturn = oldSignReturn + Base64Utils.base64Encode(temp) + " ";
                                    } else {
                                        this.response.getListOfSignatures().add(Base64Utils.base64Encode(temp));
                                    }
                                    byteArrayOriginalInputData2 = new byte[]{};
                                    temp = new byte[]{};
                                }
                                if (!((String)oldHashReturn).isEmpty()) {
                                    this.response.setOriginal((String)oldHashReturn);
                                }
                                if (!oldSignReturn.isEmpty()) {
                                    this.response.setSignature(oldSignReturn.trim());
                                }
                                break block122;
                            }
                            while (oldHashReturn.hasNext()) {
                                String secureFile = (String)oldHashReturn.next();
                                if (this.oldRequest) {
                                    this.response.setOriginal(secureFile);
                                } else {
                                    this.response.getListOfOriginalContents().add(secureFile);
                                }
                                byteArrayOriginalInputData = Base64.decode(secureFile);
                                instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                                instaSta.setStart(System.currentTimeMillis());
                                byte[] temp = signer.doAttachedSign(byteArrayOriginalInputData);
                                instaSta.setEnd(System.currentTimeMillis());
                                instaSta.setLengthSignature(temp.length);
                                if (this.oldRequest) {
                                    this.response.setSignature(Base64Utils.base64Encode(temp));
                                } else {
                                    this.response.getListOfSignatures().add(Base64Utils.base64Encode(temp));
                                }
                                byteArrayOriginalInputData = new byte[]{};
                                temp = new byte[]{};
                            }
                            break block122;
                        }
                        while (oldHashReturn.hasNext()) {
                            String text = oldHashReturn.next();
                            if (this.oldRequest) {
                                this.response.setOriginal(text);
                            } else {
                                this.response.getListOfOriginalContents().add(text);
                            }
                            byteArrayOriginalInputData = this.contentToBytes(text, request.getTextEncoding());
                            instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                            boolean varAttached = Boolean.parseBoolean(request.getAttached().toLowerCase());
                            instaSta.setStart(System.currentTimeMillis());
                            byte[] temp = varAttached ? signer.doAttachedSign(byteArrayOriginalInputData) : signer.doDetachedSign(byteArrayOriginalInputData);
                            instaSta.setEnd(System.currentTimeMillis());
                            instaSta.setLengthSignature(temp.length);
                            if (this.oldRequest) {
                                this.response.setSignature(Base64Utils.base64Encode(temp));
                            } else {
                                this.response.getListOfSignatures().add(Base64Utils.base64Encode(temp));
                            }
                            byteArrayOriginalInputData = new byte[]{};
                            temp = new byte[]{};
                        }
                        break block122;
                    }
                    while (fileChooser.hasNext()) {
                        String base64 = (String)fileChooser.next();
                        byteArrayOriginalInputData = Base64Utils.base64Decode(base64);
                        if (this.oldRequest) {
                            this.response.setOriginal(base64);
                        } else {
                            this.response.getListOfOriginalContents().add(base64);
                        }
                        instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                        instaSta.setStart(System.currentTimeMillis());
                        boolean varAttached = Boolean.parseBoolean(request.getAttached().toLowerCase());
                        byte[] temp = varAttached ? signer.doAttachedSign(byteArrayOriginalInputData) : signer.doDetachedSign(byteArrayOriginalInputData);
                        instaSta.setEnd(System.currentTimeMillis());
                        instaSta.setLengthSignature(temp.length);
                        if (this.oldRequest) {
                            this.response.setSignature(Base64Utils.base64Encode(temp));
                        } else {
                            this.response.getListOfSignatures().add(Base64Utils.base64Encode(temp));
                        }
                        temp = new byte[]{};
                        byteArrayOriginalInputData = new byte[]{};
                    }
                    break block122;
                }
                while (fileChooser.hasNext()) {
                    String pdf = (String)fileChooser.next();
                    byteArrayOriginalInputData = Base64Utils.base64Decode(pdf);
                    instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                    instaSta.setStart(System.currentTimeMillis());
                    WebIntegratedSignature wis = Boolean.TRUE.equals(request.getPdfInvisibleSignature()) ? new WebIntegratedSignature(request.getSignaturePolicy(), byteArrayOriginalInputData, request.getPdfInvisibleSignature(), batchSignatureContext) : (request.getPdfStampPage() >= 1 && request.getPdfStampPosX() >= 1 && request.getPdfStampPosY() >= 1 ? new WebIntegratedSignature(request.getSignaturePolicy(), byteArrayOriginalInputData, batchSignatureContext, request.getPdfStampPosX(), request.getPdfStampPosY(), request.getPdfStampPage()) : new WebIntegratedSignature(request.getSignaturePolicy(), byteArrayOriginalInputData, batchSignatureContext));
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    byte[] hashOriginal = md.digest(byteArrayOriginalInputData);
                    String hashOriginalHex = Hex.toHexString(hashOriginal);
                    hashOriginal = new byte[]{};
                    byte[] temp = wis.makeSignature();
                    instaSta.setEnd(System.currentTimeMillis());
                    instaSta.setLengthSignature(temp.length);
                    if (request.getOutputDataType().equalsIgnoreCase("file")) {
                        fileName = request.getFileName();
                        this.response.getListOfOriginalContents().add((String)fileName);
                        this.response.setOriginalFileName((String)fileName);
                        String homeUser = System.getProperty("user.home");
                        String signedFile = homeUser + File.separator + (String)fileName + "_assinado.pdf";
                        File fw = new File(signedFile);
                        FileOutputStream os = new FileOutputStream(fw);
                        os.write(temp);
                        os.flush();
                        os.close();
                        this.response.setSignature(signedFile);
                    } else if (this.oldRequest) {
                        this.response.setSignature(Base64Utils.base64Encode(temp));
                    } else {
                        this.response.getListOfSignatures().add(Base64Utils.base64Encode(temp));
                    }
                    temp = new byte[]{};
                    byteArrayOriginalInputData = new byte[]{};
                    if (this.oldRequest) {
                        this.response.setOriginal(hashOriginalHex);
                        continue;
                    }
                    this.response.getListOfOriginalContents().add(hashOriginalHex);
                }
            }
            this.response.setRequestId(request.getRequestId());
            this.response.setPublicKey(Base64Utils.base64Encode(cert.getPublicKey().getEncoded()));
            Certificate by = new Certificate();
            by.setAlias(alias);
            by.setProvider(keyStore.getProvider().getName());
            by.setSubject(cert.getSubjectDN().getName());
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
            sdf.applyPattern("dd MMM yyyy HH:mm:ss z");
            by.setNotAfter(sdf.format(cert.getNotAfter()));
            by.setNotBefore(sdf.format(cert.getNotBefore()));
            this.setCertExpDate(cert.getNotAfter());
            this.response.setBy(by);
            this.response.setNotAfterDateCertificate(cert.getNotAfter());
            instaSta.setToken(keyStore.getProvider().getName());
            instaSta.setAlgorithm(signer.getAlgorithm());
            instaSta.setSuccess(true);
            BasicCertificate bc = new BasicCertificate(cert);
            try {
                instaSta.setCaURL(bc.getAuthorityInfoAccess().iterator().next());
            }
            catch (Throwable error) {
                ConfigurationRepo.getInstance().setValidateLCR(true);
                logger.error(error.getMessage());
            }
            ConfigurationRepo.getInstance().setValidateLCR(true);
            logger.info("Assinado por: " + cert.getSubjectDN().getName());
            if (this.configSigner.isLogOffToken()) {
                keyStore = null;
                pinFile = null;
                pinToken = null;
                cert = null;
                privateKey = null;
                signer = null;
            }
            Main.hideLoadingScreen();
            SignResponse signResponse = this.response;
            return signResponse;
        }
        catch (Throwable error) {
            instaSta.setSuccess(false);
            ConfigurationRepo.getInstance().setValidateLCR(true);
            if (error.getMessage().toLowerCase().contains("cancel")) {
                if (pinToken == null) {
                    this.response.setActionCanceled(true);
                    fileName = this.response;
                    return fileName;
                }
                pinToken.setActionCanceled(true);
            }
            if (error.getCause() != null && error.getCause() instanceof InvocationTargetException) {
                Object trSign;
                InvocationTargetException targetException = (InvocationTargetException)error.getCause();
                if (pinFile != null && pinFile.getActionCanceled()) {
                    this.response.setActionCanceled(true);
                    trSign = this.response;
                    return trSign;
                }
                if (pinToken != null && pinToken.getActionCanceled()) {
                    this.response.setActionCanceled(true);
                    trSign = this.response;
                    return trSign;
                }
                if (pinToken != null && !pinToken.getActionCanceled()) {
                    this.response.setActionCanceled(false);
                    throw new RuntimeException(error.getMessage(), error);
                }
                if (targetException.getTargetException() != null && targetException.getTargetException() instanceof LoginException) {
                    this.response.setActionCanceled(true);
                    trSign = this.response;
                    return trSign;
                }
                logger.error(error.getMessage());
                throw new RuntimeException(error.getMessage(), error);
            }
            if (pinToken != null && pinToken.getActionCanceled()) {
                this.response.setActionCanceled(true);
                SignResponse signResponse = this.response;
                return signResponse;
            }
            if (pinToken != null && !pinToken.getActionCanceled()) {
                this.response.setActionCanceled(false);
                throw new RuntimeException(error.getMessage(), error);
            }
            ConfigurationRepo.getInstance().setValidateLCR(true);
            logger.error(error.getMessage());
            Main.hideLoadingScreen();
            throw new RuntimeException(error.getMessage(), error);
        }
        finally {
            ConfigurationRepo.getInstance().setValidateLCR(true);
            instaSta.setWeb(fromWeb);
            Thread trSign = new Thread(instaSta);
            trSign.start();
            Main.hideLoadingScreen();
        }
    }

    public Date getCertExpDate() {
        return this.certExpDate;
    }

    public void setCertExpDate(Date certExpDate) {
        this.certExpDate = certExpDate;
    }

    private void validateRequest(SignRequest request) throws Exception {
        if (request.getType().isEmpty()) {
            logger.error("N\u00e3o foi informado um tipo para assinatura, use: file||hash||text||base64||PDF||timeStampOnly ");
            throw new Exception("N\u00e3o foi informado um tipo para assinatura, use: file||hash||text||base64||PDF||timeStampOnly ");
        }
        if (!request.getInputData().trim().isEmpty()) {
            this.oldRequest = true;
            if (request.getType().equalsIgnoreCase("hash") && request.getInputData().contains(" ")) {
                String[] hashs;
                logger.warn("Est\u00e1 depreciado o par\u00e2metro InputData para assinatura em lote, use: listOfInputData, ex: \"listOfInputData\":[\"\"]");
                this.response.setMsgWarn("Est\u00e1 depreciado o par\u00e2metro InputData para assinatura em lote, use: listOfInputData, ex: \"listOfInputData\":[\"\"]");
                for (String hash : hashs = request.getInputData().split(" ")) {
                    request.getListOfInputData().add(hash);
                }
            } else {
                request.getListOfInputData().add(request.getInputData());
            }
        }
        switch (request.getType().toLowerCase()) {
            case "hash": {
                if (!request.getListOfInputData().isEmpty()) break;
                logger.error("N\u00e3o foi fornecido um resumo de arquivo (Hash) em base64 para ser assinado");
                throw new Exception("N\u00e3o foi fornecido um resumo de arquivo (Hash) em base64 para ser assinado");
            }
            case "text": {
                if (!request.getListOfInputData().isEmpty()) break;
                logger.error("N\u00e3o foi fornecido um texto para ser assinado");
                throw new Exception("N\u00e3o foi fornecido um texto para ser assinado");
            }
            case "base64": {
                if (!request.getListOfInputData().isEmpty()) break;
                logger.error("N\u00e3o foi fornecido um conte\u00fado em base64 para ser assinado");
                throw new Exception("N\u00e3o foi fornecido um conte\u00fado em base64 para ser assinado");
            }
            case "pdf": {
                if (request.getListOfInputData().isEmpty()) {
                    logger.error("N\u00e3o foi fornecido um conte\u00fado de um arquivo PDF em base64 para ser assinado");
                    throw new Exception("N\u00e3o foi fornecido um conte\u00fado de um arquivo PDF em base64 para ser assinado");
                }
                if (!request.getOutputDataType().equalsIgnoreCase("file") || !request.getFileName().trim().isEmpty()) break;
                logger.error("Quando informar o OutputDataType como File deve informar o FileName");
                throw new Exception("Quando informar o OutputDataType como File deve informar o FileName");
            }
            case "file": {
                break;
            }
            case "timestamponly": {
                break;
            }
            case "securefile": {
                break;
            }
            default: {
                logger.error("Tipo n\u00e3o reconhecido! Use: file||hash||text||base64||PDF||timeStampOnly||securefile");
                throw new Exception("Tipo n\u00e3o reconhecido! Use: file||hash||text||base64||PDF||timeStampOnly||securefile");
            }
        }
    }
}

