/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.signer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.security.auth.login.LoginException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.cades.factory.PKCS7Factory;
import org.demoiselle.signer.policy.impl.cades.pkcs7.PKCS7Signer;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.CertUtils;
import org.demoiselle.signer.serpro.desktop.command.cert.LogoutPKCS11;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.command.signer.PrepareRequest;
import org.demoiselle.signer.serpro.desktop.command.signer.PrepareResponse;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.demoiselle.signer.serpro.desktop.ui.PinHandlerFile;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareSign
extends AbstractCommand<PrepareRequest, PrepareResponse> {
    private static final Logger logger = LoggerFactory.getLogger(PrepareSign.class);
    private PrepareResponse response = new PrepareResponse();
    SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
    private Date certExpDate;

    private String getStringType(String type) {
        if (type.equalsIgnoreCase("text")) {
            return "Texto";
        }
        if (type.equalsIgnoreCase("hash")) {
            return "Somente Resumo (Hash)";
        }
        if (type.equalsIgnoreCase("base64")) {
            return "Conte\u00fado em Base64";
        }
        return "Desconhecido";
    }

    @Override
    public PrepareResponse doCommand(PrepareRequest request) throws Throwable {
        return this.doCommand(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrepareResponse doCommand(PrepareRequest request, BatchSignatureContext batchSignatureContext) throws Throwable {
        PKCS7Signer signer;
        PrivateKey privateKey;
        Object cert;
        String alias;
        KeyStore keyStore;
        Statistics instaSta;
        PinHandler pinToken;
        PinHandlerFile pinFile;
        boolean fromWeb;
        block71: {
            CMSSignedData varCSD;
            byte[] byteArrayOriginalInputData;
            Iterator<String> error2;
            block70: {
                String varSO;
                block69: {
                    this.validateRequest(request);
                    fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
                    String prefix = request.getHostConnectedPrefix();
                    String varAction = "Assinar ";
                    pinFile = new PinHandlerFile(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
                    pinToken = new PinHandler(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
                    char[] pass = null;
                    instaSta = new Statistics();
                    try {
                        Map.Entry<String, String> item;
                        Main.showLoadingScreen(prefix);
                        keyStore = null;
                        if (this.configSigner.isUseCertificateFile() || this.configSigner.isChooseFileCertificate()) {
                            File filep12;
                            pinToken = null;
                            Main.hideLoadingScreen();
                            if (this.configSigner.isChooseFileCertificate()) {
                                if (batchSignatureContext != null && batchSignatureContext.isKeyStoreSelected()) {
                                    filep12 = new File(batchSignatureContext.getKeyStore());
                                    pass = this.configSigner.getCertificateFilePass();
                                } else {
                                    filep12 = FileUtil.selectA1Certificate();
                                    pinFile.init();
                                    if (pinFile.getActionCanceled()) {
                                        logger.info("Assinatura cancelada pelo Usu\u00e1rio");
                                        throw new RuntimeException("Assinatura cancelada pelo usu\u00e1rio");
                                    }
                                    pass = pinFile.getPwd();
                                    this.configSigner.setCertificateFilePass(pass);
                                }
                            } else {
                                filep12 = new File(this.configSigner.getCertificateFilePath());
                                if (this.configSigner.isSaveCertificateFilePass()) {
                                    pass = this.configSigner.getCertificateFilePass();
                                } else {
                                    pinFile.init();
                                    if (pinFile.getActionCanceled()) {
                                        logger.info("Assinatura cancelada pelo usu\u00e1rio");
                                        throw new RuntimeException("Assinatura cancelada pelo usu\u00e1rio");
                                    }
                                    pass = pinFile.getPwd();
                                }
                            }
                            KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader(filep12);
                            keyStore = loader.getKeyStore(String.copyValueOf(pass));
                            if (batchSignatureContext != null && !batchSignatureContext.isKeyStoreSelected()) {
                                batchSignatureContext.setKeyStore(filep12.getAbsolutePath());
                            }
                        } else {
                            KeystoreSelection ks;
                            Iterator<Map.Entry<String, String>> it;
                            pinFile = null;
                            if (this.configSigner.isLogOffToken()) {
                                new LogoutPKCS11().doCommand((Request)null);
                            }
                            if (this.configSigner.isUseNeoId()) {
                                it = Configuration.getInstance().getDrivers().entrySet().iterator();
                                while (it.hasNext()) {
                                    item = it.next();
                                    if (item.getKey().contains("neoid")) continue;
                                    it.remove();
                                }
                            }
                            if (this.configSigner.isSelectedToken()) {
                                it = Configuration.getInstance().getDrivers().entrySet().iterator();
                                while (it.hasNext()) {
                                    item = it.next();
                                    if (item.getKey().equalsIgnoreCase(this.configSigner.getTokenNameSelected())) continue;
                                    it.remove();
                                }
                            }
                            if ((keyStore = (ks = new KeystoreSelection(pinToken, batchSignatureContext)).getKeyStore()) == null) {
                                this.response.setActionCanceled(true);
                                item = this.response;
                                return item;
                            }
                        }
                        alias = CertUtils.getAlias(request.getAlias(), keyStore, batchSignatureContext);
                        if (this.response.getActionCanceled()) {
                            item = this.response;
                            return item;
                        }
                        cert = (X509Certificate)keyStore.getCertificate(alias);
                        privateKey = null;
                        privateKey = this.configSigner.isUseCertificateFile() || this.configSigner.isChooseFileCertificate() ? (PrivateKey)keyStore.getKey(alias, pass) : (PrivateKey)keyStore.getKey(alias, null);
                        signer = PKCS7Factory.getInstance().factoryDefault();
                        signer.setCertificates(keyStore.getCertificateChain(alias));
                        signer.setPrivateKey(privateKey);
                        varSO = System.getProperty("os.name");
                        try {
                            signer.setAlgorithm(SignerAlgorithmEnum.valueOf(request.getAlgorithm()));
                            if (varSO.contains("indows")) {
                                logger.info("Windows detected, Algorithm setted to SHA256");
                                signer.setAlgorithm(SignerAlgorithmEnum.SHA256withRSA);
                            }
                        }
                        catch (Throwable error2) {
                            signer.setAlgorithm(SignerAlgorithmEnum.DEFAULT);
                        }
                        switch (request.getSignaturePolicy()) {
                            case "RB": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                                break;
                            }
                            case "RT": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3);
                                break;
                            }
                            case "RV": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3);
                                break;
                            }
                            case "RC": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3);
                                break;
                            }
                            case "RA": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4);
                                break;
                            }
                            default: {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                            }
                        }
                        if (this.configSigner.isLcrOff()) {
                            ConfigurationRepo.getInstance().setValidateLCR(false);
                            logger.warn("Assinando sem valida\u00e7\u00e3o de LCR!");
                        }
                        if (request.getType().equalsIgnoreCase("hash")) {
                            instaSta.setType("hash");
                            Main.showLoadingScreen(prefix);
                            error2 = request.getListOfInputData().iterator();
                            break block69;
                        }
                        if (request.getType().equalsIgnoreCase("text")) {
                            instaSta.setType("text");
                            Main.showLoadingScreen(prefix);
                            error2 = request.getListOfInputData().iterator();
                            break block70;
                        }
                        if (!request.getType().equalsIgnoreCase("base64")) break block71;
                        instaSta.setType("base64");
                        Main.showLoadingScreen(prefix);
                        for (String base64 : request.getListOfInputData()) {
                            byteArrayOriginalInputData = Base64Utils.base64Decode(base64);
                            instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                            instaSta.setStart(System.currentTimeMillis());
                            boolean varAttached = Boolean.parseBoolean(request.getAttached().toLowerCase());
                            varCSD = varAttached ? signer.prepareAttachedSign(byteArrayOriginalInputData) : signer.prepareDetachedSign(byteArrayOriginalInputData);
                            instaSta.setEnd(System.currentTimeMillis());
                            CMSProcessableByteArray cmsBytes = new CMSProcessableByteArray(varCSD.getEncoded());
                            byte[] bytes = (byte[])cmsBytes.getContent();
                            this.response.getListOfCMSSignedData().add(Base64Utils.base64Encode(bytes));
                            byteArrayOriginalInputData = new byte[]{};
                        }
                        break block71;
                    }
                    catch (Throwable error3) {
                        instaSta.setSuccess(false);
                        ConfigurationRepo.getInstance().setValidateLCR(true);
                        if (error3.getCause() != null && error3.getCause() instanceof InvocationTargetException) {
                            InvocationTargetException targetException = (InvocationTargetException)error3.getCause();
                            if (pinFile != null && pinFile.getActionCanceled()) {
                                this.response.setActionCanceled(true);
                                cert = this.response;
                                return cert;
                            }
                            if (pinToken != null && pinToken.getActionCanceled()) {
                                this.response.setActionCanceled(true);
                                cert = this.response;
                                return cert;
                            }
                            if (pinToken != null && !pinToken.getActionCanceled()) {
                                this.response.setActionCanceled(false);
                                throw new RuntimeException(error3.getMessage(), error3);
                            }
                            if (targetException.getTargetException() != null && targetException.getTargetException() instanceof LoginException) {
                                this.response.setActionCanceled(true);
                                cert = this.response;
                                return cert;
                            }
                            logger.error(error3.getMessage());
                            throw new RuntimeException(error3.getMessage(), error3);
                        }
                        if (pinToken != null && pinToken.getActionCanceled()) {
                            this.response.setActionCanceled(true);
                            PrepareResponse prepareResponse = this.response;
                            return prepareResponse;
                        }
                        if (pinToken != null && !pinToken.getActionCanceled()) {
                            this.response.setActionCanceled(false);
                            throw new RuntimeException(error3.getMessage(), error3);
                        }
                        ConfigurationRepo.getInstance().setValidateLCR(true);
                        logger.error(error3.getMessage());
                        Main.hideLoadingScreen();
                        throw new RuntimeException(error3.getMessage(), error3);
                    }
                }
                while (error2.hasNext()) {
                    String hash = (String)error2.next();
                    logger.debug("Hash a ser assinado: " + hash);
                    if (varSO.contains("indows")) {
                        if (hash.length() > 44) {
                            this.response.setRequestId(request.getRequestId());
                            this.response.setHasError(true);
                            this.response.setMsgError("O HASH para assinatura em ambiente Windows deve ser SHA-256!");
                            logger.error("O HASH para assinatura em ambiente Windows deve ser SHA-256!, input: " + hash);
                            return this.response;
                        }
                    } else if (hash.length() < 88) {
                        this.response.setRequestId(request.getRequestId());
                        this.response.setHasError(true);
                        this.response.setMsgError("O HASH para assinatura em ambiente Linux ou MAC deve ser SHA-512!");
                        logger.error("O HASH para assinatura em ambiente Linux ou MAC deve ser SHA-512!, input: " + hash);
                        return this.response;
                    }
                    byteArrayOriginalInputData = Base64Utils.base64Decode(hash);
                    instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                    instaSta.setStart(System.currentTimeMillis());
                    CMSSignedData varCSD2 = signer.prepareHashSign(byteArrayOriginalInputData);
                    instaSta.setEnd(System.currentTimeMillis());
                    CMSProcessableByteArray cmsBytes = new CMSProcessableByteArray(varCSD2.getEncoded());
                    byte[] bytes = (byte[])cmsBytes.getContent();
                    this.response.getListOfCMSSignedData().add(Base64Utils.base64Encode(bytes));
                    byteArrayOriginalInputData = new byte[]{};
                }
                break block71;
            }
            while (error2.hasNext()) {
                String text = error2.next();
                byteArrayOriginalInputData = this.contentToBytes(text, request.getTextEncoding());
                instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                boolean varAttached = Boolean.parseBoolean(request.getAttached().toLowerCase());
                instaSta.setStart(System.currentTimeMillis());
                varCSD = varAttached ? signer.prepareAttachedSign(byteArrayOriginalInputData) : signer.prepareDetachedSign(byteArrayOriginalInputData);
                instaSta.setEnd(System.currentTimeMillis());
                CMSProcessableByteArray cmsBytes = new CMSProcessableByteArray(varCSD.getEncoded());
                byte[] bytes = (byte[])cmsBytes.getContent();
                this.response.getListOfCMSSignedData().add(Base64Utils.base64Encode(bytes));
                byteArrayOriginalInputData = new byte[]{};
            }
        }
        this.response.setRequestId(request.getRequestId());
        this.response.setPublicKey(Base64Utils.base64Encode(((Certificate)cert).getPublicKey().getEncoded()));
        org.demoiselle.signer.serpro.desktop.command.cert.Certificate by = new org.demoiselle.signer.serpro.desktop.command.cert.Certificate();
        by.setAlias(alias);
        by.setProvider(keyStore.getProvider().getName());
        by.setSubject(((X509Certificate)cert).getSubjectDN().getName());
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
        sdf.applyPattern("dd MMM yyyy HH:mm:ss z");
        by.setNotAfter(sdf.format(((X509Certificate)cert).getNotAfter()));
        by.setNotBefore(sdf.format(((X509Certificate)cert).getNotBefore()));
        this.setCertExpDate(((X509Certificate)cert).getNotAfter());
        this.response.setBy(by);
        this.response.setNotAfterDateCertificate(((X509Certificate)cert).getNotAfter());
        instaSta.setToken(keyStore.getProvider().getName());
        instaSta.setAlgorithm(signer.getAlgorithm());
        instaSta.setSuccess(true);
        BasicCertificate bc = new BasicCertificate((X509Certificate)cert);
        try {
            instaSta.setCaURL(bc.getAuthorityInfoAccess().iterator().next());
        }
        catch (Throwable error) {
            ConfigurationRepo.getInstance().setValidateLCR(true);
            logger.error(error.getMessage());
        }
        ConfigurationRepo.getInstance().setValidateLCR(true);
        logger.info("Assinado por: " + ((X509Certificate)cert).getSubjectDN().getName());
        if (this.configSigner.isLogOffToken()) {
            keyStore = null;
            pinFile = null;
            pinToken = null;
            cert = null;
            privateKey = null;
            signer = null;
        }
        Main.hideLoadingScreen();
        return this.response;
        finally {
            ConfigurationRepo.getInstance().setValidateLCR(true);
            instaSta.setWeb(fromWeb);
            Thread trSign = new Thread(instaSta);
            trSign.start();
            Main.hideLoadingScreen();
        }
    }

    public Date getCertExpDate() {
        return this.certExpDate;
    }

    public void setCertExpDate(Date certExpDate) {
        this.certExpDate = certExpDate;
    }

    private void validateRequest(PrepareRequest request) throws Exception {
        if (request.getType().isEmpty()) {
            logger.error("N\u00e3o foi informado um tipo para assinatura, use: file||hash||text||base64||PDF||timeStampOnly ");
            throw new Exception("N\u00e3o foi informado um tipo para assinatura, use: file||hash||text||base64||PDF||timeStampOnly ");
        }
        switch (request.getType().toLowerCase()) {
            case "hash": {
                if (!request.getListOfInputData().isEmpty()) break;
                logger.error("N\u00e3o foi fornecido um resumo de arquivo (Hash) em base64 para ser assinado");
                throw new Exception("N\u00e3o foi fornecido um resumo de arquivo (Hash) em base64 para ser assinado");
            }
            case "text": {
                if (!request.getListOfInputData().isEmpty()) break;
                logger.error("N\u00e3o foi fornecido um texto para ser assinado");
                throw new Exception("N\u00e3o foi fornecido um texto para ser assinado");
            }
            case "base64": {
                if (!request.getListOfInputData().isEmpty()) break;
                logger.error("N\u00e3o foi fornecido um cont\u00e9udo em base64 para ser assinado");
                throw new Exception("N\u00e3o foi fornecido um cont\u00e9udo em base64 para ser assinado");
            }
            default: {
                logger.error("Tipo n\u00e3o reconhecido! Use: hash||text||base64");
                throw new Exception("Tipo n\u00e3o reconhecido! Use: hash||text||base64");
            }
        }
        if (request.getSignaturePolicy().isEmpty()) {
            logger.error("N\u00e3o foi informada nenhuma politica de assinatura, use: RB||RT||RV");
            throw new Exception("N\u00e3o foi informado um tipo para assinatura, use: file||hash||text||base64||PDF||timeStampOnly ");
        }
    }
}

