/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.signer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.security.auth.login.LoginException;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cms.CMSSignedData;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.impl.cades.factory.PKCS7Factory;
import org.demoiselle.signer.policy.impl.cades.pkcs7.PKCS7Signer;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.CertUtils;
import org.demoiselle.signer.serpro.desktop.command.cert.LogoutPKCS11;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.command.signer.PackageRequest;
import org.demoiselle.signer.serpro.desktop.command.signer.PackageResponse;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.demoiselle.signer.serpro.desktop.ui.PinHandlerFile;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageSign
extends AbstractCommand<PackageRequest, PackageResponse> {
    private static final Logger logger = LoggerFactory.getLogger(PackageSign.class);
    private PackageResponse response = new PackageResponse();
    SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
    private Date certExpDate;

    @Override
    public PackageResponse doCommand(PackageRequest request) throws Throwable {
        return this.doCommand(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PackageResponse doCommand(PackageRequest request, BatchSignatureContext batchSignatureContext) throws Throwable {
        Object cert;
        this.validateRequest(request);
        boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
        String prefix = request.getHostConnectedPrefix();
        String varAction = "Envelopar";
        PinHandlerFile pinFile = new PinHandlerFile(varAction + "Envelopar Assinatura", request.getHostConnectedPrefix());
        PinHandler pinToken = new PinHandler(varAction + "Envelopar Assinatura", request.getHostConnectedPrefix());
        char[] pass = null;
        Statistics instaSta = new Statistics();
        try {
            Map.Entry<String, String> item;
            Main.showLoadingScreen(prefix);
            KeyStore keyStore = null;
            if (this.configSigner.isUseCertificateFile() || this.configSigner.isChooseFileCertificate()) {
                File filep12;
                pinToken = null;
                Main.hideLoadingScreen();
                if (this.configSigner.isChooseFileCertificate()) {
                    if (batchSignatureContext != null && batchSignatureContext.isKeyStoreSelected()) {
                        filep12 = new File(batchSignatureContext.getKeyStore());
                        pass = this.configSigner.getCertificateFilePass();
                    } else {
                        filep12 = FileUtil.selectA1Certificate();
                        pinFile.init();
                        if (pinFile.getActionCanceled()) {
                            logger.info("Assinatura cancelada pelo Usu\u00e1rio");
                            throw new RuntimeException("Assinatura cancelada pelo usu\u00e1rio");
                        }
                        pass = pinFile.getPwd();
                        this.configSigner.setCertificateFilePass(pass);
                    }
                } else {
                    filep12 = new File(this.configSigner.getCertificateFilePath());
                    if (this.configSigner.isSaveCertificateFilePass()) {
                        pass = this.configSigner.getCertificateFilePass();
                    } else {
                        pinFile.init();
                        if (pinFile.getActionCanceled()) {
                            logger.info("Assinatura cancelada pelo usu\u00e1rio");
                            throw new RuntimeException("Assinatura cancelada pelo usu\u00e1rio");
                        }
                        pass = pinFile.getPwd();
                    }
                }
                KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader(filep12);
                keyStore = loader.getKeyStore(String.copyValueOf(pass));
                if (batchSignatureContext != null && !batchSignatureContext.isKeyStoreSelected()) {
                    batchSignatureContext.setKeyStore(filep12.getAbsolutePath());
                }
            } else {
                KeystoreSelection ks;
                Iterator<Map.Entry<String, String>> it;
                pinFile = null;
                if (this.configSigner.isLogOffToken()) {
                    new LogoutPKCS11().doCommand((Request)null);
                }
                if (this.configSigner.isUseNeoId()) {
                    it = Configuration.getInstance().getDrivers().entrySet().iterator();
                    while (it.hasNext()) {
                        item = it.next();
                        if (item.getKey().contains("neoid")) continue;
                        it.remove();
                    }
                }
                if (this.configSigner.isSelectedToken()) {
                    it = Configuration.getInstance().getDrivers().entrySet().iterator();
                    while (it.hasNext()) {
                        item = it.next();
                        if (item.getKey().equalsIgnoreCase(this.configSigner.getTokenNameSelected())) continue;
                        it.remove();
                    }
                }
                if ((keyStore = (ks = new KeystoreSelection(pinToken, batchSignatureContext)).getKeyStore()) == null) {
                    this.response.setActionCanceled(true);
                    item = this.response;
                    return item;
                }
            }
            String alias = CertUtils.getAlias(request.getAlias(), keyStore, batchSignatureContext);
            if (this.response.getActionCanceled()) {
                item = this.response;
                return item;
            }
            cert = (X509Certificate)keyStore.getCertificate(alias);
            PrivateKey privateKey = null;
            privateKey = this.configSigner.isUseCertificateFile() || this.configSigner.isChooseFileCertificate() ? (PrivateKey)keyStore.getKey(alias, pass) : (PrivateKey)keyStore.getKey(alias, null);
            PKCS7Signer signer = PKCS7Factory.getInstance().factoryDefault();
            signer.setCertificates(keyStore.getCertificateChain(alias));
            signer.setPrivateKey(privateKey);
            if (this.configSigner.isLcrOff()) {
                ConfigurationRepo.getInstance().setValidateLCR(false);
                logger.warn("Assinando sem valida\u00e7\u00e3o de LCR!");
            }
            Main.showLoadingScreen(prefix);
            for (String varCMSSignedData : request.getListOfInputData()) {
                instaSta.setStart(System.currentTimeMillis());
                byte[] byteArrayOriginalInputData = Base64Utils.base64Decode(varCMSSignedData);
                ContentInfo ci = ContentInfo.getInstance(ASN1Sequence.fromByteArray(byteArrayOriginalInputData));
                CMSSignedData signedData = new CMSSignedData(ci);
                byte[] signature = signer.envelopDetachedSign(signedData);
                this.response.getListOfSignatures().add(Base64Utils.base64Encode(signature));
                instaSta.setEnd(System.currentTimeMillis());
            }
            this.response.setRequestId(request.getRequestId());
            this.response.setPublicKey(Base64Utils.base64Encode(((Certificate)cert).getPublicKey().getEncoded()));
            org.demoiselle.signer.serpro.desktop.command.cert.Certificate by = new org.demoiselle.signer.serpro.desktop.command.cert.Certificate();
            by.setAlias(alias);
            by.setProvider(keyStore.getProvider().getName());
            by.setSubject(((X509Certificate)cert).getSubjectDN().getName());
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
            sdf.applyPattern("dd MMM yyyy HH:mm:ss z");
            by.setNotAfter(sdf.format(((X509Certificate)cert).getNotAfter()));
            by.setNotBefore(sdf.format(((X509Certificate)cert).getNotBefore()));
            this.setCertExpDate(((X509Certificate)cert).getNotAfter());
            this.response.setBy(by);
            this.response.setNotAfterDateCertificate(((X509Certificate)cert).getNotAfter());
            instaSta.setToken(keyStore.getProvider().getName());
            instaSta.setAlgorithm(signer.getAlgorithm());
            instaSta.setSuccess(true);
            BasicCertificate bc = new BasicCertificate((X509Certificate)cert);
            try {
                instaSta.setCaURL(bc.getAuthorityInfoAccess().iterator().next());
            }
            catch (Throwable error) {
                ConfigurationRepo.getInstance().setValidateLCR(true);
                logger.error(error.getMessage());
            }
            ConfigurationRepo.getInstance().setValidateLCR(true);
            logger.info("Assinado por: " + ((X509Certificate)cert).getSubjectDN().getName());
            if (this.configSigner.isLogOffToken()) {
                keyStore = null;
                pinFile = null;
                pinToken = null;
                cert = null;
                privateKey = null;
                signer = null;
            }
            Main.hideLoadingScreen();
            PackageResponse packageResponse = this.response;
            return packageResponse;
        }
        catch (Exception error) {
            instaSta.setSuccess(false);
            ConfigurationRepo.getInstance().setValidateLCR(true);
            if (error.getCause() instanceof InvocationTargetException) {
                InvocationTargetException targetException = (InvocationTargetException)error.getCause();
                if (pinFile != null && pinFile.getActionCanceled()) {
                    this.response.setActionCanceled(true);
                    cert = this.response;
                    return cert;
                }
                if (pinToken != null && pinToken.getActionCanceled()) {
                    this.response.setActionCanceled(true);
                    cert = this.response;
                    return cert;
                }
                if (pinToken != null && !pinToken.getActionCanceled()) {
                    this.response.setActionCanceled(false);
                    throw new RuntimeException(error.getMessage(), error);
                }
                if (targetException.getTargetException() instanceof LoginException) {
                    this.response.setActionCanceled(true);
                    cert = this.response;
                    return cert;
                }
                logger.error(error.getMessage());
                throw new RuntimeException(error.getMessage(), error);
            }
            if (pinToken != null && pinToken.getActionCanceled()) {
                this.response.setActionCanceled(true);
                PackageResponse packageResponse = this.response;
                return packageResponse;
            }
            if (pinToken != null && !pinToken.getActionCanceled()) {
                this.response.setActionCanceled(false);
                throw new RuntimeException(error.getMessage(), error);
            }
            ConfigurationRepo.getInstance().setValidateLCR(true);
            logger.error(error.getMessage());
            Main.hideLoadingScreen();
            throw new RuntimeException(error.getMessage(), error);
        }
        finally {
            ConfigurationRepo.getInstance().setValidateLCR(true);
            instaSta.setWeb(fromWeb);
            Thread trSign = new Thread(instaSta);
            trSign.start();
            Main.hideLoadingScreen();
        }
    }

    public Date getCertExpDate() {
        return this.certExpDate;
    }

    public void setCertExpDate(Date certExpDate) {
        this.certExpDate = certExpDate;
    }

    private void validateRequest(PackageRequest request) throws Exception {
        if (request.getListOfInputData().isEmpty()) {
            logger.error("N\u00e3o foi fornecido os dados assinados em base64!");
            throw new Exception("N\u00e3o foi fornecido os dados assinados em base64!");
        }
    }
}

