/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.signer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.cades.factory.PKCS7Factory;
import org.demoiselle.signer.policy.impl.cades.pkcs7.PKCS7Signer;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCerts;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsRequest;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsResponse;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.command.signer.SignResponse;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.ListCertificateData;
import org.demoiselle.signer.serpro.desktop.ui.commons.FileChooserSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCoSignerUsingDefaults
extends AbstractCommand<SignRequest, SignResponse> {
    private static final Logger logger = LoggerFactory.getLogger(FileCoSignerUsingDefaults.class);

    @Override
    public SignResponse doCommand(SignRequest request) throws Throwable {
        String alias;
        SignResponse result = new SignResponse();
        String fileName = "";
        String previewFileName = "";
        SerproSignerConfigurations configs = SerproSignerConfigurations.getInstance();
        Main.showLoadingScreen(request.getHostConnectedPrefix());
        ListCertsRequest requestCert = new ListCertsRequest();
        requestCert.setUseCertFor("Co-assinar um Documento");
        ListCerts ls = new ListCerts();
        ListCertsResponse lr = ls.doCommand(requestCert);
        if (lr.getCertificates().isEmpty()) {
            Main.hideLoadingScreen();
            throw new RuntimeException("Nenhum certificado foi encontrado \n, verifique se seu token esta conectado ao computador ou certificado em arquivo configurado corretamente\n, \n Feche e abra novamente o assinador.");
        }
        if (lr.getCertificates().size() > 1) {
            ListCertificateData lcd = new ListCertificateData(lr);
            lcd.init();
            alias = lcd.getAlias();
            if (alias == null || alias.equals("")) {
                result.setActionCanceled(true);
                return result;
            }
        } else {
            ArrayList list = (ArrayList)lr.getCertificates();
            Certificate cert = (Certificate)list.iterator().next();
            alias = cert.getAlias();
        }
        FileChooserSigner fileChooser = new FileChooserSigner();
        fileChooser.setDialogTitle("Selecione o Arquivo Original");
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            fileName = selectedFile.getAbsolutePath();
            FileChooserSigner fileChooserP7s = new FileChooserSigner();
            fileChooserP7s.setDialogTitle("Selecione o Arquivo de assinatura (p7s) Anterior");
            fileChooserP7s.setAcceptAllFileFilterUsed(false);
            FileNameExtensionFilter filterP7S = new FileNameExtensionFilter("Arquivo de Assinatura(.p7s)", "p7s", "P7S", "p7S", "P7s");
            fileChooserP7s.addChoosableFileFilter(filterP7S);
            fileChooserP7s.setCurrentDirectory(selectedFile);
            returnValue = fileChooserP7s.showOpenDialog(null);
            if (returnValue == 0) {
                Statistics instaSta = new Statistics();
                try {
                    Main.showLoadingScreen(request.getHostConnectedPrefix());
                    selectedFile = fileChooserP7s.getSelectedFile();
                    previewFileName = selectedFile.getAbsolutePath();
                    logger.info("Co-Assinando com o P7S [" + previewFileName + "]");
                    if (SerproSignerConfigurations.getInstance().isLcrOff()) {
                        ConfigurationRepo.getInstance().setValidateLCR(false);
                        logger.warn("Assinando sem valida\u00e7\u00e3o de LCR!");
                    }
                    byte[] arquivoOriginal = new byte[]{};
                    byte[] arquivoAssinatura = new byte[]{};
                    File file = new File(fileName);
                    arquivoOriginal = new byte[(int)file.length()];
                    FileInputStream fis = new FileInputStream(file);
                    fis.read(arquivoOriginal);
                    fis.close();
                    file = new File(previewFileName);
                    arquivoAssinatura = new byte[(int)file.length()];
                    fis = new FileInputStream(file);
                    fis.read(arquivoAssinatura);
                    fis.close();
                    KeyStore keyStore = ls.getKeyStore();
                    PrivateKey privateKey = configs.isUseCertificateFile() || configs.isChooseFileCertificate() ? (PrivateKey)keyStore.getKey(alias, ls.getPass()) : (PrivateKey)keyStore.getKey(alias, null);
                    PKCS7Signer signer = PKCS7Factory.getInstance().factoryDefault();
                    signer.setCertificates(keyStore.getCertificateChain(alias));
                    signer.setPrivateKey(privateKey);
                    signer.setAlgorithm(SignerAlgorithmEnum.SHA512withRSA);
                    logger.info("Usando provider: " + keyStore.getProvider().getName());
                    String varSO = System.getProperty("os.name");
                    if (varSO.contains("indows")) {
                        logger.info("Windows detected, Algorithm setted to SHA256");
                        signer.setAlgorithm(SignerAlgorithmEnum.SHA256withRSA);
                    }
                    switch (request.getSignaturePolicy()) {
                        case "RB": {
                            instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                            break;
                        }
                        case "RT": {
                            instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3);
                            break;
                        }
                        case "RV": {
                            instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3);
                            break;
                        }
                        case "RC": {
                            instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3);
                            break;
                        }
                        case "RA": {
                            instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4);
                            break;
                        }
                        default: {
                            instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                            signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                        }
                    }
                    byte[] byteFile = null;
                    instaSta.setAction("cosigner");
                    instaSta.setType("file");
                    instaSta.setLengthOriginalContent(arquivoOriginal.length);
                    instaSta.setStart(System.currentTimeMillis());
                    instaSta.setAlgorithm(signer.getAlgorithm());
                    try {
                        instaSta.setToken(keyStore.getProvider().getName());
                        BasicCertificate bc = new BasicCertificate((X509Certificate)keyStore.getCertificate(alias));
                        instaSta.setCaURL(bc.getAuthorityInfoAccess().iterator().next());
                        result.setNotAfterDateCertificate(bc.getAfterDate());
                    }
                    catch (Throwable error) {
                        logger.error(error.getMessage());
                    }
                    byteFile = signer.doDetachedSign(arquivoOriginal, arquivoAssinatura);
                    instaSta.setEnd(System.currentTimeMillis());
                    instaSta.setLengthSignature(byteFile.length);
                    instaSta.setSuccess(true);
                    FileOutputStream fos = new FileOutputStream(previewFileName);
                    fos.write(byteFile);
                    fos.close();
                    result.setSignature(previewFileName);
                    result.setOriginal(fileName);
                }
                catch (Throwable error) {
                    instaSta.setSuccess(false);
                    throw new RuntimeException(error.getMessage(), error);
                }
                finally {
                    Thread trFCoSig = new Thread(instaSta);
                    trFCoSig.start();
                    Main.hideLoadingScreen();
                }
            }
        }
        if (returnValue == 1 || returnValue == 1) {
            result.setActionCanceled(true);
        }
        return result;
    }
}

