/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.signer;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.SimpleTimeZone;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.cades.factory.PKCS7Factory;
import org.demoiselle.signer.policy.impl.cades.pkcs7.PKCS7Signer;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCerts;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsRequest;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsResponse;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.command.signer.SignResponse;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.ListCertificateData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoSign
extends AbstractCommand<SignRequest, SignResponse> {
    private static final Logger logger = LoggerFactory.getLogger(CoSign.class);

    @Override
    public SignResponse doCommand(SignRequest request) throws Throwable {
        String alias;
        this.validateRequest(request);
        SignResponse result = new SignResponse();
        SerproSignerConfigurations configs = SerproSignerConfigurations.getInstance();
        Main.showLoadingScreen(request.getHostConnectedPrefix());
        ListCertsRequest requestCert = new ListCertsRequest();
        requestCert.setUseCertFor("Co-assinar um Documento");
        ListCerts ls = new ListCerts();
        ListCertsResponse lr = ls.doCommand(requestCert);
        if (lr.getCertificates().isEmpty()) {
            Main.hideLoadingScreen();
            throw new RuntimeException("Nenhum certificado foi encontrado \n, verifique se seu token esta conectado ao computador ou certificado em arquivo configurado corretamente\n, \n Feche e abra novamente o assinador.");
        }
        if (lr.getCertificates().size() > 1) {
            ListCertificateData lcd = new ListCertificateData(lr);
            lcd.init();
            alias = lcd.getAlias();
            if (alias == null || alias.equals("")) {
                result.setActionCanceled(true);
                return result;
            }
        } else {
            ArrayList list = (ArrayList)lr.getCertificates();
            Certificate cert = (Certificate)list.iterator().next();
            alias = cert.getAlias();
        }
        Statistics instaSta = new Statistics();
        try {
            if (SerproSignerConfigurations.getInstance().isLcrOff()) {
                ConfigurationRepo.getInstance().setValidateLCR(false);
                logger.warn("Assinando sem valida\u00e7\u00e3o de LCR!");
            }
            Main.showLoadingScreen(request.getHostConnectedPrefix());
            byte[] arquivoOriginal = new byte[]{};
            byte[] arquivoAssinatura = new byte[]{};
            arquivoOriginal = Base64Utils.base64Decode(request.getInputData());
            arquivoAssinatura = Base64Utils.base64Decode(request.getSignatureToCoSign());
            KeyStore keyStore = ls.getKeyStore();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            PrivateKey privateKey = configs.isUseCertificateFile() || configs.isChooseFileCertificate() ? (PrivateKey)keyStore.getKey(alias, ls.getPass()) : (PrivateKey)keyStore.getKey(alias, null);
            PKCS7Signer signer = PKCS7Factory.getInstance().factoryDefault();
            signer.setCertificates(keyStore.getCertificateChain(alias));
            signer.setPrivateKey(privateKey);
            signer.setAlgorithm(SignerAlgorithmEnum.SHA512withRSA);
            logger.info("Usando provider: " + keyStore.getProvider().getName());
            String varSO = System.getProperty("os.name");
            if (varSO.contains("indows")) {
                logger.info("Windows detected, Algorithm setted to SHA256");
                signer.setAlgorithm(SignerAlgorithmEnum.SHA256withRSA);
            }
            switch (request.getSignaturePolicy()) {
                case "RB": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                    break;
                }
                case "RT": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3.name());
                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3);
                    break;
                }
                case "RV": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3.name());
                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3);
                    break;
                }
                case "RC": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3.name());
                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3);
                    break;
                }
                case "RA": {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4.name());
                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4);
                    break;
                }
                default: {
                    instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                    signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                }
            }
            byte[] byteCoAssinatura = null;
            instaSta.setAction("cosigner");
            instaSta.setLengthOriginalContent(arquivoOriginal.length);
            instaSta.setStart(System.currentTimeMillis());
            instaSta.setAlgorithm(signer.getAlgorithm());
            try {
                instaSta.setToken(keyStore.getProvider().getName());
                BasicCertificate bc = new BasicCertificate((X509Certificate)keyStore.getCertificate(alias));
                instaSta.setCaURL(bc.getAuthorityInfoAccess().iterator().next());
                result.setNotAfterDateCertificate(bc.getAfterDate());
            }
            catch (Exception bc) {
                // empty catch block
            }
            if (request.getType().equalsIgnoreCase("hash")) {
                instaSta.setType("hash");
                byteCoAssinatura = signer.doHashCoSign(arquivoOriginal, arquivoAssinatura);
            } else {
                instaSta.setType("base64");
                byteCoAssinatura = signer.doDetachedSign(arquivoOriginal, arquivoAssinatura);
            }
            Certificate by = new Certificate();
            by.setAlias(alias);
            by.setProvider(keyStore.getProvider().getName());
            by.setSubject(cert.getSubjectDN().getName());
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
            sdf.applyPattern("dd MMM yyyy HH:mm:ss z");
            by.setNotAfter(sdf.format(cert.getNotAfter()));
            by.setNotBefore(sdf.format(cert.getNotBefore()));
            result.setBy(by);
            result.setNotAfterDateCertificate(cert.getNotAfter());
            instaSta.setEnd(System.currentTimeMillis());
            instaSta.setLengthSignature(byteCoAssinatura.length);
            result.setPublicKey(Base64Utils.base64Encode(cert.getPublicKey().getEncoded()));
            result.setSignature(Base64Utils.base64Encode(byteCoAssinatura));
            result.setOriginal(request.getInputData());
            instaSta.setSuccess(true);
            ConfigurationRepo.getInstance().setValidateLCR(true);
            logger.info("Assinado por: " + cert.getSubjectDN().getName());
        }
        catch (Throwable error) {
            instaSta.setSuccess(false);
            ConfigurationRepo.getInstance().setValidateLCR(true);
            throw new RuntimeException(error.getMessage(), error);
        }
        finally {
            ConfigurationRepo.getInstance().setValidateLCR(true);
            Thread trCoSig = new Thread(instaSta);
            trCoSig.start();
            Main.hideLoadingScreen();
        }
        return result;
    }

    private void validateRequest(SignRequest request) throws Exception {
        if (request.getType().equalsIgnoreCase("hash")) {
            if (request.getInputData().equals("")) {
                throw new Exception("N\u00e3o foi fornecido um resumo (Hash) de arquivo original para ser assinado");
            }
            if (request.getSignatureToCoSign().equals("")) {
                throw new Exception("N\u00e3o foi fornecida a assinatura para ser co-assinada");
            }
        }
        if (request.getType().equalsIgnoreCase("base64")) {
            if (request.getInputData().equals("")) {
                throw new Exception("N\u00e3o foi fornecido cont\u00e9udo original em base64 para ser assinado");
            }
            if (request.getSignatureToCoSign().equals("")) {
                throw new Exception("N\u00e3o foi fornecida a assinatura para ser co-assinada");
            }
        }
    }
}

