/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.signer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import javax.security.auth.login.LoginException;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.impl.cades.SignerAlgorithmEnum;
import org.demoiselle.signer.policy.impl.cades.factory.PKCS7Factory;
import org.demoiselle.signer.policy.impl.cades.pkcs7.PKCS7Signer;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.CertUtils;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.cert.LogoutPKCS11;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchCoSignRequest;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchCoSignResponse;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.demoiselle.signer.serpro.desktop.ui.PinHandlerFile;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCoSign
extends AbstractCommand<BatchCoSignRequest, BatchCoSignResponse> {
    private static final Logger logger = LoggerFactory.getLogger(BatchCoSign.class);
    private Date certExpDate;

    @Override
    public BatchCoSignResponse doCommand(BatchCoSignRequest request) throws Throwable {
        return this.doCommand(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BatchCoSignResponse doCommand(BatchCoSignRequest request, BatchSignatureContext batchSignatureContext) throws Throwable {
        Object alias;
        this.validateRequest(request);
        SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
        BatchCoSignResponse response = new BatchCoSignResponse();
        boolean fromWeb = request.getHostConnected() != null && !request.getHostConnected().isEmpty();
        String prefix = request.getHostConnectedPrefix();
        String varAction = "Co-Assinar em Lote";
        PinHandlerFile pinFile = new PinHandlerFile(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
        PinHandler pinToken = new PinHandler(varAction + this.getStringType(request.getType()), request.getHostConnectedPrefix());
        char[] pass = null;
        Statistics instaSta = new Statistics();
        try {
            BatchCoSignResponse batchCoSignResponse;
            PKCS7Signer signer;
            PrivateKey privateKey;
            X509Certificate cert;
            KeyStore keyStore;
            block73: {
                byte[] byteArrayOriginalSignature;
                byte[] byteArrayOriginalInputData;
                String varSO;
                block71: {
                    block72: {
                        Map.Entry<String, String> item;
                        Main.showLoadingScreen(prefix);
                        keyStore = null;
                        if (configSigner.isUseCertificateFile() || configSigner.isChooseFileCertificate()) {
                            File filep12;
                            pinToken = null;
                            Main.hideLoadingScreen();
                            if (configSigner.isChooseFileCertificate()) {
                                if (batchSignatureContext != null && batchSignatureContext.isKeyStoreSelected()) {
                                    filep12 = new File(batchSignatureContext.getKeyStore());
                                    pass = configSigner.getCertificateFilePass();
                                } else {
                                    filep12 = FileUtil.selectA1Certificate();
                                    pinFile.init();
                                    if (pinFile.getActionCanceled()) {
                                        logger.info("Assinatura cancelada pelo Usu\u00e1rio");
                                        throw new RuntimeException("Assinatura cancelada pelo usu\u00e1rio");
                                    }
                                    pass = pinFile.getPwd();
                                    configSigner.setCertificateFilePass(pass);
                                }
                            } else {
                                filep12 = new File(configSigner.getCertificateFilePath());
                                if (configSigner.isSaveCertificateFilePass()) {
                                    pass = configSigner.getCertificateFilePass();
                                } else {
                                    pinFile.init();
                                    if (pinFile.getActionCanceled()) {
                                        logger.info("Assinatura cancelada pelo usu\u00e1rio");
                                        throw new RuntimeException("Assinatura cancelada pelo usu\u00e1rio");
                                    }
                                    pass = pinFile.getPwd();
                                }
                            }
                            KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader(filep12);
                            keyStore = loader.getKeyStore(String.copyValueOf(pass));
                            if (batchSignatureContext != null && !batchSignatureContext.isKeyStoreSelected()) {
                                batchSignatureContext.setKeyStore(filep12.getAbsolutePath());
                            }
                        } else {
                            KeystoreSelection ks;
                            Iterator<Map.Entry<String, String>> it;
                            pinFile = null;
                            if (configSigner.isLogOffToken()) {
                                new LogoutPKCS11().doCommand((Request)null);
                            }
                            if (configSigner.isUseNeoId()) {
                                it = Configuration.getInstance().getDrivers().entrySet().iterator();
                                while (it.hasNext()) {
                                    item = it.next();
                                    if (item.getKey().contains("neoid")) continue;
                                    it.remove();
                                }
                            }
                            if (configSigner.isSelectedToken()) {
                                it = Configuration.getInstance().getDrivers().entrySet().iterator();
                                while (it.hasNext()) {
                                    item = it.next();
                                    if (item.getKey().equalsIgnoreCase(configSigner.getTokenNameSelected())) continue;
                                    it.remove();
                                }
                            }
                            if ((keyStore = (ks = new KeystoreSelection(pinToken, batchSignatureContext)).getKeyStore()) == null) {
                                response.setActionCanceled(true);
                                item = response;
                                return item;
                            }
                        }
                        alias = CertUtils.getAlias(request.getAlias(), keyStore, batchSignatureContext);
                        if (response.getActionCanceled()) {
                            item = response;
                            return item;
                        }
                        cert = (X509Certificate)keyStore.getCertificate((String)alias);
                        privateKey = null;
                        privateKey = configSigner.isUseCertificateFile() || configSigner.isChooseFileCertificate() ? (PrivateKey)keyStore.getKey((String)alias, pass) : (PrivateKey)keyStore.getKey((String)alias, null);
                        signer = PKCS7Factory.getInstance().factoryDefault();
                        signer.setCertificates(keyStore.getCertificateChain((String)alias));
                        signer.setPrivateKey(privateKey);
                        varSO = System.getProperty("os.name");
                        try {
                            signer.setAlgorithm(SignerAlgorithmEnum.valueOf(request.getAlgorithm()));
                            if (varSO.contains("indows")) {
                                logger.info("Windows detected, Algorithm setted to SHA256");
                                signer.setAlgorithm(SignerAlgorithmEnum.SHA256withRSA);
                            }
                        }
                        catch (Throwable error) {
                            signer.setAlgorithm(SignerAlgorithmEnum.DEFAULT);
                        }
                        switch (request.getSignaturePolicy()) {
                            case "RB": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                                break;
                            }
                            case "RT": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RT_CADES_2_3);
                                break;
                            }
                            case "RV": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RV_CADES_2_3);
                                break;
                            }
                            case "RC": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RC_CADES_2_3);
                                break;
                            }
                            case "RA": {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RA_CADES_2_4);
                                break;
                            }
                            default: {
                                instaSta.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3.name());
                                signer.setSignaturePolicy(PolicyFactory.Policies.AD_RB_CADES_2_3);
                            }
                        }
                        if (configSigner.isLcrOff()) {
                            ConfigurationRepo.getInstance().setValidateLCR(false);
                            logger.warn("Assinando sem valida\u00e7\u00e3o de LCR!");
                        }
                        if (request.getType().equalsIgnoreCase("hash")) break block71;
                        if (!request.getType().equalsIgnoreCase("text")) break block72;
                        instaSta.setType("text");
                        Main.showLoadingScreen(prefix);
                        int indexSignature = 0;
                        for (String text : request.getListOfInputData()) {
                            response.getListOfOriginalContents().add(text);
                            byteArrayOriginalInputData = this.contentToBytes(text, request.getTextEncoding());
                            byteArrayOriginalSignature = Base64Utils.base64Decode(request.getListOfInputSignatures().get(indexSignature));
                            instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                            instaSta.setStart(System.currentTimeMillis());
                            byte[] temp = signer.doDetachedSign(byteArrayOriginalInputData, byteArrayOriginalSignature);
                            instaSta.setEnd(System.currentTimeMillis());
                            instaSta.setLengthSignature(temp.length);
                            response.getListOfSignatures().add(Base64Utils.base64Encode(temp));
                            byteArrayOriginalInputData = new byte[]{};
                            temp = new byte[]{};
                            byteArrayOriginalSignature = new byte[]{};
                            ++indexSignature;
                        }
                        break block73;
                    }
                    if (request.getType().equalsIgnoreCase("base64")) {
                        instaSta.setType("base64");
                        Main.showLoadingScreen(prefix);
                        int indexSignature = 0;
                        for (String base64 : request.getListOfInputData()) {
                            byteArrayOriginalInputData = Base64Utils.base64Decode(base64);
                            byteArrayOriginalSignature = Base64Utils.base64Decode(request.getListOfInputSignatures().get(indexSignature));
                            response.getListOfOriginalContents().add(base64);
                            instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                            instaSta.setStart(System.currentTimeMillis());
                            byte[] temp = signer.doDetachedSign(byteArrayOriginalInputData, byteArrayOriginalSignature);
                            instaSta.setEnd(System.currentTimeMillis());
                            instaSta.setLengthSignature(temp.length);
                            response.getListOfSignatures().add(Base64Utils.base64Encode(temp));
                            temp = new byte[]{};
                            byteArrayOriginalInputData = new byte[]{};
                            byteArrayOriginalSignature = new byte[]{};
                            ++indexSignature;
                        }
                    }
                    break block73;
                }
                instaSta.setType("hash");
                Main.showLoadingScreen(prefix);
                int indexSignature = 0;
                for (String hash : request.getListOfInputData()) {
                    logger.debug("Hash a ser co-assinado: " + hash);
                    if (varSO.contains("indows")) {
                        if (hash.length() > 44) {
                            response.setRequestId(request.getRequestId());
                            response.setHasError(true);
                            response.setMsgError("O HASH para co-assinatura em ambiente Windows deve ser SHA-256!");
                            logger.error("O HASH para co-assinatura em ambiente Windows deve ser SHA-256!, input: " + hash);
                            batchCoSignResponse = response;
                            return batchCoSignResponse;
                        }
                    } else if (hash.length() < 88) {
                        response.setRequestId(request.getRequestId());
                        response.setHasError(true);
                        response.setMsgError("O HASH para co-assinatura em ambiente Linux ou MAC deve ser SHA-512!");
                        logger.error("O HASH para co-assinatura em ambiente Linux ou MAC deve ser SHA-512!, input: " + hash);
                        batchCoSignResponse = response;
                        return batchCoSignResponse;
                    }
                    byteArrayOriginalInputData = Base64Utils.base64Decode(hash);
                    response.getListOfOriginalContents().add(hash);
                    byteArrayOriginalSignature = Base64Utils.base64Decode(request.getListOfInputSignatures().get(indexSignature));
                    instaSta.setLengthOriginalContent(byteArrayOriginalInputData.length);
                    instaSta.setStart(System.currentTimeMillis());
                    byte[] temp = signer.doHashCoSign(byteArrayOriginalInputData, byteArrayOriginalSignature);
                    instaSta.setEnd(System.currentTimeMillis());
                    instaSta.setLengthSignature(temp.length);
                    response.getListOfSignatures().add(Base64Utils.base64Encode(temp));
                    byteArrayOriginalInputData = new byte[]{};
                    temp = new byte[]{};
                    byteArrayOriginalSignature = new byte[]{};
                    ++indexSignature;
                }
            }
            response.setRequestId(request.getRequestId());
            response.setPublicKey(Base64Utils.base64Encode(cert.getPublicKey().getEncoded()));
            Certificate by = new Certificate();
            by.setAlias((String)alias);
            by.setProvider(keyStore.getProvider().getName());
            by.setSubject(cert.getSubjectDN().getName());
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
            sdf.applyPattern("dd MMM yyyy HH:mm:ss z");
            by.setNotAfter(sdf.format(cert.getNotAfter()));
            by.setNotBefore(sdf.format(cert.getNotBefore()));
            this.setCertExpDate(cert.getNotAfter());
            response.setBy(by);
            response.setNotAfterDateCertificate(cert.getNotAfter());
            instaSta.setToken(keyStore.getProvider().getName());
            instaSta.setAlgorithm(signer.getAlgorithm());
            instaSta.setSuccess(true);
            BasicCertificate bc = new BasicCertificate(cert);
            try {
                instaSta.setCaURL(bc.getAuthorityInfoAccess().iterator().next());
            }
            catch (Throwable error) {
                ConfigurationRepo.getInstance().setValidateLCR(true);
                logger.error(error.getMessage());
            }
            ConfigurationRepo.getInstance().setValidateLCR(true);
            logger.info("Assinado por: " + cert.getSubjectDN().getName());
            if (configSigner.isLogOffToken()) {
                keyStore = null;
                pinFile = null;
                pinToken = null;
                cert = null;
                privateKey = null;
                signer = null;
            }
            Main.hideLoadingScreen();
            batchCoSignResponse = response;
            return batchCoSignResponse;
        }
        catch (Throwable error) {
            instaSta.setSuccess(false);
            ConfigurationRepo.getInstance().setValidateLCR(true);
            if (error.getMessage().toLowerCase().contains("cancel")) {
                if (pinToken == null) {
                    response.setActionCanceled(true);
                    alias = response;
                    return alias;
                }
                pinToken.setActionCanceled(true);
            }
            if (error.getCause() != null && error.getCause() instanceof InvocationTargetException) {
                Object trSign;
                InvocationTargetException targetException = (InvocationTargetException)error.getCause();
                if (pinFile != null && pinFile.getActionCanceled()) {
                    response.setActionCanceled(true);
                    trSign = response;
                    return trSign;
                }
                if (pinToken != null && pinToken.getActionCanceled()) {
                    response.setActionCanceled(true);
                    trSign = response;
                    return trSign;
                }
                if (pinToken != null && !pinToken.getActionCanceled()) {
                    response.setActionCanceled(false);
                    throw new RuntimeException(error.getMessage(), error);
                }
                if (targetException.getTargetException() != null && targetException.getTargetException() instanceof LoginException) {
                    response.setActionCanceled(true);
                    trSign = response;
                    return trSign;
                }
                logger.error(error.getMessage());
                throw new RuntimeException(error.getMessage(), error);
            }
            if (pinToken != null && pinToken.getActionCanceled()) {
                response.setActionCanceled(true);
                BatchCoSignResponse batchCoSignResponse = response;
                return batchCoSignResponse;
            }
            if (pinToken != null && !pinToken.getActionCanceled()) {
                response.setActionCanceled(false);
                throw new RuntimeException(error.getMessage(), error);
            }
            ConfigurationRepo.getInstance().setValidateLCR(true);
            logger.error(error.getMessage());
            Main.hideLoadingScreen();
            throw new RuntimeException(error.getMessage(), error);
        }
        finally {
            ConfigurationRepo.getInstance().setValidateLCR(true);
            instaSta.setWeb(fromWeb);
            Thread trSign = new Thread(instaSta);
            trSign.start();
            Main.hideLoadingScreen();
        }
    }

    private void validateRequest(BatchCoSignRequest request) throws Exception {
        if (request.getType().isEmpty()) {
            logger.error("N\u00e3o foi informado um tipo para co-assinatura em lote, use: hash||text||base64");
            throw new Exception("N\u00e3o foi informado um tipo para co-assinatura em lote, use: hash||text||base64");
        }
        if (!(request.getType().equalsIgnoreCase("hash") || request.getType().equalsIgnoreCase("text") || request.getType().equalsIgnoreCase("base64"))) {
            logger.error("Os valores permitidos para Type, em co-assinaturas s\u00e3o: hash, text ou base64");
            throw new Exception("Os valores permitidos para Type, em co-assinaturas s\u00e3o: hash, text ou base64");
        }
        if (request.getListOfInputData().isEmpty()) {
            logger.error("N\u00e3o foi fornecido o Hash, ou Texto, ou Base64 para ser co-assinado");
            throw new Exception("N\u00e3o foi fornecido o Hash, ou Texto, ou Base64 para ser co-assinado\"");
        }
        if (request.getListOfInputSignatures().isEmpty()) {
            logger.error("N\u00e3o foi informada nenhuma assinatura pr\u00e9via para co-assinar!");
            throw new Exception("N\u00e3o foi informada nenhuma assinatura pr\u00e9via para co-assinar!");
        }
        if (request.getListOfInputSignatures().size() != request.getListOfInputData().size()) {
            logger.error("A quantidade de dados (InputData) a ser co-assinados" + request.getListOfInputData().size() + "est\u00e1 diferente da quantidade de Assinaturas pr\u00e9vias:" + request.getListOfInputSignatures().size());
            throw new Exception("A quantidade de dados (InputData) a ser co-assinados" + request.getListOfInputData().size() + "est\u00e1 diferente da quantidade de Assinaturas pr\u00e9vias:" + request.getListOfInputSignatures().size());
        }
        if (!(request.getSignaturePolicy().equalsIgnoreCase("RB") || request.getSignaturePolicy().equalsIgnoreCase("RT") || request.getSignaturePolicy().equalsIgnoreCase("RV"))) {
            logger.error("Os valores permitidos para SignaturePolicy, em co-assinaturas s\u00e3o: RB, RT ou RV");
            throw new Exception("Os valores permitidos para SignaturePolicy em co-assinaturas s\u00e3o: RB, RT ou RV");
        }
        if (!request.getAlgorithm().equalsIgnoreCase("SHA512withRSA") && !request.getAlgorithm().equalsIgnoreCase("SHA256withRSA")) {
            logger.error("Os valores permitidos para Alghorithm, em co-assinaturas s\u00e3o: SHA512withRSA ou SHA25withRSA");
            throw new Exception("Os valores permitidos para Alghorithm, em co-assinaturas s\u00e3o: SHA512withRSA ou SHA25withRSA");
        }
    }

    private String getStringType(String type) {
        if (type.equalsIgnoreCase("text")) {
            return "Texto";
        }
        if (type.equalsIgnoreCase("hash")) {
            return "Somente Resumo (Hash)";
        }
        if (type.equalsIgnoreCase("file")) {
            return "Arquivo";
        }
        if (type.equalsIgnoreCase("base64")) {
            return "Conte\u00fado em Base64";
        }
        return "Desconhecido";
    }

    public Date getCertExpDate() {
        return this.certExpDate;
    }

    public void setCertExpDate(Date certExpDate) {
        this.certExpDate = certExpDate;
    }
}

