/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.signature.content;

import java.lang.reflect.InvocationTargetException;
import org.apache.tika.Tika;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESChecker;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.signature.content.AttachedRequest;
import org.demoiselle.signer.serpro.desktop.command.signature.content.AttachedResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attached
extends AbstractCommand<AttachedRequest, AttachedResponse> {
    private static final Logger logger = LoggerFactory.getLogger(Attached.class);
    private AttachedResponse attachedResponse = new AttachedResponse();

    @Override
    public AttachedResponse doCommand(AttachedRequest request) throws Throwable {
        this.validateRequest(request);
        try {
            Main.showLoadingScreen(request.getHostConnectedPrefix());
            CAdESChecker checker = new CAdESChecker();
            logger.info("extraindo conte\u00fado de assinatura");
            byte[] byteArrayOriginalInputSignature = Base64Utils.base64Decode(request.getInputSignature());
            byte[] byteArrayAttachedContent = checker.getAttached(byteArrayOriginalInputSignature, false).getExtractedContent();
            if (byteArrayOriginalInputSignature == null || byteArrayOriginalInputSignature.length <= 0) {
                Main.hideLoadingScreen();
                logger.error("Erro, o conte\u00fado enviado est\u00e1 vazio");
                throw new Exception("Erro, o conte\u00fado enviado est\u00e1 vazio");
            }
            if (byteArrayAttachedContent == null || byteArrayAttachedContent.length <= 0) {
                Main.hideLoadingScreen();
                logger.error("Erro, a assinatura fornecida n\u00e3o tem conte\u00fado anexado");
                throw new Exception("a assinatura fornecida n\u00e3o tem conte\u00fado anexado");
            }
            String contentType2 = new Tika().detect(byteArrayAttachedContent);
            this.attachedResponse.setRequestId(request.getRequestId());
            this.attachedResponse.setAttachedContent(Base64Utils.base64Encode(byteArrayAttachedContent));
            this.attachedResponse.setTypeOfContent(contentType2);
            AttachedResponse attachedResponse = this.attachedResponse;
            return attachedResponse;
        }
        catch (Throwable error) {
            Main.hideLoadingScreen();
            if (error.getCause() != null && error.getCause() instanceof InvocationTargetException) {
                logger.error(error.getMessage());
                throw new RuntimeException(error.getMessage(), error);
            }
            logger.error("Erro ao extrair conte\u00fado:" + error.getMessage());
            throw new RuntimeException(error.getMessage(), error);
        }
        finally {
            Main.hideLoadingScreen();
        }
    }

    private void validateRequest(AttachedRequest request) throws Exception {
        if (request.getInputSignature().equals("")) {
            Main.hideLoadingScreen();
            throw new Exception("N\u00e3o foi fornecida a assinatura (em Base64) de onde o cont\u00e9udo ser\u00e1 extra\u00eddo");
        }
    }
}

