/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.crypto;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.ArrayList;
import javax.crypto.Cipher;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCerts;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsResponse;
import org.demoiselle.signer.serpro.desktop.command.crypto.CryptoRequest;
import org.demoiselle.signer.serpro.desktop.command.crypto.CryptoResponse;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.ui.ListCertificateData;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Response;

public class CryptoCommand
extends AbstractCommand<CryptoRequest, Response> {
    public String toString() {
        return "";
    }

    public String encript(String dataB64, String cryptoAlgorithm) throws Throwable {
        return new String(Base64.encode(this.encript(dataB64, cryptoAlgorithm, null)));
    }

    public byte[] encript(String dataB64, String cryptoAlgorithm, PublicKey pk) throws Throwable {
        PublicKey myPuKey = null;
        if (pk == null) {
            KeyStore keyStore = null;
            PinHandler pinToken = new PinHandler("", "");
            KeystoreSelection ks = new KeystoreSelection(pinToken);
            keyStore = ks.getKeyStore();
            Main.showLoadingScreen("");
            String aliasUsado = this.getAlias("", keyStore);
            myPuKey = keyStore.getCertificate(aliasUsado).getPublicKey();
        } else {
            myPuKey = pk;
        }
        byte[] data = Base64.decode(dataB64);
        Cipher rsa = Cipher.getInstance(cryptoAlgorithm);
        rsa.init(1, myPuKey);
        return rsa.doFinal(data);
    }

    public String decript(String dataB64, String cryptoAlgorithm) throws Throwable {
        return new String(Base64.encode(this.decriptByte(dataB64, cryptoAlgorithm)));
    }

    public byte[] decriptByte(String dataB64, String cryptoAlgorithm) throws Throwable {
        KeyStore keyStore = null;
        PinHandler pinToken = new PinHandler("", "");
        KeystoreSelection ks = new KeystoreSelection(pinToken);
        keyStore = ks.getKeyStore();
        if (pinToken.getActionCanceled() || keyStore == null) {
            throw new Exception("Action canceled");
        }
        String aliasUsado = this.getAlias("", keyStore);
        PrivateKey myPrKey = (PrivateKey)keyStore.getKey(aliasUsado, null);
        Provider sunPKCS11Provider = keyStore.getProvider();
        Cipher rsa3 = Cipher.getInstance(cryptoAlgorithm, sunPKCS11Provider);
        rsa3.init(2, myPrKey);
        return rsa3.doFinal(Base64.decode(dataB64));
    }

    public String getAlias(String alias, KeyStore keyStore) throws Throwable {
        if (!alias.equals("")) {
            return alias;
        }
        ListCerts ls = new ListCerts();
        ListCertsResponse lr = ls.doCommand(keyStore);
        if (lr.getCertificates().isEmpty()) {
            throw new RuntimeException("Nenhum certificado foi encontrado, verifique se seu token esta conectar ao computador, caso esteja feche e abra novamente o assinador.");
        }
        if (lr.getCertificates().size() > 1) {
            ListCertificateData lcd = new ListCertificateData(lr);
            lcd.init();
            alias = lcd.getAlias();
            if (alias == null || alias.equals("")) {
                return null;
            }
        } else {
            ArrayList list = (ArrayList)lr.getCertificates();
            Certificate cert = (Certificate)list.iterator().next();
            alias = cert.getAlias();
        }
        return alias;
    }

    @Override
    public CryptoResponse doCommand(CryptoRequest request) throws Throwable {
        CryptoResponse r = new CryptoResponse();
        r.setAlgorithm(request.getAlgotithm());
        r.setAction(request.getAction());
        if (request.getAction().equals("encrypt")) {
            r.setResult(this.encript(request.getData(), request.getAlgotithm()));
        } else if (request.getAction().equals("decrypt")) {
            r.setResult(this.decript(request.getData(), request.getAlgotithm()));
        } else {
            r.setAction("invalid action use encrypt/decrypt");
        }
        return r;
    }
}

