/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.cert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCertsResponse
extends Response {
    private static final Logger logger = LoggerFactory.getLogger(ListCertsResponse.class);
    private Collection<Certificate> certificates;

    public ListCertsResponse() {
        super.setCommand("listcerts");
    }

    public Collection<Certificate> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Collection<Certificate> certificates) {
        this.certificates = certificates;
    }

    public void sortCertificates() {
        if (this.certificates != null) {
            ArrayList<Certificate> certList = new ArrayList<Certificate>(this.certificates);
            Collections.sort(certList);
            this.certificates = certList;
        }
    }

    public void validateCertificates() {
        if (this.certificates == null) {
            return;
        }
        try {
            Date now = new Date();
            int totalCerts = 0;
            int expirados = 0;
            for (Certificate cert : this.certificates) {
                ++totalCerts;
                if (!this.isExpired(cert, now)) continue;
                ++expirados;
                logger.debug("Certificado expirado: {}, Emissor: {}", (Object)cert.getCn(), (Object)cert.getIssuer());
            }
            logger.info("Valida\u00e7\u00e3o conclu\u00edda. Total de certificados: {}, Expirados: {}", (Object)totalCerts, (Object)expirados);
        }
        catch (Exception e) {
            logger.warn("Erro ao validar certificados. Causa: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isExpired(Certificate cert, Date now) {
        Date startDate = cert.getNotBeforeAsDate();
        Date endDate = cert.getNotAfterAsDate();
        if (startDate == null || endDate == null) {
            logger.warn("Certificado sem datas de validade v\u00e1lidas ou parse\u00e1veis. CN: {}", (Object)cert.getCn());
            return true;
        }
        return now.after(endDate) || now.before(startDate);
    }
}

