/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.cert;

import java.io.File;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.keystore.loader.InvalidPinException;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoaderException;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.command.AbstractCommand;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsRequest;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsResponse;
import org.demoiselle.signer.serpro.desktop.command.cert.LogoutPKCS11;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.exception.ActionCanceledException;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.demoiselle.signer.serpro.desktop.ui.PinHandlerFile;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListCerts
extends AbstractCommand<ListCertsRequest, ListCertsResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ListCerts.class);
    private KeyStore keyStore = null;
    private char[] pass = null;
    private PinHandlerFile pinFile;
    private PinHandler pinToken;
    SerproSignerConfigurations configs = SerproSignerConfigurations.getInstance();

    @Override
    public ListCertsResponse doCommand(ListCertsRequest request) throws Throwable {
        return this.doCommand(request, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ListCertsResponse doCommand(ListCertsRequest request, BatchSignatureContext batchSignatureContext) throws Exception {
        ListCertsResponse response = new ListCertsResponse();
        try {
            String requestAction = request.getUseForSignature();
            String action = requestAction.isEmpty() ? "Listar os certificados" : request.getUseForSignature();
            this.pinFile = new PinHandlerFile(action, request.getHostConnectedPrefix());
            this.pinToken = new PinHandler(action, request.getHostConnectedPrefix());
            response = new ListCertsResponse();
            if (this.configs.isUseCertificateFile() || this.configs.isChooseFileCertificate()) {
                File filep12;
                this.pinToken = null;
                Main.hideLoadingScreen();
                if (this.configs.isChooseFileCertificate()) {
                    if (batchSignatureContext != null && batchSignatureContext.isKeyStoreSelected()) {
                        filep12 = new File(batchSignatureContext.getKeyStore());
                        this.pass = this.configs.getCertificateFilePass();
                    } else {
                        filep12 = FileUtil.selectA1Certificate();
                        this.pinFile.init();
                        if (this.pinFile.getActionCanceled()) throw new RuntimeException("Cancelada pelo usu\u00e1rio");
                        this.pass = this.pinFile.getPwd();
                        this.configs.setCertificateFilePass(this.pass);
                    }
                } else {
                    filep12 = new File(this.configs.getCertificateFilePath());
                    if (this.configs.isSaveCertificateFilePass()) {
                        this.pass = this.configs.getCertificateFilePass();
                    } else {
                        this.pinFile.init();
                        if (this.pinFile.getActionCanceled()) throw new RuntimeException("Cancelada pelo usu\u00e1rio");
                        this.pass = this.pinFile.getPwd();
                    }
                }
                KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader(filep12);
                this.keyStore = loader.getKeyStore(String.copyValueOf(this.pass));
                if (batchSignatureContext != null && !batchSignatureContext.isKeyStoreSelected()) {
                    batchSignatureContext.setKeyStore(filep12.getAbsolutePath());
                }
            } else {
                if (this.configs.isLogOffToken()) {
                    new LogoutPKCS11().doCommand((Request)null);
                }
                if (this.configs.isUseNeoId()) {
                    Iterator<Map.Entry<String, String>> it = Configuration.getInstance().getDrivers().entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, String> item = it.next();
                        if (item.getKey().contains("neoid")) continue;
                        it.remove();
                    }
                }
                this.pinFile = null;
                KeystoreSelection ks = new KeystoreSelection(this.pinToken, batchSignatureContext);
                this.keyStore = ks.getKeyStore();
                KeyStoreLoaderException ex = null;
                try {
                    this.keyStore = ks.getKeyStore();
                }
                catch (InvalidPinException ip) {
                    logger.info("Senha incorreta");
                    throw new RuntimeException(ip.getMessage());
                }
                catch (KeyStoreLoaderException e) {
                    logger.info("Erro no keystore:" + e.getMessage());
                    ex = e;
                }
                if (this.pinToken.getActionCanceled()) {
                    throw new ActionCanceledException();
                }
                if (this.keyStore == null) {
                    if (ex == null) throw new RuntimeException("Ocorreu um erro ao acessar o token, verifique se esta conectado ao computador.");
                    logger.error("Erro grave", ex);
                    throw new RuntimeException("Ocorreu um erro ao acessar o token, verifique se esta conectado ao computador.");
                }
            }
            Enumeration<String> aliases = this.keyStore.aliases();
            ArrayList<Certificate> certList = new ArrayList<Certificate>();
            response.setCertificates(certList);
            logger.info("Listando certificados encontrados");
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                try {
                    X509Certificate cert;
                    if (!this.keyStore.isKeyEntry(alias) || (cert = (X509Certificate)this.keyStore.getCertificate(alias)) == null) continue;
                    BasicCertificate basicCert = new BasicCertificate(cert);
                    Certificate certJson = new Certificate();
                    certJson.setAlias(alias);
                    certJson.setProvider(this.keyStore.getProvider().getName());
                    certJson.setSubject(cert.getSubjectDN().getName());
                    certJson.setCn(basicCert.getName());
                    certJson.setIssuer(cert.getIssuerDN().getName());
                    String certificatePersonType = Certificate.determineCertificatePersonType(cert.getSubjectDN().getName());
                    certJson.setCertificatePersonType(certificatePersonType);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    try {
                        certJson.setNotBefore(sdf.format(cert.getNotBefore()));
                        certJson.setNotAfter(sdf.format(cert.getNotAfter()));
                    }
                    catch (Exception e) {
                        SimpleDateFormat sdfDateOnly = new SimpleDateFormat("dd/MM/yyyy");
                        certJson.setNotBefore(sdfDateOnly.format(cert.getNotBefore()));
                        certJson.setNotAfter(sdfDateOnly.format(cert.getNotAfter()));
                    }
                    certList.add(certJson);
                    logger.debug("Certificado adicionado: " + certJson.getCn());
                }
                catch (Exception e) {
                    logger.warn("Erro ao processar certificado " + alias + ": " + e.getMessage());
                }
            }
            if (!certList.isEmpty()) {
                response.sortCertificates();
                response.validateCertificates();
                logger.info("Encontrados " + certList.size() + " certificados v\u00e1lidos");
            } else {
                logger.warn("Nenhum certificado v\u00e1lido encontrado");
            }
            if (!this.configs.isLogOffToken()) return response;
            this.keyStore = null;
            return response;
        }
        catch (InvalidPinException ip) {
            if (this.pinToken != null && this.pinToken.getActionCanceled()) {
                throw new RuntimeException("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
            }
            if (this.pinFile != null && this.pinFile.getActionCanceled()) {
                throw new RuntimeException("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
            }
            logger.info("Senha inv\u00e1lida");
            throw new RuntimeException(ip.getMessage());
        }
        catch (ActionCanceledException e) {
            throw new RuntimeException("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
        }
        catch (Exception error) {
            if (this.pinToken != null && this.pinToken.getActionCanceled()) {
                throw new RuntimeException("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
            }
            if (this.pinFile != null && this.pinFile.getActionCanceled()) {
                throw new RuntimeException("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
            }
            logger.info("Erro ao tentar buscar os certificados digitais");
            if (error.getMessage() == null) throw new RuntimeException("Erro ao tentar buscar os certificados digitais. Erro desconhecido.");
            if (!error.getMessage().toLowerCase().contains("cancel")) throw new RuntimeException("Erro ao tentar buscar os certificados digitais. " + error.getMessage());
            throw new RuntimeException("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
        }
    }

    @Override
    public ListCertsResponse doCommand(KeyStore keyStore) throws Throwable {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            ListCertsResponse response = new ListCertsResponse();
            response.setCertificates(new ArrayList<Certificate>());
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                try {
                    X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                    if (cert == null) continue;
                    BasicCertificate basicCert = new BasicCertificate(cert);
                    Certificate certJson = new Certificate();
                    certJson.setAlias(alias);
                    certJson.setProvider(keyStore.getProvider().getName());
                    certJson.setSubject(cert.getSubjectDN().getName());
                    certJson.setCn(basicCert.getName());
                    certJson.setIssuer(cert.getIssuerDN().getName());
                    String certificatePersonType = Certificate.determineCertificatePersonType(cert.getSubjectDN().getName());
                    certJson.setCertificatePersonType(certificatePersonType);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    try {
                        certJson.setNotBefore(sdf.format(cert.getNotBefore()));
                        certJson.setNotAfter(sdf.format(cert.getNotAfter()));
                    }
                    catch (Exception e) {
                        SimpleDateFormat sdfDateOnly = new SimpleDateFormat("dd/MM/yyyy");
                        certJson.setNotBefore(sdfDateOnly.format(cert.getNotBefore()));
                        certJson.setNotAfter(sdfDateOnly.format(cert.getNotAfter()));
                    }
                    response.getCertificates().add(certJson);
                    logger.debug("Certificado processado: " + alias);
                }
                catch (Exception e) {
                    logger.warn("Erro ao processar certificado " + alias + ": " + e.getMessage());
                }
            }
            return response;
        }
        catch (Exception error) {
            if (error.getMessage() != null) {
                throw new RuntimeException("Erro ao tentar buscar os certificados digitais. " + error.getMessage());
            }
            throw new RuntimeException("Erro ao tentar buscar os certificados digitais. Erro desconhecido.");
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public char[] getPass() {
        return this.pass;
    }

    public void setPass(char[] pass) {
        this.pass = pass;
    }
}

