/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.cert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Certificate
implements Comparable<Certificate> {
    private static final Logger logger = LoggerFactory.getLogger(Certificate.class);
    private String alias;
    private String provider;
    private String subject;
    private String notBefore;
    private String notAfter;
    private String serial;
    private String cn;
    private String issuer;
    private String certificatePersonType;

    @Override
    public int compareTo(Certificate other) {
        if (this.cn == null && other.cn == null) {
            return 0;
        }
        if (this.cn == null) {
            return -1;
        }
        if (other.cn == null) {
            return 1;
        }
        return this.cn.compareToIgnoreCase(other.cn);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(String notBefore) {
        this.notBefore = notBefore;
    }

    public String getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(String notAfter) {
        this.notAfter = notAfter;
    }

    public String getSerial() {
        return this.serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getCn() {
        return this.cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getCertificatePersonType() {
        return this.certificatePersonType;
    }

    public void setCertificatePersonType(String certificateType) {
        this.certificatePersonType = certificateType;
    }

    public static String determineCertificatePersonType(String subject) {
        if (subject == null || subject.trim().isEmpty()) {
            return "DESCONHECIDO";
        }
        String subjectUpper = subject.toUpperCase();
        if (subjectUpper.contains("OU=") && subjectUpper.contains("PESSOA FISICA")) {
            return "PF";
        }
        if (subjectUpper.contains("OU=") && subjectUpper.contains("PESSOA JURIDICA")) {
            return "PJ";
        }
        if (subjectUpper.contains("CPF") || subjectUpper.contains("CPF:")) {
            return "PF";
        }
        if (subjectUpper.contains("CNPJ") || subjectUpper.contains("CNPJ:")) {
            return "PJ";
        }
        if (subjectUpper.contains("2.16.76.1.3.1")) {
            return "PF";
        }
        if (subjectUpper.contains("2.16.76.1.3.4")) {
            return "PJ";
        }
        return "DESCONHECIDO";
    }

    public Date getNotBeforeAsDate() {
        SimpleDateFormat formatterWithTime = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        SimpleDateFormat formatterDateOnly = new SimpleDateFormat("dd/MM/yyyy");
        try {
            if (this.notBefore != null && !this.notBefore.trim().isEmpty()) {
                try {
                    return formatterWithTime.parse(this.notBefore.trim());
                }
                catch (ParseException e) {
                    return formatterDateOnly.parse(this.notBefore.trim());
                }
            }
        }
        catch (ParseException e) {
            logger.error("Erro ao parsear a data notBefore '" + this.notBefore + "': " + e.getMessage());
        }
        return null;
    }

    public Date getNotAfterAsDate() {
        SimpleDateFormat formatterWithTime = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        SimpleDateFormat formatterDateOnly = new SimpleDateFormat("dd/MM/yyyy");
        try {
            if (this.notAfter != null && !this.notAfter.trim().isEmpty()) {
                try {
                    return formatterWithTime.parse(this.notAfter.trim());
                }
                catch (ParseException e) {
                    return formatterDateOnly.parse(this.notAfter.trim());
                }
            }
        }
        catch (ParseException e) {
            logger.error("Erro ao parsear a data notAfter '" + this.notAfter + "': " + e.getMessage());
        }
        return null;
    }

    public boolean isExpired() {
        Date now = new Date();
        Date startDate = this.getNotBeforeAsDate();
        Date endDate = this.getNotAfterAsDate();
        if (startDate == null || endDate == null) {
            logger.warn("Certificado sem datas de validade v\u00e1lidas ou parse\u00e1veis. CN: {}", (Object)this.cn);
            return false;
        }
        return now.before(startDate) || now.after(endDate);
    }
}

