/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command.cert;

import java.security.KeyStore;
import java.util.ArrayList;
import org.demoiselle.signer.serpro.desktop.command.cert.Certificate;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCerts;
import org.demoiselle.signer.serpro.desktop.command.cert.ListCertsResponse;
import org.demoiselle.signer.serpro.desktop.command.signer.BatchSignatureContext;
import org.demoiselle.signer.serpro.desktop.ui.ListCertificateData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtils {
    private static final Logger logger = LoggerFactory.getLogger(CertUtils.class);

    private CertUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAlias(String alias, KeyStore ks, BatchSignatureContext batchSignatureContext) throws Throwable {
        if (alias != null && !alias.equals("")) {
            return alias;
        }
        if (batchSignatureContext != null && batchSignatureContext.isAliasSelected()) {
            return batchSignatureContext.getAliasKeyStore();
        }
        String selectedAlias = null;
        ListCerts ls = new ListCerts();
        ListCertsResponse lr = ls.doCommand(ks);
        if (lr.getCertificates().isEmpty()) {
            logger.error("Retornou getCertificates Vazio");
            throw new RuntimeException("Nenhum certificado foi encontrado, verifique se seu token esta conectar ao computador, caso esteja feche e abra novamente o assinador.");
        }
        if (lr.getCertificates().size() > 1) {
            ListCertificateData lcd = new ListCertificateData(lr);
            lcd.init();
            if (!lcd.isSelected()) throw new RuntimeException("Usu\u00e1rio cancelou a sele\u00e7\u00e3o de certificado.");
            selectedAlias = lcd.getAlias();
        } else {
            ArrayList list = (ArrayList)lr.getCertificates();
            Certificate cert = (Certificate)list.iterator().next();
            selectedAlias = cert.getAlias();
        }
        if (batchSignatureContext == null || batchSignatureContext.isAliasSelected()) return selectedAlias;
        batchSignatureContext.setAliasKeyStore(selectedAlias);
        return selectedAlias;
    }
}

