/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.demoiselle.signer.serpro.desktop.command.Command;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.ErrorResponse;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand<REQ, RESP>
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCommand.class);
    private static final String ERROR_MESSAGE = "{\"erro\" : \"Erro ao tentar interpretar os parametros do comando.\" }";

    public abstract RESP doCommand(REQ var1) throws Throwable;

    @Override
    public String getCommandName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    @Override
    public String doCommand(String params, String hostConnected) {
        Security.addProvider(new BouncyCastleProvider());
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        REQ request = null;
        try {
            Class type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            request = (REQ)gson.fromJson(params, type);
        }
        catch (Throwable errorData) {
            return ERROR_MESSAGE;
        }
        if (request == null) {
            return ERROR_MESSAGE;
        }
        Request req = null;
        Response resp = null;
        if (request instanceof Request) {
            req = (Request)request;
            req.setHostConnected(hostConnected);
        }
        try {
            RESP response = this.doCommand(request);
            if (response instanceof Response) {
                resp = (Response)response;
                resp.setRequestId(req.getRequestId());
            }
            String resultJson = gson.toJson(response);
            return resultJson;
        }
        catch (Throwable error) {
            ErrorResponse errorResponse = new ErrorResponse(req, error);
            return errorResponse.toJson();
        }
    }

    public byte[] contentToBytes(String content, String encoding) throws UnsupportedEncodingException {
        if (content == null) {
            return null;
        }
        if (!encoding.equalsIgnoreCase("UTF-8")) {
            byte[] contentEncoded = new String(content.getBytes(), StandardCharsets.UTF_8).getBytes(encoding);
            logger.debug("ISO_ENCODED " + encoding + ".........:" + new String(contentEncoded, encoding));
            return contentEncoded;
        }
        return content.getBytes();
    }
}

