/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.cert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;

public class SubjectAlternativeNameHolder {
    private static final Pattern TAGS_PATTERN = Pattern.compile("[72]");
    private final List<ASN1Encodable> sans = new ArrayList<ASN1Encodable>();

    public void addIpAddress(String ipAddress) {
        this.sans.add(new GeneralName(7, ipAddress));
    }

    public void addDomainName(String subjectAlternativeName) {
        this.sans.add(new GeneralName(2, subjectAlternativeName));
    }

    public void fillInto(X509v3CertificateBuilder certGen) throws CertIOException {
        if (!this.sans.isEmpty()) {
            ASN1Encodable[] encodables = this.sans.toArray(new ASN1Encodable[this.sans.size()]);
            certGen.addExtension(Extension.subjectAlternativeName, false, new DERSequence(encodables));
        }
    }

    public void addAll(Collection<List<?>> subjectAlternativeNames) {
        if (subjectAlternativeNames != null) {
            for (List<?> each : subjectAlternativeNames) {
                this.sans.add(this.parseGeneralName(each));
            }
        }
    }

    private ASN1Encodable parseGeneralName(List<?> nameEntry) {
        if (nameEntry != null && nameEntry.size() != 2) {
            throw new IllegalArgumentException(String.valueOf(nameEntry));
        }
        String tag = String.valueOf(nameEntry.get(0));
        Matcher m = TAGS_PATTERN.matcher(tag);
        if (m.matches()) {
            return new GeneralName((int)Integer.valueOf(tag), String.valueOf(nameEntry.get(1)));
        }
        throw new IllegalArgumentException(String.valueOf(nameEntry));
    }
}

