/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.cert;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.operator.OperatorCreationException;
import org.demoiselle.signer.serpro.desktop.cert.Authority;
import org.demoiselle.signer.serpro.desktop.cert.CertificateCreator;
import org.demoiselle.signer.serpro.desktop.cert.SubjectAlternativeNameHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertitficateHelper {
    private static final Logger log = LoggerFactory.getLogger(CertitficateHelper.class);
    public static final String USER_HOME_DIR = System.getProperty("user.home");
    public static final String APP_CONF_DIR = System.getProperty("user.home") + File.separator + ".serpro";
    public static final Path CA_CERT_PATH = Paths.get(APP_CONF_DIR, "serpro_signer_ca.cer");
    public static final Path CA_KEYSTORE_PATH = Paths.get(APP_CONF_DIR, "serpro_signer_ca.p12");
    public static final Path HOST_CERT_PATH = Paths.get(APP_CONF_DIR, "serpro_signer_host.cer");
    public static final Path HOST_KEYSTORE_PATH = Paths.get(APP_CONF_DIR, "serpro_signer_host.p12");
    public static final char[] PASS = "changeit".toCharArray();
    public static final String KEYSTORE_TYPE = "PKCS12";

    public static void initializeSSLCertificate() throws NoSuchAlgorithmException, NoSuchProviderException, CertIOException, OperatorCreationException, CertificateException, KeyStoreException, IOException, InvalidKeyException, UnrecoverableKeyException, SignatureException {
        File certDir = new File(APP_CONF_DIR);
        if (!certDir.exists()) {
            certDir.mkdirs();
        }
        log.info("Diret\u00f3rio dos Certificados: " + APP_CONF_DIR);
        File fileCertCa = new File(CA_CERT_PATH.toString());
        if (!Files.exists(CA_CERT_PATH, new LinkOption[0])) {
            Authority authority = new Authority();
            log.info("Criando a CA do Assinador...");
            KeyStore keyStore = CertificateCreator.createRootCertificate(authority, KEYSTORE_TYPE);
            fileCertCa = new File(CA_CERT_PATH.toString());
            FileOutputStream fosCertCa = new FileOutputStream(fileCertCa);
            fosCertCa.write(keyStore.getCertificate(authority.alias()).getEncoded());
            fosCertCa.close();
            keyStore.store(new FileOutputStream(CA_KEYSTORE_PATH.toString()), PASS);
            log.info("Criando o certificado para localhost (127.0.0.1)");
            KeyStore keyStore2 = CertificateCreator.createServerCertificate("127.0.0.1", new SubjectAlternativeNameHolder(), authority, keyStore.getCertificate(authority.alias()), (PrivateKey)keyStore.getKey(authority.alias(), PASS));
            keyStore2.store(new FileOutputStream(HOST_KEYSTORE_PATH.toString()), PASS);
            FileOutputStream f2 = new FileOutputStream(new File(HOST_CERT_PATH.toString()));
            f2.write(keyStore2.getCertificate(authority.alias()).getEncoded());
            f2.close();
        }
    }

    public static void installCertificates() {
        block15: {
            File fileCertCa = new File(CA_CERT_PATH.toString());
            if (Files.exists(CA_CERT_PATH, new LinkOption[0])) {
                String OS = System.getProperty("os.name").toLowerCase();
                if (OS.contains("win")) {
                    log.info("Instalando a CA no Windows...");
                    try {
                        Certificate cert = CertificateFactory.getInstance("X509").generateCertificate(new FileInputStream(fileCertCa));
                        String caAlias = "Serpro Signer";
                        KeyStore ks = KeyStore.getInstance("Windows-ROOT", "SunMSCAPI");
                        ks.load(null, null);
                        Certificate certInstaled = ks.getCertificate(caAlias);
                        boolean isInstaled = false;
                        if (certInstaled != null) {
                            isInstaled = cert.getPublicKey().equals(certInstaled.getPublicKey());
                        }
                        if (!isInstaled) {
                            if (certInstaled != null) {
                                log.info("removendo a CA antiga no Windows");
                                ks.deleteEntry(caAlias);
                            }
                            ks.setCertificateEntry("Serpro Signer", cert);
                            log.info("Instalada a CA no Windows");
                            break block15;
                        }
                        log.info("CA no Windows j\u00e1 est\u00e1 instalada...");
                    }
                    catch (Exception e) {
                        log.error("Error ao adicionar a CA no Windows...", e);
                    }
                } else if (OS.contains("mac")) {
                    log.info("Instala\u00e7\u00e3o da CA no MacOS...");
                    try {
                        Certificate cert = CertificateFactory.getInstance("X509").generateCertificate(new FileInputStream(fileCertCa));
                        String caAlias = "Serpro Signer";
                        KeyStore ks = KeyStore.getInstance("KeychainStore", "Apple");
                        ks.load(null);
                        Certificate certInstaled = ks.getCertificate(caAlias);
                        boolean isInstaled = false;
                        if (certInstaled != null) {
                            isInstaled = cert.getPublicKey().equals(certInstaled.getPublicKey());
                        }
                        if (!isInstaled) {
                            if (certInstaled != null) {
                                log.info("CA antiga no MacOS, desinstalando...");
                                ks.deleteEntry(caAlias);
                            }
                            ks.setCertificateEntry("Serpro Signer", cert);
                            ks.store(null, null);
                            log.info("Instalada a CA no MacOS...");
                        } else {
                            log.info("CA no MacOS j\u00e1 est\u00e1 instalada...");
                        }
                    }
                    catch (Exception e) {
                        log.info("Error ao adicionar a CA no MacOS CA");
                        log.info("Use: security add-trusted-cert .serpro/serpro_signer_ca.cer");
                        log.info("Use: security add-trusted-cert .serpro/serpro_signer_host.cer");
                    }
                }
            }
        }
    }
}

