/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.cert;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.demoiselle.signer.serpro.desktop.cert.Authority;
import org.demoiselle.signer.serpro.desktop.cert.SubjectAlternativeNameHolder;

public final class CertificateCreator {
    public static final String PROVIDER_NAME = "BC";
    private static final String KEYGEN_ALGORITHM = "RSA";
    private static final String SECURE_RANDOM_ALGORITHM = "SHA1PRNG";
    private static final String SIGNATURE_ALGORITHM = "SHA512WithRSAEncryption";
    private static final int ROOT_KEYSIZE = 4096;
    private static final int FAKE_KEYSIZE = 4096;
    private static final Date NOT_BEFORE;
    private static final Date NOT_AFTER;

    public static KeyPair generateKeyPair(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(KEYGEN_ALGORITHM);
        SecureRandom secureRandom = SecureRandom.getInstance(SECURE_RANDOM_ALGORITHM);
        generator.initialize(keySize, secureRandom);
        return generator.generateKeyPair();
    }

    public static KeyStore createRootCertificate(Authority authority, String keyStoreType) throws NoSuchAlgorithmException, NoSuchProviderException, CertIOException, IOException, OperatorCreationException, CertificateException, KeyStoreException {
        KeyPair keyPair = CertificateCreator.generateKeyPair(4096);
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        nameBuilder.addRDN(BCStyle.CN, authority.commonName());
        nameBuilder.addRDN(BCStyle.O, authority.organization());
        nameBuilder.addRDN(BCStyle.OU, authority.organizationalUnitName());
        X500Name issuer = nameBuilder.build();
        BigInteger serial = BigInteger.valueOf(CertificateCreator.initRandomSerial());
        X500Name subject = issuer;
        PublicKey pubKey = keyPair.getPublic();
        JcaX509v3CertificateBuilder generator = new JcaX509v3CertificateBuilder(issuer, serial, NOT_BEFORE, NOT_AFTER, subject, pubKey);
        generator.addExtension(Extension.subjectKeyIdentifier, false, CertificateCreator.createSubjectKeyIdentifier(pubKey));
        generator.addExtension(Extension.basicConstraints, true, new BasicConstraints(true));
        KeyUsage usage = new KeyUsage(182);
        generator.addExtension(Extension.keyUsage, false, usage);
        ASN1EncodableVector purposes = new ASN1EncodableVector();
        purposes.add(KeyPurposeId.id_kp_serverAuth);
        purposes.add(KeyPurposeId.id_kp_clientAuth);
        purposes.add(KeyPurposeId.anyExtendedKeyUsage);
        generator.addExtension(Extension.extendedKeyUsage, false, new DERSequence(purposes));
        X509Certificate cert = CertificateCreator.signCertificate(generator, keyPair.getPrivate());
        KeyStore result = KeyStore.getInstance(keyStoreType);
        result.load(null, null);
        result.setKeyEntry(authority.alias(), keyPair.getPrivate(), authority.password(), new Certificate[]{cert});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SubjectKeyIdentifier createSubjectKeyIdentifier(Key key) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(key.getEncoded());
        try (FilterInputStream is = null;){
            is = new ASN1InputStream(bIn);
            ASN1Sequence seq = (ASN1Sequence)((ASN1InputStream)is).readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(seq);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
            return subjectKeyIdentifier;
        }
    }

    public static KeyStore createServerCertificate(String commonName, SubjectAlternativeNameHolder subjectAlternativeNames, Authority authority, Certificate caCert, PrivateKey caPrivKey) throws NoSuchAlgorithmException, NoSuchProviderException, IOException, OperatorCreationException, CertificateException, InvalidKeyException, SignatureException, KeyStoreException {
        KeyPair keyPair = CertificateCreator.generateKeyPair(4096);
        X500Name issuer = new X509CertificateHolder(caCert.getEncoded()).getSubject();
        BigInteger serial = BigInteger.valueOf(CertificateCreator.initRandomSerial());
        X500NameBuilder name = new X500NameBuilder(BCStyle.INSTANCE);
        name.addRDN(BCStyle.CN, commonName);
        name.addRDN(BCStyle.O, authority.certOrganisation());
        name.addRDN(BCStyle.OU, authority.certOrganizationalUnitName());
        X500Name subject = name.build();
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, NOT_BEFORE, NOT_AFTER, subject, keyPair.getPublic());
        builder.addExtension(Extension.subjectKeyIdentifier, false, CertificateCreator.createSubjectKeyIdentifier(keyPair.getPublic()));
        builder.addExtension(Extension.basicConstraints, false, new BasicConstraints(false));
        subjectAlternativeNames.fillInto(builder);
        X509Certificate cert = CertificateCreator.signCertificate(builder, caPrivKey);
        cert.checkValidity(new Date());
        cert.verify(caCert.getPublicKey());
        KeyStore result = KeyStore.getInstance("PKCS12");
        result.load(null, null);
        Certificate[] chain = new Certificate[]{cert, caCert};
        result.setKeyEntry(authority.alias(), keyPair.getPrivate(), authority.password(), chain);
        return result;
    }

    private static X509Certificate signCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey signedWithPrivateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(PROVIDER_NAME).build(signedWithPrivateKey);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(PROVIDER_NAME).getCertificate(certificateBuilder.build(signer));
        return cert;
    }

    public static TrustManager[] getTrustManagers(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String trustManAlg = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManAlg);
        tmf.init(keyStore);
        return tmf.getTrustManagers();
    }

    public static KeyManager[] getKeyManagers(KeyStore keyStore, Authority authority) throws NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException, KeyStoreException {
        String keyManAlg = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManAlg);
        kmf.init(keyStore, authority.password());
        return kmf.getKeyManagers();
    }

    public static long initRandomSerial() {
        Random rnd = new Random();
        rnd.setSeed(System.currentTimeMillis());
        long sl = (long)rnd.nextInt() << 32 | (long)rnd.nextInt() & 0xFFFFFFFFL;
        return sl &= 0xFFFFFFFFFFFFL;
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
        NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
        NOT_AFTER = new Date(System.currentTimeMillis() + 3153600000000L);
    }
}

