/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.demoiselle.signer.serpro.desktop.ui.NewToolsInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewLog
extends JDialog {
    private static final long serialVersionUID = 8350617380939787879L;
    private static final String PATH_HOME_USER = System.getProperty("user.home");
    private static final String FOLDER_ASSINADOR = ".serpro";
    private static final Path FULL_PATH_FOLDER_ASSINADOR = Paths.get(PATH_HOME_USER, ".serpro", "signer_desktop.log");
    private static final Logger logger = LoggerFactory.getLogger(ViewLog.class);
    private static boolean oldInterface = false;

    public ViewLog() {
        try {
            this.getContentPane().setBackground(Color.WHITE);
            this.setDefaultCloseOperation(2);
            this.setTitle("Log do Assinador");
            this.setSize(700, 430);
            this.setLocationRelativeTo(null);
            this.getContentPane().setLayout(null);
            this.setResizable(false);
            this.setAlwaysOnTop(true);
            this.setBackground(Color.WHITE);
            this.getRootPane().setBackground(Color.WHITE);
            this.setLocationByPlatform(true);
            final JTextArea txtArea = new JTextArea();
            txtArea.setAutoscrolls(true);
            txtArea.setFont(new Font("courier new", 0, 12));
            JScrollPane txtAreaScroll = new JScrollPane();
            txtAreaScroll.setViewportView(txtArea);
            txtAreaScroll.setAutoscrolls(true);
            txtAreaScroll.setBounds(5, 15, 690, 320);
            txtAreaScroll.setHorizontalScrollBarPolicy(32);
            String line = null;
            StringBuilder fileContents = new StringBuilder();
            try {
                File arqLog = new File(FULL_PATH_FOLDER_ASSINADOR.toString());
                BufferedReader br = new BufferedReader(new FileReader(arqLog));
                while ((line = br.readLine()) != null) {
                    fileContents.append(line + "\n");
                }
                br.close();
            }
            catch (IOException e1) {
                logger.error(e1.getMessage());
            }
            txtArea.setText(fileContents.toString());
            txtArea.setEditable(false);
            this.getContentPane().add(txtAreaScroll);
            final JButton btSelectAll = new JButton("Selecionar Tudo");
            btSelectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    txtArea.selectAll();
                    btSelectAll.transferFocusBackward();
                }
            });
            JButton btCopy = new JButton("Copiar para Colar");
            btCopy.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String texto = txtArea.getSelectedText();
                    StringSelection stringSelection = new StringSelection(texto);
                    Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clpbrd.setContents(stringSelection, null);
                }
            });
            JButton btClose = new JButton("Fechar ap\u00f3s colar");
            btClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewLog.this.dispose();
                }
            });
            btSelectAll.setBounds(50, 350, 160, 30);
            this.getContentPane().add(btSelectAll);
            btCopy.setBounds(250, 350, 160, 30);
            this.getContentPane().add(btCopy);
            btClose.setBounds(450, 350, 160, 30);
            this.getContentPane().add(btClose);
        }
        catch (Exception e) {
            logger.info("Erro no view log:" + e.getMessage());
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (!oldInterface) {
                    NewToolsInterface.getInstance().setVisible(true);
                }
            }
        });
    }

    public boolean isOldInterface() {
        return oldInterface;
    }

    public void setOldInterface(boolean oldInterface) {
        ViewLog.oldInterface = oldInterface;
    }
}

