/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.concurrent.ExecutionException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.bouncycastle.cms.CMSSignedData;
import org.demoiselle.signer.policy.impl.cades.pkcs7.impl.CAdESChecker;
import org.demoiselle.signer.serpro.desktop.Main;
import org.demoiselle.signer.serpro.desktop.command.cert.CertUtils;
import org.demoiselle.signer.serpro.desktop.command.signer.SignRequest;
import org.demoiselle.signer.serpro.desktop.command.xml.sign.RequestSignXML;
import org.demoiselle.signer.serpro.desktop.pkcs11info.KeystoreSelection;
import org.demoiselle.signer.serpro.desktop.ui.NewToolsInterface;
import org.demoiselle.signer.serpro.desktop.ui.OlderSignatureInfo;
import org.demoiselle.signer.serpro.desktop.ui.PinHandler;
import org.demoiselle.signer.serpro.desktop.ui.SignatureInfo;
import org.demoiselle.signer.serpro.desktop.ui.SignatureInfoXML;
import org.demoiselle.signer.serpro.desktop.ui.TimeStampInfo;
import org.demoiselle.signer.serpro.desktop.ui.VerifyXMLSignature;
import org.demoiselle.signer.serpro.desktop.ui.commons.Commons;
import org.demoiselle.signer.serpro.desktop.ui.commons.FileChooserSigner;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.pdf.NewPDFReader;
import org.demoiselle.signer.serpro.desktop.ui.pdf.TimestampPDF;
import org.demoiselle.signer.serpro.desktop.ui.pdf.VerifyPDFSignature;
import org.demoiselle.signer.serpro.desktop.ui.pdf.VerifyPDFTimeStamp;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiFunctions {
    private static final Logger logger = LoggerFactory.getLogger(UiFunctions.class);

    public void sign() throws Throwable {
        SignRequest request = new SignRequest();
        request.setType("file");
        request.setOutputDataType("file");
        Commons.SignOrdinaryFiles(request);
        NewToolsInterface.getInstance().setVisible(true);
        NewToolsInterface.getInstance().toFront();
        NewToolsInterface.getInstance().requestFocus();
        NewToolsInterface.getInstance().setExtendedState(0);
    }

    public void sign(String parmAttached) throws Throwable {
        logger.debug("Assinando Arquivo");
        SignRequest request = new SignRequest();
        request.setType("file");
        request.setOutputDataType("file");
        if (parmAttached != null && !parmAttached.trim().isEmpty()) {
            request.setAttached(parmAttached);
        }
        Commons.SignOrdinaryFiles(request);
        NewToolsInterface.getInstance().setVisible(true);
        NewToolsInterface.getInstance().toFront();
        NewToolsInterface.getInstance().requestFocus();
        NewToolsInterface.getInstance().setExtendedState(0);
    }

    public void signXML() throws Throwable {
        logger.debug("Assinando XML");
        RequestSignXML requestXML = new RequestSignXML();
        requestXML.setType("file");
        requestXML.setOutputDataType("file");
        Commons.SignXMLFiles(requestXML);
        NewToolsInterface.getInstance().setVisible(true);
        NewToolsInterface.getInstance().toFront();
        NewToolsInterface.getInstance().requestFocus();
        NewToolsInterface.getInstance().setExtendedState(0);
    }

    public void errorMessage(String title, String message) {
        this.setMessageDialogColorBackground();
        SignerDialog.showMessageDialog(null, message, title, 0);
    }

    private void setMessageDialogColorBackground() {
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
    }

    public void pdfSigner(Component parent) throws Exception {
        Main.showLoadingScreen("");
        logger.debug("Assinando PDF");
        FileChooserSigner fileChooser = new FileChooserSigner();
        fileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Pdf", "pdf", "PDF");
        fileChooser.addChoosableFileFilter(filter);
        Main.hideLoadingScreen();
        JFrame tempFrame = null;
        Component dialogParent = parent;
        if (parent == null) {
            tempFrame = new JFrame();
            tempFrame.setUndecorated(true);
            tempFrame.setType(Window.Type.UTILITY);
            tempFrame.setLocationRelativeTo(null);
            tempFrame.setAlwaysOnTop(true);
            tempFrame.setDefaultCloseOperation(2);
            tempFrame.setSize(0, 0);
            tempFrame.setVisible(true);
            dialogParent = tempFrame;
        }
        int returnValue = fileChooser.showOpenDialog(dialogParent);
        if (tempFrame != null) {
            tempFrame.dispose();
        }
        if (returnValue == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            String fileName = selectedFile.getAbsolutePath();
            Main.hideLoadingScreen();
            new NewPDFReader((Frame)parent, fileName, false);
            NewToolsInterface.getInstance().setVisible(true);
            NewToolsInterface.getInstance().toFront();
            NewToolsInterface.getInstance().requestFocus();
            NewToolsInterface.getInstance().setExtendedState(0);
        } else {
            Main.hideLoadingScreen();
            NewToolsInterface.getInstance().setVisible(true);
        }
    }

    public void validate() throws CertificateException, IOException {
        block22: {
            String contentFile = "";
            String signatureFile = "";
            this.setMessageDialogColorBackground();
            String infoText = "<html><body><h1>Valida\u00e7\u00e3o de Assinaturas</h1><p style='margin:5px; color:#0075dd; font-size:14px;font-weight:bold'>O processo de valida\u00e7\u00e3o de assinatura(s) permite: </p><p style='margin:5px'>- Verificar se um arquivo corresponde \u00e0 uma assinatura desanexada em um arquivo no formato P7S e se a(s) assinatura(s) nele s\u00e3o v\u00e1lidas</p><p style='margin:5px'>- Validar a assinatura em um arquivo no formato P7S com cont\u00e9udo anexado. </p><p style='margin:5px'>- Validar um arquivo no formato PDF Assinado</p><p style='margin:5px'>- Validar um arquivo no formato XML Assinado </p><br/><p style='margin:5px; color:#0075dd; font-size:14px;font-weight:bold'>Para isso \u00e9 necess\u00e1rio seguir os seguintes passos:</p><p style='margin:5px'>1 - Informe o arquivo de Assinatura no formato <b>.p7s</b> ou um <b>PDF</b> ou um <b>XML</b></p><p style='margin:5px'>2 - Caso n\u00e3o seja um  <b>.p7s</b> anexado, tamb\u00e9m ter\u00e1 que informar o arquivo original correspondente \u00e0 assinatura.</p></body></html>";
            JLabel label = new JLabel();
            label.setText(infoText);
            SignerDialog.showMessageDialog(null, label, "Processo de Valida\u00e7\u00e3o de Assinatura", 1);
            JFileChooser fileChooserSig = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
            fileChooserSig.setDialogTitle("Selecione o Arquivo de Assinatura (p7s) ou PDF ou XML");
            fileChooserSig.setAcceptAllFileFilterUsed(false);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivo da Assinatura (.p7s) ou PDF ou XML", "p7s", "pdf", "P7S", "PDF", "xml", "XML");
            fileChooserSig.addChoosableFileFilter(filter);
            int returnValue = fileChooserSig.showOpenDialog(null);
            if (returnValue == 0) {
                Object verify;
                File selectedFile = fileChooserSig.getSelectedFile();
                signatureFile = selectedFile.getAbsolutePath();
                if ((FilenameUtils.getExtension(signatureFile).equals("p7s") || FilenameUtils.getExtension(signatureFile).equals("P7S")) && this.hasContentOnSignature(signatureFile)) {
                    try {
                        new SignatureInfo(signatureFile).init();
                        return;
                    }
                    catch (Exception e) {
                        Main.hideLoadingScreen();
                        logger.info("Erro" + e.getMessage());
                    }
                }
                if (FilenameUtils.getExtension(signatureFile).equalsIgnoreCase("pdf")) {
                    verify = new VerifyPDFSignature(signatureFile);
                    if (((VerifyPDFSignature)verify).testSignature()) {
                        try {
                            new SignatureInfo((VerifyPDFSignature)verify).init();
                            return;
                        }
                        catch (Exception e) {
                            Main.hideLoadingScreen();
                            logger.info("Erro" + e.getMessage());
                            SignerDialog.showMessageDialog(null, "Ocorreu um erro na valida\u00e7\u00e3o da assinatura", "Erro", 0);
                        }
                    } else {
                        Main.hideLoadingScreen();
                        ((VerifyPDFSignature)verify).finishVerification();
                        SignerDialog.showMessageDialog(null, "O arquivo PDF selecionado n\u00e3o cont\u00e9m nenhuma assinatura, ou carimbo do tempo", "Erro", 0);
                        return;
                    }
                }
                if (FilenameUtils.getExtension(signatureFile).equalsIgnoreCase("xml")) {
                    verify = new VerifyXMLSignature(signatureFile);
                    if (((VerifyXMLSignature)verify).testSignature()) {
                        try {
                            new SignatureInfoXML((VerifyXMLSignature)verify).init();
                            return;
                        }
                        catch (Exception e) {
                            Main.hideLoadingScreen();
                            logger.info("Erro" + e.getMessage());
                            SignerDialog.showMessageDialog(null, "Ocorreu um erro na valida\u00e7\u00e3o da assinatura XML <br>" + e.getMessage(), "Erro", 0);
                        }
                    } else {
                        Main.hideLoadingScreen();
                        SignerDialog.showMessageDialog(null, "O arquivo XML selecionado n\u00e3o cont\u00e9m nenhuma assinatura", "Erro", 0);
                        return;
                    }
                }
                JFileChooser fileChooserContent = new JFileChooser(fileChooserSig.getCurrentDirectory());
                fileChooserContent.setDialogTitle("Selecione o Arquivo de Conte\u00fado");
                fileChooserContent.setAcceptAllFileFilterUsed(true);
                returnValue = fileChooserContent.showOpenDialog(null);
                if (returnValue == 0) {
                    try {
                        selectedFile = fileChooserContent.getSelectedFile();
                        contentFile = selectedFile.getAbsolutePath();
                        if (this.isOlderVersion(signatureFile)) {
                            new OlderSignatureInfo(contentFile, signatureFile).init();
                            break block22;
                        }
                        new SignatureInfo(contentFile, signatureFile).init();
                    }
                    catch (Exception e) {
                        Main.hideLoadingScreen();
                        SignerDialog.showMessageDialog(null, "Ocorreu um erro desconhecido na valida\u00e7\u00e3o da assinatura", "Erro", 0);
                    }
                } else if (returnValue == 1) {
                    Main.hideLoadingScreen();
                    SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
                }
            } else if (returnValue == 1) {
                Main.hideLoadingScreen();
                SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
            }
        }
    }

    public void pdfTimestamp() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Pdf", "pdf", "PDF");
        fileChooser.addChoosableFileFilter(filter);
        NewToolsInterface parent = NewToolsInterface.getInstance().isVisible() ? NewToolsInterface.getInstance() : null;
        int returnValue = fileChooser.showOpenDialog(parent);
        if (returnValue == 0) {
            final String fileName = fileChooser.getSelectedFile().getAbsolutePath();
            Main.showLoadingScreen("Aplicando carimbo de tempo...");
            SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){
                private Throwable error = null;

                @Override
                protected String doInBackground() throws Exception {
                    String pathStamped = fileName.replaceAll("(?i)\\.pdf$", "-time.pdf");
                    try {
                        KeyStore keyStore = new KeystoreSelection(new PinHandler("Aplicar Carimbo do Tempo", null)).getKeyStore();
                        if (keyStore == null) {
                            throw new Exception("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
                        }
                        String alias = CertUtils.getAlias(null, keyStore, null);
                        if (alias == null) {
                            throw new Exception("A\u00e7\u00e3o cancelada pelo usu\u00e1rio");
                        }
                        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, null);
                        Certificate[] chain = keyStore.getCertificateChain(alias);
                        File file = new File(fileName);
                        File fileStamped = new File(pathStamped);
                        PDDocument pdf = PDDocument.load(file);
                        TimestampPDF ts = new TimestampPDF(pdf, privateKey, chain);
                        ts.toStamp(new FileOutputStream(fileStamped));
                        return pathStamped;
                    }
                    catch (Throwable e) {
                        this.error = e;
                        FileUtils.deleteQuietly(new File(pathStamped));
                        return null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    Main.hideLoadingScreen();
                    try {
                        String tempPath = (String)this.get();
                        if (this.error != null) {
                            throw this.error;
                        }
                        UiFunctions.this.replaceFileMessage(tempPath, fileName, "O Arquivo original ser\u00e1 substitu\u00eddo pelo arquivo com carimbo do tempo, \u00e9 poss\u00edvel criar um novo, com outro nome. Deseja criar?", "Ocorreu algum erro ao tentar gerar o arquivo com carimbo do tempo, tente novamente");
                    }
                    catch (Throwable e) {
                        Throwable cause = e;
                        if (e instanceof ExecutionException) {
                            cause = e.getCause();
                        }
                        if (cause != null && cause.getCause() != null && cause.getCause().getCause() != null && "O token de carimbo de tempo foi rejeitado".equals(cause.getCause().getCause().getMessage())) {
                            SignerDialog.showMessageDialog(null, "O token de carimbo de tempo foi rejeitado", "Erro", 0);
                        } else {
                            String message = cause != null && cause.getMessage() != null ? cause.getMessage() : "Ocorreu um erro desconhecido.";
                            SignerDialog.showMessageDialog(null, message, "Erro", 0);
                        }
                        logger.error("Erro ao aplicar carimbo de tempo em PDF.", cause);
                    }
                    finally {
                        NewToolsInterface.getInstance().setVisible(true);
                    }
                }
            };
            worker.execute();
        } else {
            NewToolsInterface.getInstance().setVisible(true);
            NewToolsInterface.getInstance().toFront();
        }
    }

    public boolean replaceFileMessage(String tempFileName, String outputFileName, String questionMessage, String failMessage) {
        int result = JOptionPane.showConfirmDialog(null, questionMessage, "Criar Novo Arquivo", 0);
        if (result == 0) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setAcceptAllFileFilterUsed(false);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("pdf", "PDF");
            fileChooser.addChoosableFileFilter(filter);
            fileChooser.setApproveButtonText("Salvar");
            fileChooser.setFileSelectionMode(2);
            fileChooser.setCurrentDirectory(new File(tempFileName));
            int returnValue = fileChooser.showSaveDialog(fileChooser);
            if (returnValue == 0 && !(outputFileName = fileChooser.getSelectedFile().getAbsolutePath()).toLowerCase().endsWith(".pdf")) {
                outputFileName = outputFileName + ".pdf";
            }
        }
        FileUtils.deleteQuietly(new File(outputFileName));
        try {
            FileUtils.moveFile(new File(tempFileName), new File(outputFileName));
            SignerDialog.showMessageDialog(null, "Arquivo gerado com sucesso: " + outputFileName, "Sucesso", 1);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            SignerDialog.showMessageDialog(null, failMessage, "Falha", 0);
            return false;
        }
        return true;
    }

    private boolean isOlderVersion(String signatureFileName) {
        try {
            CAdESChecker checker = new CAdESChecker();
            byte[] firstSignature = this.readContent(signatureFileName);
            new CMSSignedData(firstSignature);
            byte[] novaAssinatura = checker.getAttached(firstSignature, false).getExtractedContent();
            new CMSSignedData(novaAssinatura);
            logger.info("Assinatura feita na vers\u00e3o Applet do SERPRO");
            return true;
        }
        catch (Throwable error) {
            return false;
        }
    }

    private byte[] readContent(String arquivo) {
        byte[] result = null;
        try {
            File file = new File(arquivo);
            FileInputStream is = new FileInputStream(file);
            result = new byte[(int)file.length()];
            is.read(result);
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private boolean hasContentOnSignature(String signatureFile) {
        CAdESChecker checker = new CAdESChecker();
        byte[] signatureContent = FileUtil.readContent(signatureFile);
        byte[] attachedContent = checker.getAttached(signatureContent, false).getExtractedContent();
        return attachedContent != null && attachedContent.length > 0;
    }

    public void validateTimeStamp() throws CertificateException, IOException {
        String contentFile = "";
        String timeStampFile = "";
        this.setMessageDialogColorBackground();
        String infoText = "<html><body><h1>Valida\u00e7\u00e3o de Carimbo do Tempo</h1><p style='margin:5px; color:#0075dd; font-size:14px;font-weight:bold'>O processo de valida\u00e7\u00e3o de Carimbo do Tempo permite: </p><p style='margin:5px'>- Verificar se um arquivo corresponde \u00e0 um Carimbo do Tempo desanexado em um arquivo no formato P7S e se o carimbo \u00e9 valido</p><p style='margin:5px'>- Validar um carimbo anexado em arquivo no formato PDF</p><p style='margin:5px; color:#0075dd; font-size:14px;font-weight:bold'>Para isso \u00e9 necess\u00e1rio seguir os seguintes passos:</p><p style='margin:5px'>1 - Informe um arquivo no formato <b>p7s</b> ou um <b>PDF</b>, com o Carimbo do Tempo</p><p style='margin:5px'>2 - Caso seja um  <b>.p7s</b>, tamb\u00e9m ter\u00e1 que informar o arquivo original correspondente ao Carimbo.</p></body></html>";
        JLabel label = new JLabel();
        label.setText(infoText);
        SignerDialog.showMessageDialog(null, label, "Processo de Valida\u00e7\u00e3o de Carimbo do Tempo", 1);
        JFileChooser fileChooserTS = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
        fileChooserTS.setDialogTitle("Selecione o Arquivo de Carimbo do Tempo (p7s) ou PDF com Carimbo");
        fileChooserTS.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Arquivo da Assinatura (.p7s) ou PDF Assinado", "p7s", "pdf", "P7S", "PDF");
        fileChooserTS.addChoosableFileFilter(filter);
        int returnValue = fileChooserTS.showOpenDialog(null);
        if (returnValue == 0) {
            File selectedFile = fileChooserTS.getSelectedFile();
            timeStampFile = selectedFile.getAbsolutePath();
            if (FilenameUtils.getExtension(timeStampFile).equals("pdf") || FilenameUtils.getExtension(timeStampFile).equals("PDF")) {
                VerifyPDFTimeStamp verify = new VerifyPDFTimeStamp(timeStampFile);
                if (verify.testSignature()) {
                    try {
                        new TimeStampInfo(verify).init();
                        return;
                    }
                    catch (Exception e) {
                        logger.info("Erro" + e.getMessage());
                        SignerDialog.showMessageDialog(null, "Ocorreu um erro na valida\u00e7\u00e3o do Carimbo do Tempo", "Erro", 0);
                    }
                } else {
                    verify.finishVerification();
                    SignerDialog.showMessageDialog(null, "O arquivo PDF selecionado n\u00e3o cont\u00e9m nenhum Carimbo do Tempo", "Erro", 0);
                    return;
                }
            }
            JFileChooser fileChooserContent = new JFileChooser(fileChooserTS.getCurrentDirectory());
            fileChooserContent.setDialogTitle("Selecione o Arquivo referente ao Carimbo do Tempo");
            fileChooserContent.setAcceptAllFileFilterUsed(true);
            returnValue = fileChooserContent.showOpenDialog(null);
            if (returnValue == 0) {
                try {
                    selectedFile = fileChooserContent.getSelectedFile();
                    contentFile = selectedFile.getAbsolutePath();
                    new TimeStampInfo(contentFile, timeStampFile).init();
                }
                catch (Exception e) {
                    SignerDialog.showMessageDialog(null, "Ocorreu um erro desconhecido na valida\u00e7\u00e3o do Carimbo do Tempo", "Erro", 0);
                }
            } else if (returnValue == 1) {
                SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
            }
        } else if (returnValue == 1) {
            SignerDialog.showMessageDialog(null, "A\u00e7\u00e3o cancelada pelo usu\u00e1rio", "Cancelado", 1);
        }
    }

    public void fileTimestamp() {
        SignRequest request = new SignRequest();
        request.setType("timeStampOnly");
        request.setOutputDataType("file");
        Commons.timeStamp(request);
    }
}

