/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.demoiselle.signer.serpro.desktop.AppVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerproSignerConfigurations
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final SerproSignerConfigurations INSTANCE = new SerproSignerConfigurations();
    public static final String CONFIGURATIONS_URL = "https://cliente-assinadorserpro.estaleiro.serpro.gov.br/";
    public static final String STAMP_IMAGE_FILE = "images/stampInfo.png";
    public static final String STAMP_CLOCK_IMAGE_FILE = "images/stampClockN.png";
    public static final String STAMP_IMAGE_EXTRA_FILE = "images/stampExtraInfo.png";
    public static final String STAMP_IMAGE_EXTRA_FILE_TS = "images/stampExtraInfoTS.png";
    private static final String PATH_HOME_USER = System.getProperty("user.home");
    private static final String FOLDER_ASSINADOR = ".serpro";
    private static final Path FULL_PATH_FOLDER_ASSINADOR = Paths.get(PATH_HOME_USER, ".serpro", "signer_config.properties");
    public static final Path FULL_PATH_FOLDER_THEME = Paths.get(SerproSignerConfigurations.getPathHomeUser(), SerproSignerConfigurations.getFolderAssinador(), "theme");
    public static final Path FULL_PATH_DEFAULT_THEME_FILE = Paths.get(SerproSignerConfigurations.getPathHomeUser(), SerproSignerConfigurations.getFolderAssinador(), "theme", ".default");
    public static final String DEFAULT_THEME_FILE = PATH_HOME_USER + File.separator + ".serpro" + File.separator + "theme" + File.separator + ".default";
    private String proxyEndereco = null;
    private String proxyPorta = null;
    private String proxyUsuario = null;
    private char[] proxySenha = null;
    private boolean msCAPIOff = false;
    private boolean lcrCache = true;
    private boolean useCertificateFile = false;
    private String certificateFilePath = null;
    private boolean saveCertificateFilePass = false;
    private char[] certificateFilePass = null;
    private boolean useNeoId = false;
    private boolean selectedToken = false;
    private String tokenNameSelected = null;
    private boolean logOffToken = false;
    private boolean usePBAD = false;
    private boolean serverMultiUser = false;
    private Map<String, String> theme = new HashMap<String, String>();
    private String defaultTheme = "";
    private Date certificateDateExpNoShow = null;
    private boolean fixedStamp = false;
    private int[] stampPosition = new int[]{0, 0};
    private String[] stampPositionOptions = new String[0];
    private Short stampInfo = 0;
    private boolean chooseFileCertificate = false;
    private Date versionOldNoShow = null;
    private boolean lpaOnline = false;
    private boolean debugOn = false;
    private int sizePDF = 50;
    private boolean lcrOff = false;
    private String ntpServerWeb = "pool.ntp.br";
    private String ntpServerLocal = "10.30.68.2";
    public static String version = "";
    public static String envName = "";
    private static final Logger logger = LoggerFactory.getLogger(SerproSignerConfigurations.class);

    private SerproSignerConfigurations() {
    }

    public static SerproSignerConfigurations getInstance() {
        return INSTANCE;
    }

    public Map<String, String> getTheme() {
        return this.theme;
    }

    public String getProxyEndereco() {
        return this.proxyEndereco;
    }

    public boolean isUseCertificateFile() {
        return this.useCertificateFile;
    }

    public void setUseCertificateFile(boolean useCertificateFile) {
        this.useCertificateFile = useCertificateFile;
    }

    public String getCertificateFilePath() {
        return this.certificateFilePath;
    }

    public void setCertificateFilePath(String certificateFilePath) {
        this.certificateFilePath = certificateFilePath;
    }

    public boolean isUseNeoId() {
        return this.useNeoId;
    }

    public void setUseNeoId(boolean useNeoId) {
        this.useNeoId = useNeoId;
    }

    public boolean isSelectedToken() {
        return this.selectedToken;
    }

    public void setSelectedToken(boolean selectedToken) {
        this.selectedToken = selectedToken;
    }

    public String getTokenNameSelected() {
        return this.tokenNameSelected;
    }

    public void setTokenNameSelected(String tokenNameSelected) {
        this.tokenNameSelected = tokenNameSelected;
    }

    public void setProxyEndereco(String proxyEndereco) {
        this.proxyEndereco = proxyEndereco;
    }

    public String getProxyPorta() {
        return this.proxyPorta;
    }

    public void setProxyPorta(String proxyPorta) {
        this.proxyPorta = proxyPorta;
    }

    public String getProxyUsuario() {
        return this.proxyUsuario;
    }

    public void setProxyUsuario(String proxyUsuario) {
        this.proxyUsuario = proxyUsuario;
    }

    public char[] getProxySenha() {
        return this.proxySenha;
    }

    public void setProxySenha(char[] proxySenha) {
        this.proxySenha = proxySenha;
    }

    public boolean isMsCAPIOff() {
        return this.msCAPIOff;
    }

    public void setMsCAPIOff(boolean msCAPIOff) {
        this.msCAPIOff = msCAPIOff;
    }

    public boolean isLcrCache() {
        return this.lcrCache;
    }

    public void setLcrCache(boolean lcrCache) {
        this.lcrCache = lcrCache;
    }

    public static String getPathHomeUser() {
        return PATH_HOME_USER;
    }

    public static String getFolderAssinador() {
        return FOLDER_ASSINADOR;
    }

    public static Path getFullPathFolderAssinador() {
        return FULL_PATH_FOLDER_ASSINADOR;
    }

    public boolean isSaveCertificateFilePass() {
        return this.saveCertificateFilePass;
    }

    public void setSaveCertificateFilePass(boolean saveCertificateFilePass) {
        this.saveCertificateFilePass = saveCertificateFilePass;
    }

    public char[] getCertificateFilePass() {
        return this.certificateFilePass;
    }

    public void setCertificateFilePass(char[] certificateFilePass) {
        this.certificateFilePass = certificateFilePass;
    }

    public boolean isLogOffToken() {
        return this.logOffToken;
    }

    public void setLogOffToken(boolean logOffToken) {
        this.logOffToken = logOffToken;
    }

    public boolean isUsePBAD() {
        return this.usePBAD;
    }

    public void setUsePBAD(boolean usePBAD) {
        this.usePBAD = usePBAD;
    }

    public boolean isServerMultiUser() {
        return this.serverMultiUser;
    }

    public void setServerMultiUser(boolean serverMultiUser) {
        this.serverMultiUser = serverMultiUser;
    }

    public String getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setDefaultTheme(String defaultTheme) {
        this.defaultTheme = defaultTheme;
    }

    public Date getCertificateDateExpNoShow() {
        return this.certificateDateExpNoShow;
    }

    public void setCertificateDateExpNoShow(Date certificateDateExpNoShow) {
        this.certificateDateExpNoShow = certificateDateExpNoShow;
    }

    public boolean isFixedStamp() {
        return this.fixedStamp;
    }

    public void setFixedStamp(boolean fixedStamp) {
        this.fixedStamp = fixedStamp;
    }

    public int[] getStampPosition() {
        return this.stampPosition;
    }

    public void setStampPosition(int[] stampPosition) {
        this.stampPosition = stampPosition;
    }

    public String[] getStampPositionOptions() {
        return this.stampPositionOptions;
    }

    public void setStampPositionOptions(String stampPositionOptions) {
        this.stampPositionOptions = stampPositionOptions.split(",");
    }

    public Short getStampInfo() {
        return this.stampInfo;
    }

    public void setStampInfo(Short stampInfo) {
        this.stampInfo = stampInfo;
    }

    public boolean isChooseFileCertificate() {
        return this.chooseFileCertificate;
    }

    public void setChooseFileCertificate(boolean chooseFileCertificate) {
        this.chooseFileCertificate = chooseFileCertificate;
    }

    public Date getVersionOldNoShow() {
        return this.versionOldNoShow;
    }

    public void setVersionOldNoShow(Date versionOldNoShow) {
        this.versionOldNoShow = versionOldNoShow;
    }

    public boolean isLpaOnline() {
        return this.lpaOnline;
    }

    public void setLpaOnline(boolean lpaOnline) {
        this.lpaOnline = lpaOnline;
    }

    public boolean isDebugOn() {
        return this.debugOn;
    }

    public void setDebugOn(boolean debugOn) {
        this.debugOn = debugOn;
    }

    public int getSizePDF() {
        return this.sizePDF;
    }

    public void setSizePDF(int sizePDF) {
        this.sizePDF = sizePDF;
    }

    public boolean isLcrOff() {
        return this.lcrOff;
    }

    public void setLcrOff(boolean lcrOff) {
        this.lcrOff = lcrOff;
    }

    public String getNtpServerWeb() {
        return this.ntpServerWeb;
    }

    public void setNtpServerWeb(String ntpServerWeb) {
        this.ntpServerWeb = ntpServerWeb;
    }

    public String getNtpServerLocal() {
        return this.ntpServerLocal;
    }

    public void setNtpServerLocal(String ntpServerLocal) {
        this.ntpServerLocal = ntpServerLocal;
    }

    static {
        Properties properties = new Properties();
        try (InputStream input = SerproSignerConfigurations.class.getClassLoader().getResourceAsStream("agent-desktop.properties");){
            if (input != null) {
                properties.load(input);
                version = properties.getProperty("version", "");
                if (version.equals("${project.version}")) {
                    version = AppVersion.VERSION;
                }
                envName = properties.getProperty("env.name", "");
                logger.info("Ambiente carregado: {}", (Object)envName);
            }
        }
        catch (IOException ex) {
            logger.error("Falha ao carregar propriedades: {}", (Object)ex.getMessage());
        }
    }
}

