/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.UIManager;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.Base64Utils;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.ui.configuration.ConfigProperties;
import org.demoiselle.signer.serpro.desktop.utils.ConfiguracoesVolateis;
import org.demoiselle.signer.serpro.desktop.utils.StringUtil;
import org.demoiselle.signer.timestamp.configuration.TimeStampConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadConfig {
    private static final Logger logger = LoggerFactory.getLogger(ReadConfig.class);
    private static SerproSignerConfigurations configAssinador = SerproSignerConfigurations.getInstance();
    private static Configuration configSigner = Configuration.getInstance();
    private static ReadConfig instance = new ReadConfig();
    private static Properties props;

    public static Properties getProps() {
        return props;
    }

    public static ReadConfig getInstance() {
        return instance;
    }

    private ReadConfig() {
    }

    public static void doConfig() {
        try {
            String varIsApiSERPRO;
            String varNTPLocal;
            String varLCROff;
            String varTamanhoPDF;
            String varLpaOnline;
            String varDateNewVersionNoShow;
            String varDateExpCertificate;
            String varServerMultiUser;
            String tokenSelecionado;
            String varPBADon;
            String varNeoIDon;
            String varLogOffToken;
            String selecionarCertificadoArquivo;
            boolean desabilitar;
            String varDriverPath;
            if (!configSigner.getSO().contains("indows")) {
                System.setProperty("pdfbox.fontcache", Paths.get(SerproSignerConfigurations.getPathHomeUser(), SerproSignerConfigurations.getFolderAssinador()).toString());
            }
            props = new Properties();
            File arqConf = new File(SerproSignerConfigurations.getFullPathFolderAssinador().toString());
            FileInputStream is = null;
            is = new FileInputStream(arqConf);
            props.load(is);
            ReadConfig.configureProxy();
            ConfigurationRepo repoConfig = ConfigurationRepo.getInstance();
            UIManager.put("OptionPane.background", Color.WHITE);
            UIManager.put("Panel.background", Color.WHITE);
            String varMsCAPIOff = props.getProperty("user.mscapi.off");
            if (varMsCAPIOff != null && !varMsCAPIOff.isEmpty() && varMsCAPIOff.length() > 1) {
                Configuration configSigner;
                if (ReadConfig.configSigner.getSO().contains("indows")) {
                    configAssinador.setMsCAPIOff(Boolean.parseBoolean(varMsCAPIOff));
                    if (configAssinador.isMsCAPIOff()) {
                        configSigner = Configuration.getInstance();
                        configSigner.setMSCAPI_ON(false);
                        configSigner.doConfiguration();
                    }
                } else {
                    configSigner = Configuration.getInstance();
                    configAssinador.setMsCAPIOff(true);
                    configSigner.setMSCAPI_ON(false);
                }
            }
            if (!System.getProperty("os.name").toLowerCase().contains("indows")) {
                configAssinador.setMsCAPIOff(true);
            }
            if ((varDriverPath = props.getProperty("user.driver.file.path")) != null && !varDriverPath.isEmpty() && varDriverPath.length() > 1) {
                ReadConfig.loadDriver(varDriverPath);
            }
            logger.info("Assinador com  MSCAPI OFF: " + configAssinador.isMsCAPIOff() + "  Signer com MSCAPI: " + Configuration.getInstance().isMSCAPI_ON());
            String varLcrCache = props.getProperty("user.lcr.cache");
            if (varLcrCache != null && !varLcrCache.isEmpty() && varLcrCache.length() > 1) {
                configAssinador.setLcrCache(Boolean.parseBoolean(varLcrCache));
            }
            if (configAssinador.isLcrCache()) {
                String varCacheLocal = props.getProperty("user.lcr.cache.local");
                if (varCacheLocal == null || varCacheLocal.isEmpty()) {
                    varCacheLocal = Paths.get(SerproSignerConfigurations.getPathHomeUser(), SerproSignerConfigurations.getFolderAssinador()).toString();
                }
                repoConfig.setCrlPath(varCacheLocal);
                repoConfig.setOnline(false);
                props.setProperty("user.lcr.cache", String.valueOf(configAssinador.isLcrCache()));
                props.setProperty("user.lcr.cache.local", repoConfig.getCrlPath());
                logger.info("Cache Local: " + repoConfig.getCrlPath());
                logger.info("Cache Index: " + repoConfig.getCrlIndex());
                logger.info("LCR Online?: " + repoConfig.isOnline());
            }
            logger.info("LCR cache: " + configAssinador.isLcrCache());
            String desabilitarEstatisticas = props.getProperty("user.statistics.off");
            Statistics instaSta = new Statistics();
            if (desabilitarEstatisticas != null && !desabilitarEstatisticas.isEmpty() && desabilitarEstatisticas.length() > 1 && (desabilitar = Boolean.parseBoolean(desabilitarEstatisticas))) {
                instaSta.setCollecting(false);
            }
            logger.info("Estat\u00edsticas: " + instaSta.isCollecting());
            repoConfig.setLpaPath(Paths.get(SerproSignerConfigurations.getPathHomeUser(), SerproSignerConfigurations.getFolderAssinador(), "LPAs").toString());
            String usarCertificadoArquivo = props.getProperty("user.certificate.file.status");
            if (usarCertificadoArquivo != null && !usarCertificadoArquivo.isEmpty() && usarCertificadoArquivo.length() > 1) {
                boolean statusCertificadoArquivo = Boolean.parseBoolean(usarCertificadoArquivo);
                if (statusCertificadoArquivo) {
                    configAssinador.setCertificateFilePath(props.getProperty("user.certificate.file.path"));
                    configAssinador.setUseCertificateFile(statusCertificadoArquivo);
                    String varWord = props.getProperty("user.certificate.file.word");
                    logger.info("Configurado o certificado: " + configAssinador.getCertificateFilePath());
                    if (varWord != null && !varWord.isEmpty()) {
                        byte[] varBytes = Base64Utils.base64Decode(varWord);
                        String strCertPass = new String(varBytes, StandardCharsets.UTF_8);
                        configAssinador.setCertificateFilePass(strCertPass.toCharArray());
                        configAssinador.setSaveCertificateFilePass(true);
                        logger.info("Configurado certificado");
                    }
                }
                logger.info("Certificado em arquivo:" + configAssinador.isUseCertificateFile());
            }
            if ((selecionarCertificadoArquivo = props.getProperty("user.certificate.file.choose")) != null && !selecionarCertificadoArquivo.isEmpty() && selecionarCertificadoArquivo.length() > 1) {
                boolean statusSelecionarCertificadoArquivo = Boolean.parseBoolean(selecionarCertificadoArquivo);
                configAssinador.setChooseFileCertificate(statusSelecionarCertificadoArquivo);
                logger.info("Op\u00e7\u00e3o de selecionar certificado em arquivo ao assinar:" + configAssinador.isChooseFileCertificate());
            }
            if ((varLogOffToken = props.getProperty("user.logoff.token")) != null && !varLogOffToken.isEmpty() && varLogOffToken.length() > 1) {
                configAssinador.setLogOffToken(Boolean.parseBoolean(varLogOffToken));
                logger.info("LogOff Token: " + configAssinador.isLogOffToken());
            }
            if ((varNeoIDon = props.getProperty("user.neoid.on")) != null && !varNeoIDon.isEmpty() && varNeoIDon.length() > 1) {
                configAssinador.setUseNeoId(Boolean.parseBoolean(varNeoIDon));
                logger.info("Somente SerproID: " + configAssinador.isUseNeoId());
            }
            if ((varPBADon = props.getProperty("user.pbad.on")) != null && !varPBADon.isEmpty() && varPBADon.length() > 1) {
                configAssinador.setUsePBAD(Boolean.parseBoolean(varPBADon));
                logger.info("Priorizar PBAD: " + configAssinador.isUsePBAD());
            }
            if ((tokenSelecionado = props.getProperty("user.selected.token.status")) != null && !tokenSelecionado.isEmpty() && tokenSelecionado.length() > 1) {
                String varTokenName;
                boolean statusTokenSelecionado = Boolean.parseBoolean(tokenSelecionado);
                if (statusTokenSelecionado && (varTokenName = props.getProperty("user.selected.token.name")) != null && !varTokenName.isEmpty() && varTokenName.length() > 1) {
                    configAssinador.setTokenNameSelected(varTokenName);
                    configAssinador.setSelectedToken(statusTokenSelecionado);
                }
                logger.info("Token Selecionado:" + configAssinador.getTokenNameSelected());
            }
            if ((varServerMultiUser = props.getProperty("server.multi.user.on")) != null && !varServerMultiUser.isEmpty() && varServerMultiUser.length() > 1) {
                configAssinador.setServerMultiUser(Boolean.parseBoolean(varServerMultiUser));
                logger.info("Multi Usu\u00e1rio: " + configAssinador.isServerMultiUser());
            }
            if ((varDateExpCertificate = props.getProperty("user.certificate.exp.show")) != null && !varDateExpCertificate.isEmpty() && varDateExpCertificate.length() > 1) {
                Date dateFormated = new SimpleDateFormat("dd-MM-yyyy").parse(varDateExpCertificate);
                long millisDateDisableToNow = 0L;
                millisDateDisableToNow = new Date().getTime() - dateFormated.getTime();
                long daysDisabelToNow = millisDateDisableToNow / 86400000L;
                if (daysDisabelToNow >= 30L) {
                    props.remove("user.certificate.exp.show");
                    FileOutputStream fos = new FileOutputStream(arqConf);
                    props.store(fos, "Configura\u00e7\u00f5es do usu\u00e1rio");
                    fos.close();
                    configAssinador.setCertificateDateExpNoShow(null);
                } else {
                    configAssinador.setCertificateDateExpNoShow(dateFormated);
                }
                logger.info("Aviso Data expira\u00e7\u00e3o:" + dateFormated);
            }
            if (props.getProperty("user.pdf.fixstamp") != null) {
                if (!props.getProperty("user.pdf.fixstamp").equals("true")) {
                    return;
                }
                try {
                    int stampX = Integer.parseInt(props.getProperty("user.pdf.x"));
                    int stampY = Integer.parseInt(props.getProperty("user.pdf.y"));
                    configAssinador.setFixedStamp(true);
                    configAssinador.setStampPosition(new int[]{stampX, stampY});
                    if (props.getProperty("user.pdf.positions") != null) {
                        configAssinador.setStampPositionOptions(props.getProperty("user.pdf.positions"));
                    }
                    logger.info("Posi\u00e7\u00e3o do selo definido em X = " + stampX + " Y = " + stampY);
                }
                catch (NumberFormatException e) {
                    logger.info("Posi\u00e7\u00e3o inv\u00e1lida do selo em aquivos em lote");
                }
            }
            if (props.getProperty("user.pdf.stamp.config") != null) {
                configAssinador.setStampInfo(Short.valueOf(props.getProperty("user.pdf.stamp.config")));
            }
            if ((varDateNewVersionNoShow = props.getProperty("user.new.version.noshow")) != null && !varDateNewVersionNoShow.isEmpty() && varDateNewVersionNoShow.length() > 1) {
                Date dateFormated = new SimpleDateFormat("dd-MM-yyyy").parse(varDateNewVersionNoShow);
                long millisDateDisableToNow = 0L;
                millisDateDisableToNow = new Date().getTime() - dateFormated.getTime();
                long daysDisabelToNow = millisDateDisableToNow / 86400000L;
                if (daysDisabelToNow >= 30L) {
                    props.remove("user.new.version.noshow");
                    FileOutputStream fos = new FileOutputStream(arqConf);
                    props.store(fos, "Configura\u00e7\u00f5es do usu\u00e1rio");
                    fos.close();
                    configAssinador.setVersionOldNoShow(null);
                } else {
                    configAssinador.setVersionOldNoShow(dateFormated);
                }
                logger.info("Aviso Nova Vers\u00e3o:" + dateFormated);
            }
            if ((varLpaOnline = props.getProperty("user.lpa.online")) != null && !varLpaOnline.isEmpty() && varLpaOnline.length() > 1) {
                configAssinador.setLpaOnline(Boolean.parseBoolean(varLpaOnline));
            }
            if (configAssinador.isLpaOnline()) {
                repoConfig.setOnlineLPA(true);
            }
            logger.info("LPA_Online: " + configAssinador.isLpaOnline());
            String varDebugON = props.getProperty("user.debug.on");
            if (varDebugON != null && !varDebugON.isEmpty() && varDebugON.length() > 1) {
                configAssinador.setDebugOn(Boolean.parseBoolean(varDebugON));
                logger.info("Modo Debug: " + configAssinador.isDebugOn());
            }
            if ((varTamanhoPDF = props.getProperty("user.pdf.size")) != null && !varTamanhoPDF.isEmpty()) {
                configAssinador.setSizePDF(Integer.valueOf(varTamanhoPDF));
                logger.info("Tamanho m\u00e1ximo de PDF definido em: " + configAssinador.getSizePDF());
            }
            if ((varLCROff = props.getProperty("user.lcr.off")) != null && !varLCROff.isEmpty() && varLCROff.length() > 1) {
                configAssinador.setLcrOff(Boolean.parseBoolean(varLCROff));
                logger.info("A valida\u00e7\u00e3o de LCR est\u00e1 desligada?: " + configAssinador.isLcrOff());
            }
            if ((varNTPLocal = props.getProperty("user.ntp.local")) != null && !varNTPLocal.isEmpty() && varNTPLocal.length() > 1) {
                configAssinador.setNtpServerLocal(varNTPLocal);
                logger.info("NTP Server Local configurado: " + configAssinador.getNtpServerLocal());
            }
            if (!StringUtil.isBlank(varIsApiSERPRO = props.getProperty("user.api.serpro")) && varIsApiSERPRO.equalsIgnoreCase("true")) {
                boolean isApiSERPRO = Boolean.parseBoolean(varIsApiSERPRO);
                String SerproCredentials = ReadConfig.getApiSerproCredentials();
                TimeStampConfig.getInstance().setApiSERPRO(isApiSERPRO);
                if (isApiSERPRO && !StringUtil.isBlank(SerproCredentials) && SerproCredentials.length() > 1) {
                    TimeStampConfig.getInstance().setApiSERPRO(true);
                    ReadConfig.configureApiSERPRO(SerproCredentials);
                } else {
                    props.setProperty("user.api.serpro", "false");
                    TimeStampConfig.getInstance().setApiSERPRO(false);
                }
            }
            logger.info("Usando a API de Carimbo do Tempo do SERPRO?: " + TimeStampConfig.getInstance().isApiSERPRO());
            ConfigProperties.saveProps(props);
        }
        catch (FileNotFoundException e) {
            logger.info("Arquivo n\u00e3o encontrado: \n" + e.getMessage());
            ReadConfig.createProps();
        }
        catch (IOException e) {
            logger.info("Erro de leitura do arquivo de propriedades: \n" + e.getMessage());
            ReadConfig.createProps();
        }
        catch (ParseException e) {
            logger.info("Erro de parser da data de expira\u00e7\u00e3o do certificado \n" + e.getMessage());
        }
    }

    public static void configureProxy() {
        String tipoProxy = props.getProperty("user.proxy.type");
        if (tipoProxy == null || tipoProxy.trim().isEmpty() || "none".equalsIgnoreCase(tipoProxy)) {
            configAssinador.setProxyEndereco(null);
            configAssinador.setProxyPorta(null);
            configAssinador.setProxyUsuario(null);
            configAssinador.setProxySenha(null);
            return;
        }
        String host = props.getProperty("user.proxy.host", "");
        String port = props.getProperty("user.proxy.port", "");
        String usuario = props.getProperty("user.proxy.user", "");
        String senhaCodificada = props.getProperty("user.proxy.password");
        char[] senha = null;
        if (senhaCodificada != null && !senhaCodificada.isEmpty()) {
            byte[] varBytes = Base64Utils.base64Decode(senhaCodificada);
            senha = new String(varBytes, StandardCharsets.UTF_8).toCharArray();
        }
        if ("http".equals(tipoProxy)) {
            configAssinador.setProxyEndereco(host);
            configAssinador.setProxyPorta(port);
            configAssinador.setProxyUsuario(usuario);
            configAssinador.setProxySenha(senha);
            if (host != null && !host.isEmpty() && port != null && !port.isEmpty()) {
                logger.info("Configurando proxy HTTP: " + host + ":" + port);
                ReadConfig.setProxy();
            }
        } else if ("socks".equals(tipoProxy)) {
            configAssinador.setProxyEndereco(host);
            configAssinador.setProxyPorta(port);
            configAssinador.setProxyUsuario(usuario);
            configAssinador.setProxySenha(senha);
            if (host != null && !host.isEmpty() && port != null && !port.isEmpty()) {
                logger.info("Configura\u00e7\u00e3o SOCKS ativada: host=" + host + ", porta=" + port);
                ReadConfig.setSocksProxy();
            }
        }
    }

    private static void setSocksProxy() {
        try {
            String tipoProxy = props.getProperty("user.proxy.type");
            if ("socks".equals(tipoProxy) && configAssinador.getProxyEndereco() != null && !configAssinador.getProxyEndereco().isEmpty()) {
                System.setProperty("socksProxyHost", configAssinador.getProxyEndereco());
                if (configAssinador.getProxyPorta() != null && !configAssinador.getProxyPorta().isEmpty()) {
                    System.setProperty("socksProxyPort", configAssinador.getProxyPorta());
                }
                if (configAssinador.getProxyUsuario() != null && !configAssinador.getProxyUsuario().isEmpty() && configAssinador.getProxySenha() != null) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(configAssinador.getProxyUsuario(), configAssinador.getProxySenha());
                        }
                    });
                }
                logger.info("SOCKS Proxy configurado: " + configAssinador.getProxyEndereco() + ":" + configAssinador.getProxyPorta());
            }
        }
        catch (Exception e) {
            logger.error("Erro ao setar configura\u00e7\u00f5es de SOCKS Proxy: " + e.getMessage());
        }
    }

    public static void clearProxyEnvVars() {
        System.clearProperty("http.proxyUser");
        System.clearProperty("http.proxyPassword");
        System.clearProperty("https.proxyUser");
        System.clearProperty("https.proxyPassword");
        System.clearProperty("signer.proxy.user");
        System.clearProperty("signer.proxy.password");
        System.clearProperty("http.proxyHost");
        System.clearProperty("https.proxyHost");
        System.clearProperty("signer.proxy.host");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyPort");
        System.clearProperty("signer.proxy.port");
    }

    private static void setProxy() {
        try {
            final String usuario = configAssinador.getProxyUsuario();
            final char[] senha = configAssinador.getProxySenha();
            logger.info("Proxy HTTP - Usu\u00e1rio: " + usuario + ", Senha: " + (senha != null ? "[PREENCHIDA]" : "[VAZIA]"));
            if (usuario != null && senha != null) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        PasswordAuthentication p = new PasswordAuthentication(usuario, senha);
                        return p;
                    }
                });
                System.setProperty("http.proxyUser", usuario);
                System.setProperty("http.proxyPassword", String.copyValueOf(senha));
                System.setProperty("https.proxyUser", usuario);
                System.setProperty("https.proxyPassword", String.copyValueOf(senha));
                System.setProperty("signer.proxy.user", usuario);
                System.setProperty("signer.proxy.password", String.copyValueOf(senha));
            }
            if (configAssinador.getProxyEndereco() != null) {
                System.setProperty("http.proxyHost", configAssinador.getProxyEndereco());
                System.setProperty("https.proxyHost", configAssinador.getProxyEndereco());
                System.setProperty("signer.proxy.host", configAssinador.getProxyEndereco());
                logger.info("Configurado Proxy na URL:" + configAssinador.getProxyEndereco());
            }
            if (configAssinador.getProxyPorta() != null) {
                System.setProperty("http.proxyPort", configAssinador.getProxyPorta());
                System.setProperty("https.proxyPort", configAssinador.getProxyPorta());
                System.setProperty("signer.proxy.port", configAssinador.getProxyPorta());
                logger.info("Configurado Proxy na Porta:" + configAssinador.getProxyPorta());
            }
        }
        catch (Exception e) {
            logger.error("Erro ao setar configura\u00e7\u00f5es de proxy: " + e.getMessage());
            logger.error("URL:" + configAssinador.getProxyEndereco() + "Porta:" + configAssinador.getProxyPorta() + "User:" + configAssinador.getProxyUsuario());
            try {
                URL url = new URL("http://www.google.com");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(3000);
                int code = conn.getResponseCode();
                if (code == 407) {
                    String proxyAuth = conn.getHeaderField("Proxy-Authenticate");
                    logger.error("Proxy-Authenticate header: " + proxyAuth);
                }
            }
            catch (Exception ex2) {
                logger.error("Erro extra ao tentar identificar tipo de autentica\u00e7\u00e3o do proxy: " + ex2.getMessage());
            }
            String msg = "Erro ao setar configura\u00e7\u00f5es de proxy! \n Verifique isso na op\u00e7\u00e3o: Configura\u00e7\u00f5es \n Ou entre em contato com a \u00e1rea t\u00e9cnica ! \n Se essa configura\u00e7\u00e3o \u00e9 necess\u00e1ria,  o aplicativo n\u00e3o poder\u00e1 gerar assinaturas!";
            SignerDialog.showMessageDialog(null, msg);
        }
    }

    private static void loadDriver(String parmDriverPath) {
        Configuration driversConfig = Configuration.getInstance();
        Iterator<Map.Entry<String, String>> it = driversConfig.getDrivers().entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        driversConfig.addDriver("DriverLocal", parmDriverPath);
        logger.info("Drivers Carregados" + driversConfig.getDrivers());
    }

    public static String getApiSerproCredentials() {
        String secret;
        String varCredentials = null;
        String varConsumerKey = props.getProperty("user.timestamp.api.consumerKey");
        if (!StringUtil.isBlank(varConsumerKey) && varConsumerKey.length() > 1 && !StringUtil.isBlank(secret = ConfiguracoesVolateis.getConsumerSecret()) && secret.length() > 1) {
            varCredentials = varConsumerKey + ":" + secret;
            try {
                String encodedString;
                byte[] inputBytes = varCredentials.getBytes("UTF-8");
                varCredentials = encodedString = Base64Utils.base64Encode(inputBytes);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Erro ao codificar credenciais: " + e.getMessage());
            }
        }
        return varCredentials;
    }

    private static void configureApiSERPRO(String varCredentials) {
        TimeStampConfig.getInstance().setClientCredentials(varCredentials);
        logger.info("Configurada credencial da API Carimbo do Tempo SERPRO ");
    }

    private static void createProps() {
        try {
            FileOutputStream output = new FileOutputStream(SerproSignerConfigurations.getFullPathFolderAssinador().toString());
            props = new Properties();
            props.store(output, "Configura\u00e7\u00f5es do usu\u00e1rio");
            ((OutputStream)output).close();
            logger.info("Criado Arquivo de configura\u00e7\u00f5es");
        }
        catch (Exception e) {
            logger.warn("Erro ao criar arquivo de configura\u00e7\u00f5es: " + e.getMessage());
        }
    }

    public static void setProps(Properties p) {
        props = p;
    }
}

