/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewVersion
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NewVersion.class);

    public NewVersion(String newVersion, String oldVersion) {
        this.setDefaultCloseOperation(2);
        this.setTitle("Assinador Serpro Desatualizado");
        this.setSize(501, 504);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        JPanel pane = (JPanel)this.getContentPane();
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        this.setBackground(Color.WHITE);
        pane.setBackground(Color.WHITE);
        JLabel title = new JLabel("<html><span style='font-size:14px; font-weight:bold;'>A vers\u00e3o atual do Assinador Serpro \u00e9 a <br> " + newVersion + "</span></html>");
        title.setHorizontalAlignment(0);
        try {
            BufferedImage imgLogoSigner = null;
            InputStream path = this.getClass().getClassLoader().getResourceAsStream("images/newVersion.png");
            imgLogoSigner = ImageIO.read(path);
            ImageIcon icon = new ImageIcon(imgLogoSigner);
            final JLabel lblImg = new JLabel(icon);
            lblImg.setHorizontalAlignment(0);
            lblImg.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    lblImg.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    lblImg.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    NetUtil.openLink("http://www.serpro.gov.br/assinador-digital");
                }
            });
            JLabel txtpnVocTemXx = new JLabel();
            txtpnVocTemXx.setText("<html><span style='font-size:12px; color:red;'>Est\u00e1 usando a vers\u00e3o: " + oldVersion + " que pode estar sujeita a erros j\u00e1 corrigidos!</span></html>");
            JLabel txtpnParaSaberComo = new JLabel();
            txtpnParaSaberComo.setText("<html><span style='font-size:11px;'>Para baixar a nova vers\u00e3o clique no link abaixo:</span></html>");
            final JLabel txtpnLink = new JLabel();
            txtpnLink.setText("<html><span style='font-size:11px; color:blue;'>http://www.serpro.gov.br/assinador-digital</span></html>");
            txtpnLink.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    txtpnLink.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    txtpnLink.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    NetUtil.openLink("http://www.serpro.gov.br/assinador-digital");
                }
            });
            final JButton btnFechar = new JButton();
            btnFechar.setIcon(new ImageIcon(this.getClass().getResource("/images/btnFechar.png")));
            btnFechar.setToolTipText("Clique para fechar essa janela");
            btnFechar.setBorderPainted(false);
            btnFechar.setContentAreaFilled(false);
            btnFechar.setOpaque(false);
            btnFechar.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    btnFechar.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    btnFechar.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    NewVersion.this.dispose();
                }
            });
            final JButton btnNoMostrarEssa = new JButton("N\u00e3o mostrar essa tela novamente (por 30 dias)");
            btnNoMostrarEssa.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    btnNoMostrarEssa.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    btnNoMostrarEssa.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
                        String dataFormatada = new SimpleDateFormat("dd-MM-yyyy").format(new Date());
                        Properties props = new Properties();
                        File arqConf = new File(SerproSignerConfigurations.getFullPathFolderAssinador().toString());
                        FileInputStream is = new FileInputStream(arqConf);
                        props.load(is);
                        props.setProperty("user.new.version.noshow", dataFormatada);
                        FileOutputStream fos = new FileOutputStream(arqConf);
                        props.store(fos, "Configura\u00e7\u00f5es do usu\u00e1rio");
                        fos.close();
                        configSigner.setVersionOldNoShow(new SimpleDateFormat("dd-MM-yyyy").parse(dataFormatada));
                    }
                    catch (IOException e1) {
                        logger.error("Erro de leitura ou escrita no arquivos de configura\u00e7\u00f5es: \n" + e1.getMessage());
                    }
                    catch (ParseException e1) {
                        logger.error("Erro de parser \n" + e1.getMessage());
                    }
                    NewVersion.this.dispose();
                }
            });
            GroupLayout groupLayout = new GroupLayout(this.getContentPane());
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(title, -2, 468, -2)).addGroup(groupLayout.createSequentialGroup().addGap(58).addComponent(txtpnLink, -2, 342, -2)).addGroup(groupLayout.createSequentialGroup().addGap(48).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(txtpnVocTemXx, -2, 382, -2).addComponent(txtpnParaSaberComo, -2, 299, -2)))).addContainerGap(17, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(33).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(lblImg, -2, 419, -2).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addComponent(btnNoMostrarEssa).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 44, Short.MAX_VALUE).addComponent(btnFechar).addGap(26)))));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(30).addComponent(title, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblImg).addGap(18).addComponent(txtpnVocTemXx, -2, 63, -2).addGap(18).addComponent(txtpnParaSaberComo).addGap(18).addComponent(txtpnLink).addGap(42).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(btnFechar).addComponent(btnNoMostrarEssa, -2, 47, -2)).addContainerGap()));
            this.getContentPane().setLayout(groupLayout);
        }
        catch (IOException imgLogoSigner) {
            // empty catch block
        }
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                NewVersion.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
    }
}

