/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Security;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.demoiselle.signer.serpro.desktop.AppVersion;
import org.demoiselle.signer.serpro.desktop.LoadingScreen;
import org.demoiselle.signer.serpro.desktop.ReadConfig;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.ui.NewToolsInterface;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.utils.FileUtil;
import org.demoiselle.signer.serpro.desktop.utils.MessagesBundle;
import org.demoiselle.signer.serpro.desktop.utils.UtilInfo;
import org.demoiselle.signer.serpro.desktop.utils.WSConnection;
import org.demoiselle.signer.serpro.desktop.web.SignerServer;
import org.demoiselle.signer.serpro.desktop.web.SignerServerNew;
import org.demoiselle.signer.serpro.desktop.web.SignerServerSSL;
import org.demoiselle.signer.serpro.desktop.web.SignerServerSSLNew;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static final MessagesBundle assinadorMessagesBundle = new MessagesBundle();
    private static LoadingScreen loadingScreen = new LoadingScreen();
    private static SerproSignerConfigurations configAssinador = SerproSignerConfigurations.getInstance();
    public static final String APP_NAME = "Assinador Serpro";
    private static boolean tryAgainStart = true;
    private static boolean startMinimized = false;

    public static void main(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("-m")) continue;
            startMinimized = true;
            break;
        }
        Security.addProvider(new BouncyCastleProvider());
        UtilInfo.logSystemInfo();
        try {
            Main.ConfigEnvironment();
            ReadConfig.doConfig();
            if (configAssinador.isDebugOn()) {
                LogManager.getRootLogger().setLevel(Level.DEBUG);
            } else {
                LogManager.getRootLogger().setLevel(Level.INFO);
            }
            Main.showLoadingScreen("");
            Main.createThemeFolderIfDontExists();
            Main.loadAndSetDefaultThemeIfExists();
            boolean wasRunning = Main.verifyIsRunningNew();
            Main.startApp(wasRunning);
            SignerServerSSL.configureCertificates();
            AppVersion.verifyNewVersion(APP_NAME);
            Main.hideLoadingScreen();
        }
        catch (Exception e) {
            logger.error(assinadorMessagesBundle.getString("error.main.start", e.getMessage()));
            System.exit(0);
        }
    }

    private static void ConfigEnvironment() {
        Main.ConfigEnvironmentIfNotSet("java.net.preferIPv4Stack", "true");
        Main.ConfigEnvironmentIfNotSet("java.net.preferIPv6Addresses", "false");
        Main.ConfigEnvironmentIfNotSet("java.net.useSystemProxies", "true");
        Main.ConfigEnvironmentIfNotSet("file.encoding", "UTF-8");
        Main.ConfigEnvironmentIfNotSet("user.timezone", "GMT-3");
        Main.ConfigEnvironmentIfNotSet("java.util.Arrays.useLegacyMergeSort", "true");
        logger.info("Configura\u00e7\u00f5es de ambiente Java conclu\u00eddas.");
    }

    private static void ConfigEnvironmentIfNotSet(String property, String value) {
        if (System.getProperty(property) == null) {
            logger.info("Configurando ambiente Java: " + property + " = " + value);
            System.setProperty(property, value);
        } else {
            logger.info("Ambiente Java j\u00e1 configurado: " + property + " = " + System.getProperty(property));
        }
    }

    private static void createThemeFolderIfDontExists() {
        try {
            if (!Files.exists(SerproSignerConfigurations.FULL_PATH_FOLDER_THEME, LinkOption.NOFOLLOW_LINKS)) {
                Files.createDirectory(SerproSignerConfigurations.FULL_PATH_FOLDER_THEME, new FileAttribute[0]);
                logger.info("Diret\u00f3rio de temas criado.");
            }
        }
        catch (Exception e) {
            logger.error(assinadorMessagesBundle.getString("error.theme.dir.creation", e.getMessage()));
        }
    }

    private static void refreshExistingThemes() {
        try {
            File themeFolder = new File(SerproSignerConfigurations.FULL_PATH_FOLDER_THEME.toUri());
            for (int j = 0; j < themeFolder.listFiles().length; ++j) {
                File file = themeFolder.listFiles()[j];
                if (!Files.isDirectory(file.toPath(), new LinkOption[0])) continue;
                logger.info("Atualizando o tema {}", (Object)file.getName());
                Main.getTheme(file.getName());
            }
        }
        catch (Exception e) {
            logger.error(assinadorMessagesBundle.getString("warn.theme.get", e.getMessage()));
        }
    }

    private static void loadAndSetDefaultThemeIfExists() {
        try {
            List<String> allLines;
            String defaultTheme = null;
            if (Files.exists(SerproSignerConfigurations.FULL_PATH_DEFAULT_THEME_FILE, LinkOption.NOFOLLOW_LINKS) && !(allLines = Files.readAllLines(SerproSignerConfigurations.FULL_PATH_DEFAULT_THEME_FILE, StandardCharsets.UTF_8)).isEmpty() && !allLines.get(0).trim().isEmpty()) {
                defaultTheme = allLines.get(0).trim();
                logger.debug("Configura\u00e7\u00e3o de tema padr\u00e3o encontrada: {}", (Object)defaultTheme);
                Main.getTheme(defaultTheme, true);
                String stampContent = configAssinador.getTheme().get(defaultTheme + ".image.stamp");
                if (stampContent != null && Main.validateThemeSignature(stampContent)) {
                    configAssinador.setDefaultTheme(defaultTheme);
                }
            }
            if (!configAssinador.getTheme().isEmpty()) {
                logger.info("Configura\u00e7\u00e3o de tema padr\u00e3o definida: {}", (Object)defaultTheme);
            } else {
                logger.info("Configura\u00e7\u00e3o de tema padr\u00e3o n\u00e3o foi definida");
            }
        }
        catch (FileNotFoundException e1) {
            logger.error(assinadorMessagesBundle.getString("error.theme.filenotfound", e1.getMessage()));
        }
        catch (IOException e1) {
            logger.error(assinadorMessagesBundle.getString("error.theme.io", e1.getMessage()));
        }
        catch (Exception e) {
            logger.error(assinadorMessagesBundle.getString("error.theme.default.load.and.set", e.getMessage()));
        }
    }

    public void sendMessage() {
        WSConnection ws;
        try {
            logger.info(assinadorMessagesBundle.getString("info.wss.open"));
            ws = new WSConnection();
            String server = "127.0.0.1";
            String wsUrl = "wss://" + server + ":" + 65156 + "/signer/";
            ws.connect(ws.getOpenToolsEndpoint(), wsUrl);
        }
        catch (Exception e) {
            logger.error(assinadorMessagesBundle.getString("error.wss.conect", e.getMessage()));
        }
        try {
            logger.info(assinadorMessagesBundle.getString("info.wss.open.new"));
            ws = new WSConnection();
            String server2 = "assinador-desktop.serpro.gov.br";
            String wsUrl2 = "wss://" + server2 + ":" + 65166 + "/signer/";
            ws.connect(ws.getOpenToolsEndpoint(), wsUrl2);
        }
        catch (Exception e) {
            logger.error(assinadorMessagesBundle.getString("error.wss.conect.new", e.getMessage()));
        }
    }

    public static void showLoadingScreen(String prefix) {
        if (!(configAssinador.getTheme() == null || prefix.isEmpty() || configAssinador.getTheme().containsKey(prefix + ".load.image") || configAssinador.getTheme().containsKey(prefix + ".no_custom"))) {
            Main.getTheme(prefix);
        }
        if (loadingScreen == null) {
            loadingScreen = new LoadingScreen();
        }
        Thread trLoading = new Thread(loadingScreen);
        loadingScreen.setPrefix(prefix);
        trLoading.start();
    }

    public static void hideLoadingScreen() {
        if (loadingScreen != null) {
            loadingScreen.hideLoadingScreen();
        }
    }

    private static void verifyImages(String imageName, String home, String theme) {
        try (InputStream input = new URL("https://cliente-assinadorserpro.estaleiro.serpro.gov.br/" + theme + "/" + imageName).openStream();){
            Files.copy(input, Paths.get(home, imageName), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.warn(assinadorMessagesBundle.getString("warn.theme.get", e.getMessage()));
        }
    }

    public static void getTheme(String theme) {
        Main.getTheme(theme, false);
    }

    public static void getTheme(String paramTheme, Boolean paramIsDefault) {
        String actual;
        String home = Paths.get(SerproSignerConfigurations.getPathHomeUser(), SerproSignerConfigurations.getFolderAssinador(), "theme").toString();
        File themes = new File(home);
        if (!themes.exists()) {
            themes.mkdirs();
        }
        if (new File(actual = Paths.get(home, new String[0]).toString()).isDirectory()) {
            try {
                actual = home = Paths.get(home, paramTheme).toString();
                String url = paramTheme + "/theme.properties";
                try (InputStream input = new URL("https://cliente-assinadorserpro.estaleiro.serpro.gov.br/" + url).openStream();){
                    themes = new File(home);
                    if (!themes.exists()) {
                        themes.mkdirs();
                    }
                    Files.copy(input, Paths.get(actual, "theme.properties"), StandardCopyOption.REPLACE_EXISTING);
                    input.close();
                }
                catch (SSLHandshakeException ssle) {
                    logger.warn(assinadorMessagesBundle.getString("warn.theme.get", ssle.getMessage()));
                }
                catch (FileNotFoundException e) {
                    if (!paramIsDefault.booleanValue()) {
                        return;
                    }
                }
                catch (Exception e) {
                    logger.warn(assinadorMessagesBundle.getString("warn.theme.get", e.getMessage()));
                }
                File themeConf = new File(Paths.get(actual, "theme.properties").toString());
                Properties themeProps = new Properties();
                if (themeConf.exists()) {
                    try {
                        FileInputStream themeIS = new FileInputStream(themeConf);
                        themeProps.load(themeIS);
                        Map<String, String> hashTheme = configAssinador.getTheme();
                        if (themeProps.getProperty("load.image") != null) {
                            hashTheme.put(paramTheme + ".load.image", Paths.get(home, themeProps.getProperty("load.image")).toString());
                            Main.verifyImages(themeProps.getProperty("load.image"), home, paramTheme);
                        }
                        if (themeProps.getProperty("pin.image") != null) {
                            hashTheme.put(paramTheme + ".pin.image", Paths.get(home, themeProps.getProperty("pin.image")).toString());
                            Main.verifyImages(themeProps.getProperty("pin.image"), home, paramTheme);
                        }
                        if (themeProps.getProperty("stamp.image") != null) {
                            hashTheme.put(paramTheme + ".image.stamp", Paths.get(home, themeProps.getProperty("stamp.image")).toString());
                            Main.verifyImages(themeProps.getProperty("stamp.image"), home, paramTheme);
                            Main.verifyImages(themeProps.getProperty("stamp.image") + ".p7s", home, paramTheme);
                        }
                        if (themeProps.getProperty("stamp.image.extra") != null) {
                            hashTheme.put(paramTheme + ".image.stamp.extra", Paths.get(home, themeProps.getProperty("stamp.image.extra")).toString());
                            Main.verifyImages(themeProps.getProperty("stamp.image.extra"), home, paramTheme);
                            Main.verifyImages(themeProps.getProperty("stamp.image.extra") + ".p7s", home, paramTheme);
                        }
                        if (themeProps.getProperty("tools.image") != null) {
                            hashTheme.put(paramTheme + ".tools.image", Paths.get(home, themeProps.getProperty("tools.image")).toString());
                            Main.verifyImages(themeProps.getProperty("tools.image"), home, paramTheme);
                        }
                        themeIS.close();
                    }
                    catch (IOException e) {
                        logger.warn(assinadorMessagesBundle.getString("warn.theme.file", e.getMessage()));
                    }
                }
            }
            catch (Exception e) {
                logger.warn(assinadorMessagesBundle.getString("warn.theme.get", e.getMessage()));
                configAssinador.getTheme().put(paramTheme + ".no_custom", null);
            }
        }
    }

    public static boolean validateThemeSignature(String stampContent) {
        byte[] signature = FileUtil.readContent(stampContent + ".p7s");
        if (signature == null) {
            logger.error(assinadorMessagesBundle.getString("error.theme.signature"));
            return false;
        }
        return true;
    }

    private static void startApp(boolean showTools) {
        try {
            logger.info(assinadorMessagesBundle.getString("info.main.start"));
            Thread t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                        logger.error(assinadorMessagesBundle.getString("error.main.layout", e.getMessage()));
                    }
                }
            });
            t1.start();
            Main.verifyIsRunning();
            NewToolsInterface.getInstance().setVisible(true);
            if (startMinimized) {
                NewToolsInterface.getInstance().setState(1);
            }
        }
        catch (Exception e) {
            logger.error(assinadorMessagesBundle.getString("error.main.startApp", e.getMessage()));
            SignerDialog.showMessageDialog(null, assinadorMessagesBundle.getString("error.main.startApp.message", e.getMessage()), APP_NAME, 2);
            System.exit(1);
        }
    }

    private static boolean verifyIsRunning() {
        try {
            logger.info(assinadorMessagesBundle.getString("info.main.running", "127.0.0.1"));
            SignerServer.getInstance();
            SignerServerSSL.getInstance();
            return false;
        }
        catch (RuntimeException error) {
            if (!configAssinador.isServerMultiUser()) {
                Throwable cause = error.getCause();
                if (cause instanceof BindException) {
                    logger.warn(assinadorMessagesBundle.getString("error.main.server.up", "127.0.0.1", error.getMessage()));
                    boolean closed = Main.requestShutdownOldApplication();
                    for (int i = 0; i < 4; ++i) {
                        try {
                            Thread.sleep(500L);
                            if (!closed) continue;
                            break;
                        }
                        catch (InterruptedException e) {
                            logger.info(assinadorMessagesBundle.getString("info.main.interrupted"));
                        }
                    }
                    if (closed && tryAgainStart) {
                        logger.info(assinadorMessagesBundle.getString("info.main.server.closed", "127.0.0.1"));
                        tryAgainStart = false;
                        Main.verifyIsRunning();
                    } else {
                        logger.error(assinadorMessagesBundle.getString("error.main.server.reinit.fail", "127.0.0.1"));
                        SignerDialog.showMessageDialog(null, assinadorMessagesBundle.getString("error.main.server.reinit.fail", "127.0.0.1"), APP_NAME, 2);
                        System.exit(0);
                    }
                } else {
                    logger.error(assinadorMessagesBundle.getString("error.main.server.init.fail", "127.0.0.1"));
                    SignerDialog.showMessageDialog(null, assinadorMessagesBundle.getString("error.main.server.init.fail", "127.0.0.1"), "ERRO", 0);
                    System.exit(0);
                }
            }
            return true;
        }
    }

    private static boolean requestShutdownOldApplication() {
        String httpServerSigner = "http://127.0.0.1:65056";
        URL url = null;
        try {
            url = new URL(httpServerSigner + "/shutdown");
        }
        catch (MalformedURLException e) {
            logger.info(assinadorMessagesBundle.getString("error.main.server.malformedURLexception", "127.0.0.1", e.getMessage()));
            return false;
        }
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            connection.setConnectTimeout(4000);
            connection.setReadTimeout(4000);
            connection.connect();
        }
        catch (IOException e) {
            logger.info(assinadorMessagesBundle.getString("error.main.server.IO", "127.0.0.1", e.getMessage()));
            return false;
        }
        HttpURLConnection https = (HttpURLConnection)connection;
        try {
            logger.info(assinadorMessagesBundle.getString("info.main.server.closing", "127.0.0.1"));
            https.getContent();
        }
        catch (IOException e) {
            if (e instanceof ConnectException) {
                logger.error(assinadorMessagesBundle.getString("info.main.server.shutdown", "127.0.0.1"), (Object)e.getMessage());
                return true;
            }
            logger.error(assinadorMessagesBundle.getString("info.main.server.shutdown", "127.0.0.1"), (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean verifyIsRunningNew() {
        try {
            logger.info(assinadorMessagesBundle.getString("info.main.running", "assinador-desktop.serpro.gov.br"));
            SignerServerNew.getInstance();
            SignerServerSSLNew.getInstance();
            return false;
        }
        catch (RuntimeException error) {
            if (error.getMessage().contains("java.net.UnknownHostException") || error.getMessage().contains("org.apache.http.conn.HttpHostConnectException")) {
                String noInternetMsg = assinadorMessagesBundle.getString("warn.main.server.networkoff");
                logger.warn(noInternetMsg);
                SignerDialog.showMessageDialog(null, noInternetMsg, "AVISO", 2);
            } else if (!configAssinador.isServerMultiUser()) {
                Throwable cause = error.getCause();
                if (cause instanceof BindException) {
                    logger.warn(assinadorMessagesBundle.getString("error.main.server.up", "assinador-desktop.serpro.gov.br", error.getMessage()));
                    boolean closed = Main.requestShutdownApplicationNew();
                    for (int i = 0; i < 4; ++i) {
                        try {
                            Thread.sleep(500L);
                            if (!closed) continue;
                            break;
                        }
                        catch (InterruptedException e) {
                            logger.info(assinadorMessagesBundle.getString("info.main.interrupted"));
                        }
                    }
                    if (closed && tryAgainStart) {
                        logger.info(assinadorMessagesBundle.getString("info.main.server.closed", "assinador-desktop.serpro.gov.br"));
                        tryAgainStart = false;
                        Main.verifyIsRunningNew();
                    } else {
                        logger.error(assinadorMessagesBundle.getString("error.main.server.reinit.fail", "assinador-desktop.serpro.gov.br"));
                        logger.error("[DEBUG] Falha ao reiniciar servidor: ", error);
                        if (error.getCause() != null) {
                            logger.error("[DEBUG] Causa raiz: {}", (Object)error.getCause().toString());
                            for (StackTraceElement ste : error.getCause().getStackTrace()) {
                                logger.error("[DEBUG]    at {}", (Object)ste.toString());
                            }
                        }
                        SignerDialog.showMessageDialog(null, assinadorMessagesBundle.getString("error.main.server.reinit.fail", "assinador-desktop.serpro.gov.br"), APP_NAME, 2);
                        System.exit(0);
                    }
                } else {
                    logger.error(assinadorMessagesBundle.getString("error.main.server.init.fail", "assinador-desktop.serpro.gov.br"));
                    SignerDialog.showMessageDialog(null, assinadorMessagesBundle.getString("error.main.server.init.fail", "assinador-desktop.serpro.gov.br"), "ERRO", 0);
                    System.exit(0);
                }
            }
            return true;
        }
    }

    private static boolean requestShutdownApplicationNew() {
        String httpServerSignerNew = "http://assinador-desktop.serpro.gov.br:65066";
        URL url = null;
        try {
            url = new URL(httpServerSignerNew + "/shutdown");
        }
        catch (MalformedURLException e) {
            logger.info(assinadorMessagesBundle.getString("error.main.server.malformedURLexception", "assinador-desktop.serpro.gov.br", e.getMessage()));
            logger.error(e.getMessage());
            return false;
        }
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            connection.setConnectTimeout(4000);
            connection.setReadTimeout(4000);
            connection.connect();
        }
        catch (IOException e) {
            logger.info(assinadorMessagesBundle.getString("error.main.server.IO", "assinador-desktop.serpro.gov.br", e.getMessage()));
            return false;
        }
        HttpURLConnection https = (HttpURLConnection)connection;
        try {
            logger.info(assinadorMessagesBundle.getString("info.main.server.closing", "assinador-desktop.serpro.gov.br"));
            https.getContent();
        }
        catch (ConnectException e) {
            logger.error(assinadorMessagesBundle.getString("info.main.server.shutdown", "assinador-desktop.serpro.gov.br"), (Object)e.getMessage());
            return true;
        }
        catch (IOException e) {
            logger.error(assinadorMessagesBundle.getString("info.main.server.shutdown", "assinador-desktop.serpro.gov.br"), (Object)e.getMessage());
            return false;
        }
        return true;
    }
}

