/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.demoiselle.signer.serpro.desktop.AppVersion;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.ui.NewToolsInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingScreen
extends JDialog
implements Runnable {
    private static final long serialVersionUID = 8614083775327578203L;
    private static final Logger logger = LoggerFactory.getLogger(LoadingScreen.class);
    private ImageIcon defaultImage = null;
    private JProgressBar pbar = null;
    private String prefix;

    public LoadingScreen() {
        this.setDefaultCloseOperation(2);
        this.setType(Window.Type.UTILITY);
        this.setAutoRequestFocus(false);
        String varSO = System.getProperty("os.name");
        if (varSO.contains("indows")) {
            this.setAlwaysOnTop(false);
        } else {
            this.setAlwaysOnTop(true);
        }
        JPanel content = (JPanel)this.getContentPane();
        content.setOpaque(false);
        content.setLayout(null);
        int width = 500;
        int height = 250;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int totalScreens = ge.getScreenDevices().length;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screen.width / totalScreens / 2 - width / 2;
        int y = screen.height / 2 - height / 2;
        this.setBounds(x, y, 530, 250);
        this.setSize(530, 250);
        this.setUndecorated(true);
        this.LoadDefaultImage();
        this.pbar = new JProgressBar();
        this.pbar.setForeground(new Color(0, 51, 255));
        this.pbar.setToolTipText("Aguarde");
        this.pbar.setValue(1);
        this.pbar.setStringPainted(true);
        this.pbar.setIndeterminate(true);
        this.pbar.setCursor(new Cursor(3));
        this.pbar.setBackground(UIManager.getColor("TextField.selectionBackground"));
        this.pbar.setFont(new Font("Arial", 0, 20));
        this.pbar.setString("");
        JLabel lblVersion = new JLabel("v" + AppVersion.VERSION);
        lblVersion.setForeground(new Color(0, 51, 204));
        lblVersion.setHorizontalAlignment(2);
        lblVersion.setFont(new Font("Arial", 1, 9));
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(lblVersion, -2, 101, -2)).addGroup(groupLayout.createSequentialGroup().addGap(157).addComponent(this.pbar, -2, 308, -2))).addContainerGap(65, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap(148, Short.MAX_VALUE).addComponent(this.pbar, -2, 14, -2).addGap(65).addComponent(lblVersion).addContainerGap()));
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        this.getContentPane().setLayout(groupLayout);
        String envName = SerproSignerConfigurations.envName;
        if ("hom".equalsIgnoreCase(envName)) {
            JLabel envLabel = new JLabel("Homologa\u00e7\u00e3o");
            envLabel.setForeground(new Color(0, 51, 204));
            envLabel.setHorizontalAlignment(2);
            envLabel.setFont(new Font("Arial", 1, 9));
            envLabel.setBounds(10, 220, 87, 30);
            content.add(envLabel);
        }
        JLabel lblImg = new JLabel(this.defaultImage);
        lblImg.setBackground(UIManager.getColor("EditorPane.selectionBackground"));
        lblImg.setHorizontalAlignment(0);
        lblImg.setBounds(0, 0, 530, 250);
        content.add(lblImg);
        Color oraRed = new Color(255, 255, 255);
        content.setBorder(BorderFactory.createLineBorder(oraRed, 10));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                logger.info("fechando loadingScreen");
                LoadingScreen.this.dispose();
            }
        });
    }

    private void showLoadingScreen() throws IOException {
        this.LoadDefaultImage();
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        boolean isUniformTranslucencySupported = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
        if (isUniformTranslucencySupported) {
            this.setOpacity(0.7f);
        }
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    public void hideLoadingScreen() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoadingScreen.this.setVisible(false);
                if (SerproSignerConfigurations.getInstance().getDefaultTheme() != null && !SerproSignerConfigurations.getInstance().getDefaultTheme().isEmpty()) {
                    NewToolsInterface.getInstance().toFront();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOpacity(float opacity) {
        try {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (opacity < 0.0f || opacity > 1.0f) {
                    throw new IllegalArgumentException("The value of opacity should be in the range [0.0f .. 1.0f].");
                }
                if (opacity < 1.0f) {
                    GraphicsConfiguration gc = this.getGraphicsConfiguration();
                    GraphicsDevice gd = gc.getDevice();
                    if (gc.getDevice().getFullScreenWindow() == this) {
                        throw new IllegalComponentStateException("Setting opacity for full-screen window is not supported.");
                    }
                    if (!gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                        throw new UnsupportedOperationException("TRANSLUCENT translucency is not supported.");
                    }
                }
                super.setOpacity(opacity);
            }
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("TRANSLUCENT translucency is not supported.");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void run() {
        try {
            this.showLoadingScreen();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    private void LoadDefaultImage() {
        try {
            InputStream pathSerpro = this.getClass().getClassLoader().getResourceAsStream("images/aguarde_novo.png");
            this.defaultImage = new ImageIcon(ImageIO.read(pathSerpro));
        }
        catch (IOException e1) {
            logger.error(e1.getMessage());
        }
    }
}

