/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.utils.MessagesBundle;
import org.demoiselle.signer.serpro.desktop.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateExpiring
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CertificateExpiring.class);
    private static final MessagesBundle assinadorMessagesBundle = new MessagesBundle();

    public CertificateExpiring(Date dataVencimento, final long diasVencimento) {
        this.setDefaultCloseOperation(2);
        this.setTitle(assinadorMessagesBundle.getString("title.certificate.expiring"));
        this.setSize(400, 560);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        JPanel pane = (JPanel)this.getContentPane();
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        this.setBackground(Color.WHITE);
        pane.setBackground(Color.WHITE);
        JLabel title = new JLabel("<html><span style='font-size:16px; font-weight: bold;font color=red;'>" + assinadorMessagesBundle.getString("title.certificate.expiring") + "</span></html>");
        title.setForeground(new Color(0, 0, 128));
        title.setHorizontalAlignment(0);
        try {
            BufferedImage imgLogoSigner = null;
            InputStream path = this.getClass().getClassLoader().getResourceAsStream("images/certificacao_digital.png");
            imgLogoSigner = ImageIO.read(path);
            ImageIcon icon = new ImageIcon(imgLogoSigner);
            JLabel lblImg = new JLabel(icon);
            lblImg.setHorizontalAlignment(0);
            JTextPane txtpnOVencimentoDo = new JTextPane();
            txtpnOVencimentoDo.setForeground(new Color(0, 0, 128));
            txtpnOVencimentoDo.setText(assinadorMessagesBundle.getString("info.certificate.expiring.date"));
            JFormattedTextField frmtdtxtfldTexto = new JFormattedTextField();
            frmtdtxtfldTexto.setForeground(new Color(0, 0, 128));
            String dataFormatada = new SimpleDateFormat("dd-MM-yyyy").format(dataVencimento);
            frmtdtxtfldTexto.setText(dataFormatada);
            JTextPane txtpnVocTemXx = new JTextPane();
            txtpnVocTemXx.setForeground(new Color(0, 0, 128));
            txtpnVocTemXx.setText(assinadorMessagesBundle.getString("info.certificate.expiring.days", diasVencimento));
            JTextPane txtpnParaSaberComo = new JTextPane();
            txtpnParaSaberComo.setForeground(new Color(0, 0, 128));
            txtpnParaSaberComo.setText(assinadorMessagesBundle.getString("info.certificate.expiring.link"));
            final JLabel txtpnLink = new JLabel();
            txtpnLink.setForeground(new Color(0, 0, 128));
            txtpnLink.setText("<html><span style='font-size:9px; font color=blue;'>https://servicos.serpro.gov.br/loja/certificacao-digital</span></html>");
            txtpnLink.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    txtpnLink.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    txtpnLink.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    NetUtil.openLink("https://servicos.serpro.gov.br/loja/certificacao-digital/?source=assinador-serpro");
                }
            });
            final JButton btnFechar = new JButton("Fechar");
            btnFechar.setForeground(new Color(0, 0, 128));
            btnFechar.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    btnFechar.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    btnFechar.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    CertificateExpiring.this.dispose();
                }
            });
            final JButton btnNoMostrarEssa = new JButton(assinadorMessagesBundle.getString("button.certificate.expiring.dont.show"));
            btnNoMostrarEssa.setForeground(new Color(0, 0, 128));
            if (diasVencimento <= 5L) {
                btnNoMostrarEssa.setText(assinadorMessagesBundle.getString("button.certificate.expiring.dont.show.session"));
            }
            btnNoMostrarEssa.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    btnNoMostrarEssa.setCursor(new Cursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    btnNoMostrarEssa.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
                        String dataFormatada = new SimpleDateFormat("dd-MM-yyyy").format(new Date());
                        if (diasVencimento > 5L) {
                            Properties props = new Properties();
                            File arqConf = new File(SerproSignerConfigurations.getFullPathFolderAssinador().toString());
                            FileInputStream is = new FileInputStream(arqConf);
                            props.load(is);
                            props.setProperty("user.certificate.exp.show", dataFormatada);
                            FileOutputStream fos = new FileOutputStream(arqConf);
                            props.store(fos, assinadorMessagesBundle.getString("text.user.configuration.file"));
                            fos.close();
                        }
                        configSigner.setCertificateDateExpNoShow(new SimpleDateFormat("dd-MM-yyyy").parse(dataFormatada));
                    }
                    catch (IOException e1) {
                        logger.error(assinadorMessagesBundle.getString("error.propertie.file.io", e1.getMessage()));
                    }
                    catch (ParseException e1) {
                        logger.error(assinadorMessagesBundle.getString("error.parse.date", e1.getMessage()));
                    }
                    CertificateExpiring.this.dispose();
                }
            });
            GroupLayout groupLayout = new GroupLayout(this.getContentPane());
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(txtpnLink).addContainerGap(-1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(103).addComponent(frmtdtxtfldTexto, -2, -1, -2).addContainerGap(219, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(btnNoMostrarEssa).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(btnFechar).addGap(62)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(title, -1, 388, Short.MAX_VALUE).addGap(37)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(37).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(txtpnParaSaberComo, -2, 299, -2).addComponent(txtpnVocTemXx, -2, -1, -2).addComponent(txtpnOVencimentoDo, -2, -1, -2).addComponent(lblImg)).addContainerGap(101, Short.MAX_VALUE)));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(30).addComponent(title).addGap(30).addComponent(lblImg).addGap(27).addComponent(txtpnOVencimentoDo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(frmtdtxtfldTexto, -2, -1, -2).addGap(5).addComponent(txtpnVocTemXx, -2, -1, -2).addGap(18).addComponent(txtpnParaSaberComo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(txtpnLink).addGap(20).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(btnFechar).addComponent(btnNoMostrarEssa)).addContainerGap()));
            this.getContentPane().setLayout(groupLayout);
        }
        catch (IOException imgLogoSigner) {
            // empty catch block
        }
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CertificateExpiring.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_KEY");
        this.getRootPane().getActionMap().put("ESCAPE_KEY", escapeAction);
    }
}

