/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.demoiselle.signer.serpro.desktop.NewVersion;
import org.demoiselle.signer.serpro.desktop.SerproSignerConfigurations;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.commons.SignerDialog;
import org.demoiselle.signer.serpro.desktop.utils.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppVersion {
    private static final Logger logger = LoggerFactory.getLogger(AppVersion.class);
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("agent-desktop");
    private static final String URL_VERSION_CHECKER = resourceBundle.getString("urlVersionChecker");
    public static final String VERSION = resourceBundle.getString("version");
    private static final MessagesBundle assinadorMessagesBundle = new MessagesBundle();
    private static String newVersion = "";

    private AppVersion() {
    }

    public static boolean hasNewVersion(String stringURL, String currentVersion) {
        URLConnection connection;
        URL url;
        Statistics instStatic = new Statistics();
        instStatic.setVersion(VERSION);
        try {
            AppVersion.disableSSLVerification();
            url = new URL(stringURL);
        }
        catch (Exception e) {
            logger.error(assinadorMessagesBundle.getString("error.appversion.url", e.getMessage()));
            return false;
        }
        try {
            connection = url.openConnection();
            connection.setConnectTimeout(5000);
            connection.connect();
        }
        catch (IOException e) {
            logger.error(assinadorMessagesBundle.getString("error.appversion.connection.io", e.getMessage()));
            return false;
        }
        HttpsURLConnection https = (HttpsURLConnection)connection;
        String content = null;
        logger.info(assinadorMessagesBundle.getString("info.appversion.verifing"));
        try (InputStream isContent = (InputStream)https.getContent();){
            content = IOUtils.toString(isContent, StandardCharsets.UTF_8);
            content = content.trim();
            logger.info(assinadorMessagesBundle.getString("info.appversion.link", content));
        }
        catch (IOException e) {
            logger.error(assinadorMessagesBundle.getString("error.appversion.link.io", e.getMessage()));
            return false;
        }
        boolean hasNewVersion = false;
        if (content != null) {
            Pattern p = Pattern.compile("\\D");
            String numericOnLineVersion = p.matcher(content).replaceAll("");
            String numericAppVersion = p.matcher(currentVersion).replaceAll("");
            Integer integerONLineVersion = Integer.valueOf(numericOnLineVersion);
            Integer integerAppVersion = Integer.valueOf(numericAppVersion);
            if (integerONLineVersion > integerAppVersion) {
                hasNewVersion = true;
                newVersion = content;
            }
            if (integerONLineVersion.compareTo(integerAppVersion) == 0 && currentVersion.contains("SNAPSHOT")) {
                hasNewVersion = true;
                newVersion = content;
            }
        }
        if (hasNewVersion) {
            logger.info(assinadorMessagesBundle.getString("info.appversion.need.update"));
        } else {
            logger.info(assinadorMessagesBundle.getString("info.appversion.is.updated"));
        }
        return hasNewVersion;
    }

    public static void verifyNewVersion(String appName) {
        logger.info(assinadorMessagesBundle.getString("info.appversion.name", appName));
        logger.info(assinadorMessagesBundle.getString("info.appversion.current", VERSION));
        logger.info(assinadorMessagesBundle.getString("info.appversion.from.url", URL_VERSION_CHECKER));
        try {
            if (AppVersion.hasNewVersion(URL_VERSION_CHECKER, VERSION)) {
                SerproSignerConfigurations configSigner = SerproSignerConfigurations.getInstance();
                Date versionOldNoShow = configSigner.getVersionOldNoShow();
                boolean showMessage = true;
                if (versionOldNoShow != null) {
                    showMessage = false;
                }
                if (showMessage) {
                    new NewVersion(newVersion, VERSION).setVisible(true);
                }
            }
        }
        catch (Exception error) {
            JLabel label = new JLabel(assinadorMessagesBundle.getString("label.appversion.unable.verify"));
            label.setFont(new Font("Arial", 0, 14));
            UIManager.put("OptionPane.background", Color.WHITE);
            UIManager.put("Panel.background", Color.WHITE);
            SignerDialog.showMessageDialog(null, label, appName, 2);
            System.exit(1);
        }
    }

    public static void disableSSLVerification() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }
}

