/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.xades.xml.impl;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.Init;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.core.CertificateManager;
import org.demoiselle.signer.core.ca.manager.CAManager;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.core.validator.PeriodValidator;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.engine.xml.icpb.XMLPolicyValidator;
import org.demoiselle.signer.policy.impl.xades.XMLPoliciesOID;
import org.demoiselle.signer.policy.impl.xades.XMLSignerException;
import org.demoiselle.signer.policy.impl.xades.util.PolicyUtils;
import org.demoiselle.signer.policy.impl.xades.xml.UnsignedAttributes;
import org.demoiselle.signer.policy.impl.xades.xml.impl.XMLSigner;
import org.demoiselle.signer.policy.impl.xades.xml.impl.XMLTimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLUnsignedAttributes
implements UnsignedAttributes {
    public static final String XMLNS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XMLNS_DS = "xmlns:ds";
    public static final String XMLNS_XADES = "xmlns:xades";
    public static final String XAdESv1_3_2 = "http://uri.etsi.org/01903/v1.3.2#";
    private static final Logger logger = LoggerFactory.getLogger(XMLSigner.class);
    private static MessagesBundle xadesMessagesBundle = new MessagesBundle();
    private PrivateKey privateKey = null;
    private byte[] docSignature = null;
    private X509Certificate certificate;
    private Certificate[] certificateChain = null;
    private Document signedDocument = null;
    private String id = "id-" + System.currentTimeMillis();
    private PolicyFactory.Policies policy = PolicyUtils.getPolicyByOid(XMLPoliciesOID.AD_RT_XADES_2_4.getOID());
    private Date notAfterSignerCertificate;

    @Override
    public Document doUnsignedAttributes(Document doc) {
        Init.init();
        if (this.policy == null) {
            logger.error(xadesMessagesBundle.getString("error.policy.not.informed"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.policy.not.informed"));
        }
        Document policyDoc = PolicyFactory.getInstance().loadXMLPolicy(this.policy);
        XMLPolicyValidator xMLPolicyValidator = new XMLPolicyValidator(policyDoc);
        if (!xMLPolicyValidator.validate()) {
            logger.error(xadesMessagesBundle.getString("error.policy.not.recognized", policyDoc.getDocumentURI()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.policy.not.recognized", policyDoc.getDocumentURI()));
        }
        if (this.certificateChain == null) {
            logger.error(xadesMessagesBundle.getString("error.certificate.null"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.certificate.null"));
        }
        if (this.getPrivateKey() == null) {
            logger.error(xadesMessagesBundle.getString("error.privatekey.null"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.privatekey.null"));
        }
        if (this.certificate == null && this.certificateChain != null && this.certificateChain.length > 0) {
            this.certificate = (X509Certificate)this.certificateChain[0];
        }
        this.certificateChain = CAManager.getInstance().getCertificateChainArray(this.certificate);
        if (this.certificateChain.length < 3) {
            logger.error(xadesMessagesBundle.getString("error.no.ca", this.certificate.getIssuerDN()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.no.ca", this.certificate.getIssuerDN()));
        }
        try {
            new CertificateManager(this.certificate);
        }
        catch (CertificateValidatorCRLException cvre) {
            logger.warn(cvre.getMessage());
            ConfigurationRepo config = ConfigurationRepo.getInstance();
            config.setOnline(true);
            try {
                new CertificateManager(this.certificate);
            }
            catch (CertificateValidatorCRLException cvre1) {
                logger.error(cvre1.getMessage());
                throw new CertificateValidatorCRLException(cvre1.getMessage());
            }
        }
        PeriodValidator pV = new PeriodValidator();
        this.setNotAfterSignerCertificate(pV.valDate(this.certificate));
        int numSignatures = doc.getElementsByTagName("ds:Signature").getLength() - 1;
        Element sigTag = (Element)doc.getElementsByTagName("ds:Signature").item(numSignatures);
        Element signatureValueTag = (Element)sigTag.getElementsByTagName("ds:SignatureValue").item(0);
        byte[] sigValue = Base64.decode(signatureValueTag.getTextContent());
        this.docSignature = sigValue;
        List<String> listMandetedUnsignedProperties = xMLPolicyValidator.getXmlSignaturePolicy().getXmlSignerRules().getMandatedUnsignedQProperties();
        if (listMandetedUnsignedProperties.size() > 0) {
            Element unsignedProperties = this.createUnsignedProperties(doc, listMandetedUnsignedProperties);
            doc.getElementsByTagName("xades:QualifyingProperties").item(0).appendChild(unsignedProperties);
        }
        this.signedDocument = doc;
        return this.signedDocument;
    }

    private Element createUnsignedProperties(Document doc, List<String> parmProperties) throws XMLSignerException {
        Element unsignedProperties = doc.createElementNS(XAdESv1_3_2, "xades:UnsignedProperties");
        Element unsignedSignatureProperties = doc.createElementNS(XAdESv1_3_2, "xades:UnsignedSignatureProperties");
        unsignedProperties.appendChild(unsignedSignatureProperties);
        for (String propertie : parmProperties) {
            Element unsignedSignaturePropertie = null;
            switch (propertie) {
                case "SignatureTimeStamp": {
                    unsignedSignaturePropertie = this.createSignatureTimeStampProperty(doc);
                    break;
                }
                case "CompleteCertificateRefs": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    throw new XMLSignerException(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                }
                case "CompleteRevocationRefs": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    throw new XMLSignerException(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                }
                case "SigAndRefsTimeStamp": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    throw new XMLSignerException(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                }
                case "CertificateValues": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    throw new XMLSignerException(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                }
                case "RevocationValues": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    throw new XMLSignerException(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                }
                case "ArchiveTimeStamp": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    throw new XMLSignerException(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                }
                default: {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    throw new XMLSignerException(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                }
            }
            unsignedSignatureProperties.appendChild(unsignedSignaturePropertie);
        }
        return unsignedProperties;
    }

    private Element createSignatureTimeStampProperty(Document doc) {
        Element signatureTimeStamp = doc.createElement("xades:SignatureTimeStamp");
        Element canonicalizationMethodTag = doc.createElementNS(XMLNS, "ds:CanonicalizationMethod");
        canonicalizationMethodTag.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        signatureTimeStamp.appendChild(canonicalizationMethodTag);
        Element encapsulatedTimeStamp = doc.createElement("xades:EncapsulatedTimeStamp");
        encapsulatedTimeStamp.setAttribute("Id", "TimeStamp" + this.id);
        XMLTimeStampToken varXMLTimeStampToken = new XMLTimeStampToken(this.getPrivateKey(), this.getCertificateChain(), this.docSignature, null);
        String timeStampContent = Base64.toBase64String(varXMLTimeStampToken.getTimeStampToken());
        encapsulatedTimeStamp.setTextContent(timeStampContent);
        signatureTimeStamp.appendChild(encapsulatedTimeStamp);
        return signatureTimeStamp;
    }

    public void saveSignedDocument(String fileName) throws TransformerException, FileNotFoundException {
        FileOutputStream os = new FileOutputStream(fileName);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(this.signedDocument), new StreamResult(os));
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public void setCertificateChain(Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
    }

    @Override
    public Date getNotAfterSignerCertificate() {
        return this.notAfterSignerCertificate;
    }

    @Override
    public void setNotAfterSignerCertificate(Date notAfterSignerCertificate) {
        this.notAfterSignerCertificate = notAfterSignerCertificate;
    }

    @Override
    public void setPolicyId(String policyOID) {
        this.policy = PolicyUtils.getPolicyByOid(policyOID);
    }
}

