/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.xades.xml.impl;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.demoiselle.signer.core.timestamp.TimeStampGenerator;
import org.demoiselle.signer.core.timestamp.TimeStampGeneratorSelector;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.policy.impl.xades.XMLSignerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLTimeStampToken {
    private static final Logger logger = LoggerFactory.getLogger(XMLTimeStampToken.class);
    private static final TimeStampGenerator timeStampGenerator = TimeStampGeneratorSelector.selectReference();
    private static MessagesBundle xadesMessagesBundle = new MessagesBundle();
    private PrivateKey privateKey = null;
    private Certificate[] certificates = null;
    private byte[] content = null;
    private byte[] hash = null;

    public XMLTimeStampToken(PrivateKey privateKey, Certificate[] certificates, byte[] content, byte[] hash) {
        this.privateKey = privateKey;
        this.certificates = certificates;
        this.content = content;
        this.hash = hash;
    }

    public byte[] getTimeStampToken() throws XMLSignerException {
        byte[] response = null;
        try {
            logger.debug(xadesMessagesBundle.getString("info.tsa.connecting"));
            if (timeStampGenerator == null) {
                throw new XMLSignerException(xadesMessagesBundle.getString("error.tsa.not.found"));
            }
            timeStampGenerator.initialize(this.content, this.privateKey, this.certificates, this.hash);
            response = timeStampGenerator.generateTimeStamp();
            timeStampGenerator.validateTimeStamp(this.content, response, this.hash);
        }
        catch (SecurityException ex) {
            throw new XMLSignerException(ex.getMessage());
        }
        return response;
    }
}

