/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.xades.xml.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.apache.commons.io.IOUtils;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.core.ca.manager.CAManager;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.exception.CertificateRevocationException;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.core.exception.CertificateValidatorException;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.core.validator.CRLValidator;
import org.demoiselle.signer.core.validator.PeriodValidator;
import org.demoiselle.signer.policy.engine.factory.PolicyFactory;
import org.demoiselle.signer.policy.engine.xml.icpb.XMLPolicyValidator;
import org.demoiselle.signer.policy.engine.xml.icpb.XMLSignaturePolicy;
import org.demoiselle.signer.policy.engine.xml.icpb.XMLSignerAlgConstraint;
import org.demoiselle.signer.policy.impl.xades.XMLSignatureInformations;
import org.demoiselle.signer.policy.impl.xades.XMLSignerException;
import org.demoiselle.signer.policy.impl.xades.util.DocumentUtils;
import org.demoiselle.signer.policy.impl.xades.util.PolicyUtils;
import org.demoiselle.signer.policy.impl.xades.xml.Checker;
import org.demoiselle.signer.policy.impl.xades.xml.impl.AlgorithmsValues;
import org.demoiselle.signer.timestamp.Timestamp;
import org.demoiselle.signer.timestamp.connector.TimeStampOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLChecker
implements Checker {
    private static final Logger logger = LoggerFactory.getLogger(XMLChecker.class);
    private boolean isDetached = false;
    private List<XMLSignatureInformations> signaturesInfo = new ArrayList<XMLSignatureInformations>();
    private static MessagesBundle xadesMessagesBundle = new MessagesBundle();
    public static final String XAdESv1_3_2 = "http://uri.etsi.org/01903/v1.3.2#";
    private Timestamp varTimestampToSignature = null;
    private LinkedList<String> validationErrors = new LinkedList();
    private LinkedList<String> validationWaring = new LinkedList();

    @Override
    public boolean check(boolean isFileLocation, String xmlSignedFile) throws XMLSignerException, NoSuchProviderException {
        if (!isFileLocation) {
            logger.error(xadesMessagesBundle.getString("error.xml.false.to.file"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.false.to.file"));
        }
        if (xmlSignedFile == null || xmlSignedFile.isEmpty()) {
            logger.error(xadesMessagesBundle.getString("error.xml.file.null", "xmlSignedFile"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.file.null", "xmlSignedFile"));
        }
        if (!xmlSignedFile.substring(xmlSignedFile.lastIndexOf(".") + 1).equalsIgnoreCase("xml")) {
            logger.error(xadesMessagesBundle.getString("error.xml.not.valid.file"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.not.valid.file"));
        }
        Document doc = DocumentUtils.loadXMLDocument(xmlSignedFile);
        return this.verify(doc);
    }

    @Override
    public boolean check(byte[] docData) throws XMLSignerException, NoSuchProviderException {
        if (docData == null || docData.length <= 0) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] docData"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] docData"));
        }
        Document doc = DocumentUtils.loadXMLDocument(docData);
        return this.verify(doc);
    }

    @Override
    public boolean check(Document doc) throws XMLSignerException, NoSuchProviderException {
        if (doc == null || doc.getChildNodes().getLength() <= 0) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "Document doc"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "Document doc"));
        }
        return this.verify(doc);
    }

    @Override
    public boolean check(String signedContentFileName, String signatureFileName) throws XMLSignerException, NoSuchProviderException {
        if (signedContentFileName == null || signedContentFileName.isEmpty()) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "String signedContentFileName"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "String signedContentFileName"));
        }
        if (signatureFileName == null || signatureFileName.isEmpty()) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "String signatureFileName"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "String signatureFileName"));
        }
        if (!signatureFileName.substring(signatureFileName.lastIndexOf(".") + 1).equalsIgnoreCase("xml")) {
            logger.error(xadesMessagesBundle.getString("error.xml.not.valid.file"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.not.valid.file"));
        }
        return this.check(DocumentUtils.readContent(signedContentFileName), DocumentUtils.loadXMLDocument(signatureFileName));
    }

    @Override
    public boolean check(byte[] signedContent, byte[] signature) throws XMLSignerException, NoSuchProviderException {
        if (signedContent == null || signedContent.length <= 0) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] signedContent"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] signedContent"));
        }
        if (signature == null || signature.length <= 0) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] signature"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] signature"));
        }
        return this.check(signedContent, DocumentUtils.loadXMLDocument(signature));
    }

    @Override
    public boolean check(InputStream isXMLFile) throws XMLSignerException, NoSuchProviderException {
        if (isXMLFile == null) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isXMLFile"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isXMLFile"));
        }
        return this.check(DocumentUtils.loadXMLDocument(isXMLFile));
    }

    @Override
    public boolean check(InputStream isContent, InputStream isXMLSignature) throws XMLSignerException, NoSuchProviderException {
        if (isContent == null) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isContent"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isContent"));
        }
        if (isXMLSignature == null) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isXMLSignature"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isXMLSignature"));
        }
        try {
            return this.check(IOUtils.toByteArray(isContent), DocumentUtils.loadXMLDocument(isXMLSignature));
        }
        catch (IOException e) {
            logger.error(xadesMessagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.io", e.getMessage()));
        }
    }

    @Override
    public boolean checkHash(byte[] contentHash, String xmlSignature) throws XMLSignerException, NoSuchProviderException {
        if (contentHash == null || contentHash.length <= 0) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] contentHash"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] contentHash"));
        }
        if (xmlSignature == null || xmlSignature.isEmpty()) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "String xmlSignature"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "String xmlSignature"));
        }
        return this.checkHash(contentHash, DocumentUtils.loadXMLDocument(xmlSignature));
    }

    @Override
    public boolean checkHash(InputStream isContent, Document xmlSignature) throws XMLSignerException, NoSuchProviderException {
        if (isContent == null) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isContent"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isContent"));
        }
        if (xmlSignature == null) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "Document xmlSignature"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "Document xmlSignature"));
        }
        try {
            return this.checkHash(IOUtils.toByteArray(isContent), xmlSignature);
        }
        catch (IOException e) {
            logger.error(xadesMessagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.io", e.getMessage()));
        }
    }

    @Override
    public boolean checkHash(InputStream isContent, InputStream isXMLSignature) throws XMLSignerException, NoSuchProviderException {
        if (isContent == null) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isContent"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isContent"));
        }
        if (isXMLSignature == null) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isXMLSignature"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isXMLSignature"));
        }
        try {
            return this.checkHash(IOUtils.toByteArray(isContent), DocumentUtils.loadXMLDocument(isXMLSignature));
        }
        catch (IOException e) {
            logger.error(xadesMessagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.io", e.getMessage()));
        }
    }

    @Override
    public boolean checkHash(InputStream isContent, String xmlSignature) throws XMLSignerException, NoSuchProviderException {
        if (isContent == null) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isContent"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "InputStream isContent"));
        }
        if (xmlSignature == null) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "String  xmlSignature"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "String  xmlSignature"));
        }
        try {
            return this.checkHash(IOUtils.toByteArray(isContent), DocumentUtils.loadXMLDocument(xmlSignature));
        }
        catch (IOException e) {
            logger.error(xadesMessagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.io", e.getMessage()));
        }
    }

    @Override
    public boolean checkHash(byte[] docHash, byte[] signature) throws NoSuchProviderException, XMLSignerException {
        if (docHash == null || docHash.length <= 0) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] docHash"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] docHash"));
        }
        if (signature == null || signature.length <= 0) {
            logger.error(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] signature"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parameter.null", "byte[] signature"));
        }
        return this.checkHash(docHash, DocumentUtils.loadXMLDocument(signature));
    }

    @Override
    public boolean check(String xmlAsString) throws NoSuchProviderException {
        if (xmlAsString == null || xmlAsString.isEmpty()) {
            logger.error(xadesMessagesBundle.getString("error.xml.string.file.null", "String xmlAsString"));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.file.null", "String xmlAsString"));
        }
        Document doc = DocumentUtils.loadXMLDocumentFromString(xmlAsString);
        return this.verify(doc);
    }

    private boolean check(byte[] docData, Document signature) throws NoSuchProviderException {
        this.isDetached = true;
        boolean signatureOk = true;
        this.verify(signature);
        try {
            Element signatureInfoTag = this.getSignatureElement("SignedInfo", (Element)signature.getChildNodes().item(0), true);
            NodeList references = signatureInfoTag.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
            for (int i = 0; i < references.getLength(); ++i) {
                if (!((Element)references.item(i)).getAttribute("Type").isEmpty()) continue;
                Element digestMethod = this.getSignatureElement("DigestMethod", (Element)references.item(i), true);
                Element digestValue = this.getSignatureElement("DigestValue", (Element)references.item(i), true);
                String strAlg = AlgorithmsValues.getDigestOnSignature(digestMethod.getAttribute("Algorithm"));
                String value = digestValue.getTextContent();
                if (!strAlg.isEmpty()) {
                    MessageDigest messageDigest = MessageDigest.getInstance(strAlg);
                    String hashValue = Base64.toBase64String(messageDigest.digest(docData));
                    if (value.equals(hashValue)) continue;
                    this.validationErrors.add(xadesMessagesBundle.getString("error.xml.hash.invalid"));
                    logger.error(xadesMessagesBundle.getString("error.xml.hash.invalid"));
                    signatureOk = false;
                    continue;
                }
                logger.error(xadesMessagesBundle.getString("error.xml. hash.not.found"));
                this.validationErrors.add(xadesMessagesBundle.getString("error.xml. hash.not.found"));
            }
        }
        catch (NoSuchAlgorithmException e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml. hash.not.found"));
            logger.error(xadesMessagesBundle.getString("error.xml. hash.not.found"));
            return false;
        }
        return signatureOk;
    }

    @Override
    public boolean checkHash(byte[] docHash, Document signature) throws NoSuchProviderException {
        this.isDetached = true;
        boolean signatureOk = true;
        this.verify(signature);
        Element signatureInfoTag = this.getSignatureElement("SignedInfo", (Element)signature.getChildNodes().item(0), true);
        NodeList references = signatureInfoTag.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
        for (int i = 0; i < references.getLength(); ++i) {
            String hashValue;
            Element digestValue;
            String value;
            if (!((Element)references.item(i)).getAttribute("Type").isEmpty() || (value = (digestValue = this.getSignatureElement("DigestValue", (Element)references.item(i), true)).getTextContent()).equals(hashValue = Base64.toBase64String(docHash))) continue;
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.hash.invalid"));
            logger.error(xadesMessagesBundle.getString("error.xml.hash.invalid"));
        }
        return signatureOk;
    }

    private Element getSignatureElement(String tagName, Element parent, boolean mandatory) {
        try {
            NodeList value = parent.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", tagName);
            if (value.getLength() == 0) {
                if (mandatory) {
                    this.validationErrors.add(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
                    logger.error(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
                } else {
                    this.validationWaring.add(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
                    logger.warn(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
                }
            }
            return (Element)value.item(0);
        }
        catch (Exception e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
            logger.error(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
            return null;
        }
    }

    private Element getXadesElement(String tagName, Element parent, boolean mandatory) {
        if (parent == null) {
            this.validationWaring.add(xadesMessagesBundle.getString("error.xml.parent.element.not.found", tagName));
            logger.warn(xadesMessagesBundle.getString("error.xml.parent.element.not.found", tagName));
            return null;
        }
        if (tagName == null) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.invalid.name", parent.getTagName()));
            logger.error(xadesMessagesBundle.getString("error.xml.invalid.name", parent.getTagName()));
            return null;
        }
        NodeList value = parent.getElementsByTagNameNS(XAdESv1_3_2, tagName);
        if (value.getLength() == 0) {
            if (mandatory) {
                this.validationErrors.add(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
                logger.error(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
            } else {
                this.validationWaring.add(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
                logger.warn(xadesMessagesBundle.getString("error.xml.element.not.found", tagName));
            }
            return null;
        }
        return (Element)value.item(0);
    }

    private String getAttribute(Element node, String attr, boolean mandatory) {
        String attribute = node.getAttribute(attr);
        if (attr.isEmpty()) {
            if (mandatory) {
                this.validationErrors.add(xadesMessagesBundle.getString("error.xml.element.not.found", attr));
                logger.error(xadesMessagesBundle.getString("error.xml.element.not.found", attr));
            } else {
                this.validationWaring.add(xadesMessagesBundle.getString("error.xml.element.not.found", attr));
                logger.warn(xadesMessagesBundle.getString("error.xml.element.not.found", attr));
            }
        }
        return attribute;
    }

    private boolean verifyDigest(Element signatureTag, String digestMethod, String digestValue, String canonicalString) {
        block6: {
            Init.init();
            Element objectTag = (Element)signatureTag.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Object").item(0);
            byte[] canonicalized = null;
            try {
                Canonicalizer c14n = Canonicalizer.getInstance(canonicalString);
                canonicalized = c14n.canonicalizeSubtree(objectTag.getElementsByTagName("xades:SignedProperties").item(0));
            }
            catch (CanonicalizationException | InvalidCanonicalizerException e1) {
                this.validationErrors.add(xadesMessagesBundle.getString("error.xml.hash.data.invalid", digestMethod));
                logger.error(xadesMessagesBundle.getString("error.xml.hash.data.invalid", digestMethod));
                return false;
            }
            MessageDigest md = null;
            try {
                String algorithm = AlgorithmsValues.getDigestOnSignature(digestMethod);
                if (algorithm != null) {
                    md = MessageDigest.getInstance(algorithm);
                    byte[] signatureDigestValue = md.digest(canonicalized);
                    if (!Base64.toBase64String(signatureDigestValue).equals(digestValue)) {
                        this.validationErrors.add(xadesMessagesBundle.getString("error.xml.hash.invalid"));
                        logger.error(xadesMessagesBundle.getString("error.xml.hash.invalid"));
                        return false;
                    }
                    break block6;
                }
                this.validationErrors.add(xadesMessagesBundle.getString("error.xml.invalid.digest.method", digestMethod));
                logger.error(xadesMessagesBundle.getString("error.xml.invalid.digest.method", digestMethod));
                return false;
            }
            catch (NoSuchAlgorithmException e) {
                this.validationErrors.add(xadesMessagesBundle.getString("error.xml.invalid.digest.method", digestMethod));
                logger.error(xadesMessagesBundle.getString("error.xml.invalid.digest.method", digestMethod));
                return false;
            }
        }
        return true;
    }

    private boolean verifyXPath(Document doc, String digestMethod, String digestValue, NodeList transformsTags) {
        String xPathTransformAlgorithm = "";
        block2: for (int i = 0; i < transformsTags.getLength(); ++i) {
            NodeList transformTag = ((Element)transformsTags.item(i)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Transform");
            for (int j = 0; j < transformTag.getLength(); ++j) {
                if (!AlgorithmsValues.isCanonicalMethods(((Element)transformTag.item(j)).getAttribute("Algorithm"))) continue;
                xPathTransformAlgorithm = ((Element)transformTag.item(j)).getAttribute("Algorithm");
                continue block2;
            }
        }
        if (xPathTransformAlgorithm.isEmpty()) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.Invalid.Canonicalizer", digestMethod));
            logger.error(xadesMessagesBundle.getString("error.xml.Invalid.Canonicalizer", digestMethod));
        }
        try {
            Element docData = DocumentUtils.getDocumentData(doc);
            byte[] docHash = DocumentUtils.getShaCanonizedValue(AlgorithmsValues.getDigestOnSignature(digestMethod), docData, xPathTransformAlgorithm);
            if (!Base64.toBase64String(docHash).equals(digestValue)) {
                this.validationErrors.add(xadesMessagesBundle.getString("error.xml.digest.invalid"));
                logger.error(xadesMessagesBundle.getString("error.xml.digest.invalid"));
                return false;
            }
        }
        catch (Exception e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.digest.invalid"));
            logger.error(xadesMessagesBundle.getString("error.xml.digest.invalid"));
            return false;
        }
        return true;
    }

    private X509Certificate getCertificate(String x509Certificate) throws CertificateException, NoSuchProviderException {
        byte[] encodedCert = Base64.decode(x509Certificate);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(encodedCert);
        Security.addProvider(new BouncyCastleProvider());
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)certFactory.generateCertificate(inputStream);
    }

    private boolean verifyHash(Element signatureTag, Element signatureInfoTag, String signatureValue, X509Certificate cert) {
        try {
            Element canonicalizationMethodTag = (Element)signatureTag.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod").item(0);
            Element signatureMethod = (Element)signatureTag.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod").item(0);
            Init.init();
            Canonicalizer c14n = Canonicalizer.getInstance(canonicalizationMethodTag.getAttribute("Algorithm"));
            byte[] dh = c14n.canonicalizeSubtree(signatureInfoTag);
            String aos = AlgorithmsValues.getAlgorithmsOnSignature(signatureMethod.getAttribute("Algorithm"));
            Signature verify = Signature.getInstance(aos);
            verify.initVerify(cert);
            verify.update(dh);
            if (verify.verify(Base64.decode(signatureValue))) {
                return true;
            }
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.signature.invalid"));
            logger.error(xadesMessagesBundle.getString("error.xml.signature.invalid"));
        }
        catch (InvalidKeyException | CanonicalizationException | InvalidCanonicalizerException | DOMException e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.signature.invalid"));
            logger.error(xadesMessagesBundle.getString("error.xml.signature.invalid"));
        }
        catch (NoSuchAlgorithmException e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.nosuch.algorithm.exception"));
            logger.error(xadesMessagesBundle.getString("error.xml.nosuch.algorithm.exception"));
        }
        catch (SignatureException e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.signature.exception", e.getMessage()));
            logger.error(xadesMessagesBundle.getString("error.xml.signature.exception", e.getMessage()));
        }
        return false;
    }

    private void verifyCertificate(X509Certificate varCert) {
        CRLValidator cV = new CRLValidator();
        try {
            cV.validate(varCert);
        }
        catch (CertificateValidatorCRLException cvce) {
            this.validationErrors.add(cvce.getMessage());
            logger.error(cvce.getMessage());
        }
        catch (CertificateRevocationException cre) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.certificate.repealed", cre.getMessage()));
            logger.error("certificado revogado");
        }
        PeriodValidator pV = new PeriodValidator();
        try {
            pV.valDate(varCert);
        }
        catch (CertificateValidatorException cve) {
            this.validationWaring.add(cve.getMessage());
            logger.warn(cve.getMessage());
        }
    }

    private XMLSignaturePolicy verifyPolicy(Element signature, String policyOID, String signatureMethod, String signatureValue) {
        Document policyDoc;
        XMLPolicyValidator xmlPolicyValidator;
        boolean isValidAlgorithm = false;
        if (policyOID == null) {
            this.validationWaring.add(xadesMessagesBundle.getString("error.xml.policy.null"));
            logger.warn(xadesMessagesBundle.getString("error.xml.policy.null"));
        }
        if (policyOID.contains("urn:oid:")) {
            policyOID = policyOID.substring(policyOID.lastIndexOf(":") + 1, policyOID.length());
        }
        if (!(xmlPolicyValidator = new XMLPolicyValidator(policyDoc = PolicyFactory.getInstance().loadXMLPolicy(PolicyUtils.getPolicyByOid(policyOID)))).validate()) {
            logger.warn(xadesMessagesBundle.getString("error.policy.not.recognized", policyOID));
            this.validationWaring.add(xadesMessagesBundle.getString("error.policy.not.recognized", policyOID));
        }
        List<XMLSignerAlgConstraint> listSignerAlgConstraint = xmlPolicyValidator.getXmlSignaturePolicy().getXmlSignerAlgConstraintList();
        for (XMLSignerAlgConstraint xmlSignerAlgConstraint : listSignerAlgConstraint) {
            if (!xmlSignerAlgConstraint.getAlgId().equals(signatureMethod)) continue;
            if (xmlSignerAlgConstraint.getMinKeyLength() == null) break;
            if (8 * Base64.decode(signatureValue).length >= Integer.parseInt(xmlSignerAlgConstraint.getMinKeyLength())) {
                isValidAlgorithm = true;
                break;
            }
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.size.not.allowed"));
            logger.error(xadesMessagesBundle.getString("error.xml.size.not.allowed"));
            break;
        }
        if (!isValidAlgorithm) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.invalid.algorithm", policyOID));
            logger.error(xadesMessagesBundle.getString("error.xml.invalid.algorithm", policyOID));
        }
        return xmlPolicyValidator.getXmlSignaturePolicy();
    }

    private void verifySignature(Element signature, X509Certificate cert) {
        try {
            Init.init();
            Element canonicalizationMethodTag = this.getSignatureElement("CanonicalizationMethod", signature, true);
            Element signatureMethodTag = this.getSignatureElement("SignatureMethod", signature, true);
            Element signatureValueTag = this.getSignatureElement("SignatureValue", signature, true);
            String canonicalizationMethod = this.getAttribute(canonicalizationMethodTag, "Algorithm", true);
            String signatureMethod = AlgorithmsValues.getAlgorithmsOnSignature(this.getAttribute(signatureMethodTag, "Algorithm", true));
            Canonicalizer c14n = Canonicalizer.getInstance(canonicalizationMethod);
            byte[] dh = c14n.canonicalizeSubtree(signature.getElementsByTagName("ds:SignedInfo").item(0));
            byte[] sigValue = Base64.decode(signatureValueTag.getTextContent());
            if (!AlgorithmsValues.isCanonicalMethods(canonicalizationMethod)) {
                this.validationErrors.add(xadesMessagesBundle.getString("error.xml.canonicalizer.not.allowed"));
                logger.error(xadesMessagesBundle.getString("error.xml.canonicalizer.not.allowed"));
            }
            Signature sig = Signature.getInstance(signatureMethod);
            sig.initVerify(cert);
            sig.update(dh);
            if (!sig.verify(sigValue)) {
                this.validationErrors.add(xadesMessagesBundle.getString("error.xml.signature.hash"));
                logger.error(xadesMessagesBundle.getString("error.xml.signature.hash"));
            }
        }
        catch (InvalidCanonicalizerException e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.Invalid.canonicalizer", e.getMessage()));
            logger.error(xadesMessagesBundle.getString("error.xml.Invalid.canonicalizer", e.getMessage()));
        }
        catch (CanonicalizationException e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.Invalid.canonicalizer", e.getMessage()));
            logger.error(xadesMessagesBundle.getString("error.xml.Invalid.canonicalizer", e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.nosuch.algorithm.exception"));
            logger.error(xadesMessagesBundle.getString("error.xml.nosuch.algorithm.exception"));
        }
        catch (InvalidKeyException e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.invalid.key.exception"));
            logger.error(xadesMessagesBundle.getString("error.xml.invalid.key.exception"));
        }
        catch (SignatureException e) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.signature.exception", e.getMessage()));
            logger.error(xadesMessagesBundle.getString("error.xml.signature.exception", e.getMessage()));
        }
    }

    private boolean verify(Document doc) throws NoSuchProviderException {
        Init.init();
        boolean signatureOK = false;
        NodeList root = doc.getChildNodes();
        NodeList signatureListTags = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (root.item(0) == signatureListTags.item(0) && !this.isDetached) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.detached.content"));
            logger.error(xadesMessagesBundle.getString("error.xml.detached.content"));
            XMLSignatureInformations sigInf = new XMLSignatureInformations();
            sigInf.setValidatorErrors(this.validationErrors);
            this.signaturesInfo.add(sigInf);
            return signatureOK;
        }
        int sizeSigList = signatureListTags.getLength();
        if (sizeSigList < 1) {
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.signature.not.found"));
            logger.error(xadesMessagesBundle.getString("error.xml.signature.not.found"));
            XMLSignatureInformations sigInf = new XMLSignatureInformations();
            sigInf.setValidatorErrors(this.validationErrors);
            this.signaturesInfo.add(sigInf);
            return signatureOK;
        }
        for (int i = 0; i < sizeSigList; ++i) {
            Element objectTag;
            XMLSignatureInformations sigInf = new XMLSignatureInformations();
            Element sigPolicyId = null;
            Element signatureTag = (Element)signatureListTags.item(i);
            Element keyInfoTag = this.getSignatureElement("KeyInfo", signatureTag, true);
            Element X509DataTag = this.getSignatureElement("X509Data", keyInfoTag, true);
            Element X509CertificateTag = this.getSignatureElement("X509Certificate", X509DataTag, true);
            String x509Certificate = X509CertificateTag.getTextContent();
            X509Certificate cert = null;
            try {
                cert = this.getCertificate(x509Certificate);
            }
            catch (CertificateException e) {
                signatureOK = false;
                this.validationErrors.add(xadesMessagesBundle.getString("error.invalid.certificate"));
            }
            if (cert != null) {
                this.verifyCertificate(cert);
                try {
                    LinkedList varChain = (LinkedList)CAManager.getInstance().getCertificateChain(cert);
                    sigInf.setChain(varChain);
                }
                catch (Exception e) {
                    this.validationErrors.add(e.getMessage());
                }
                sigInf.setIcpBrasilcertificate(new BasicCertificate(cert));
                sigInf.setNotAfter(cert.getNotAfter());
            }
            if ((objectTag = this.getSignatureElement("Object", signatureTag, false)) != null) {
                Element signedDataObjectPropertiesTag;
                Element certTag;
                Element certDigestTag;
                Element qualifyingPropertiesTag = this.getXadesElement("QualifyingProperties", objectTag, true);
                Element signaturePolicyIdentifier = this.getXadesElement("SignaturePolicyIdentifier", qualifyingPropertiesTag, false);
                sigPolicyId = this.getXadesElement("SigPolicyId", signaturePolicyIdentifier, false);
                NodeList referenceTag = signatureTag.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference");
                for (int j = 0; j < referenceTag.getLength(); ++j) {
                    signatureOK = true;
                    Element actualReferenceTag = (Element)referenceTag.item(j);
                    NodeList transformsTags = actualReferenceTag.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Transforms");
                    Element digestMethodTag = this.getSignatureElement("DigestMethod", (Element)referenceTag.item(j), true);
                    String digestMethod = this.getAttribute(digestMethodTag, "Algorithm", true);
                    Element digestValueTag = this.getSignatureElement("DigestValue", (Element)referenceTag.item(j), true);
                    String digestValue = digestValueTag.getTextContent();
                    if (actualReferenceTag.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "XPath").getLength() > 0) {
                        if (this.verifyXPath(doc, digestMethod, digestValue, transformsTags)) continue;
                        this.validationErrors.add(xadesMessagesBundle.getString("error.xml.document.fail"));
                        signatureOK = false;
                        continue;
                    }
                    if (!((Element)referenceTag.item(j)).hasAttribute("Type") || !((Element)referenceTag.item(j)).getAttribute("Type").endsWith("#SignedProperties")) continue;
                    Element transformTag = (Element)((Element)referenceTag.item(j)).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Transform").item(0);
                    String canonString = transformTag.getAttribute("Algorithm");
                    if (this.verifyDigest((Element)signatureListTags.item(i), digestMethod, digestValue, canonString)) continue;
                    this.validationErrors.add(xadesMessagesBundle.getString("error.xml.digest.invalid"));
                    signatureOK = false;
                }
                Element signedPropertiesTag = this.getXadesElement("SignedProperties", qualifyingPropertiesTag, true);
                Element signedSignaturePropertiesTag = this.getXadesElement("SignedSignatureProperties", signedPropertiesTag, true);
                Element signedTime = this.getXadesElement("SigningTime", signedSignaturePropertiesTag, true);
                if (signedTime == null) {
                    this.validationWaring.add(xadesMessagesBundle.getString("error.xml.signing.time.not.found"));
                } else {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    try {
                        sigInf.setSignDate(formatter.parse(signedTime.getTextContent()));
                    }
                    catch (ParseException | DOMException e) {
                        this.validationWaring.add(xadesMessagesBundle.getString("error.date.parser", e.getMessage()));
                    }
                }
                Element signingCertificateTag = this.getXadesElement("SigningCertificate", signedSignaturePropertiesTag, true);
                if (signingCertificateTag == null) {
                    signingCertificateTag = this.getXadesElement("SigningCertificateV2", signedSignaturePropertiesTag, true);
                }
                if (this.getSignatureElement("DigestMethod", certDigestTag = this.getXadesElement("CertDigest", certTag = this.getXadesElement("Cert", signingCertificateTag, true), true), true) == null) {
                    signatureOK = false;
                    this.validationWaring.add(xadesMessagesBundle.getString("error.xml.element.not.found.signature", "DigestMethod", "Cert"));
                }
                if (this.getSignatureElement("DigestValue", certDigestTag, true) == null) {
                    signatureOK = false;
                    this.validationWaring.add(xadesMessagesBundle.getString("error.xml.element.not.found.signature", "IssuerSerial", "Cert"));
                }
                if (this.getXadesElement("IssuerSerial", certTag, true) == null) {
                    signatureOK = false;
                    this.validationWaring.add(xadesMessagesBundle.getString("error.xml.element.not.found.signature", "DigestValue", "Cert"));
                }
                if ((signedDataObjectPropertiesTag = this.getXadesElement("SignedDataObjectProperties", signedPropertiesTag, true)) == null) {
                    signatureOK = false;
                    this.validationWaring.add(xadesMessagesBundle.getString("error.xml.element.not.found.signature", "SignedDataObjectProperties", "Cert"));
                }
                if (cert != null) {
                    this.verifySignature(signatureTag, cert);
                    Element signatureInfoTag = this.getSignatureElement("SignedInfo", signatureTag, true);
                    Element signatureValueTag = this.getSignatureElement("SignatureValue", signatureTag, true);
                    String signatureValue = signatureValueTag.getTextContent();
                    this.verifyHash(signatureTag, signatureInfoTag, signatureValue, cert);
                    if (sigPolicyId != null) {
                        String signatureMethod = "";
                        Element signatureMethodTag = this.getSignatureElement("SignatureMethod", signatureTag, true);
                        if (signatureMethodTag != null) {
                            signatureMethod = this.getAttribute(signatureMethodTag, "Algorithm", true);
                        } else {
                            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.signature.method.not.found"));
                            signatureOK = false;
                        }
                        Element sigPolicyIdIdentifier = this.getXadesElement("Identifier", sigPolicyId, true);
                        if (sigPolicyIdIdentifier != null) {
                            String strIdentifier = sigPolicyIdIdentifier.getTextContent();
                            XMLSignaturePolicy xmlSignaturePolicy = this.verifyPolicy(signatureTag, strIdentifier, signatureMethod, signatureValue);
                            sigInf.setSignaturePolicy(xmlSignaturePolicy);
                            List<String> listMandetedUnsignedProperties = xmlSignaturePolicy.getXmlSignerRules().getMandatedUnsignedQProperties();
                            if (!listMandetedUnsignedProperties.isEmpty()) {
                                this.VerifyMandatedUnsignedQProperties(listMandetedUnsignedProperties, signatureTag, signatureValue);
                                sigInf.setTimeStampSigner(this.getVarTimestampToSignature());
                                this.setVarTimestampToSignature(null);
                            }
                        } else {
                            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.policy.id.not.found"));
                            signatureOK = false;
                        }
                    }
                }
            } else {
                this.validationWaring.add(xadesMessagesBundle.getString("error.xml.policy.id.not.found"));
                signatureOK = this.verifySignatureNoICPBrasil(signatureTag, cert);
            }
            sigInf.setValidatorErrors(this.validationErrors);
            sigInf.setValidatorWarnins(this.validationWaring);
            this.signaturesInfo.add(sigInf);
        }
        return signatureOK;
    }

    private void VerifyMandatedUnsignedQProperties(List<String> listMandetedUnsignedProperties, Element signatureTag, String signatureValue) {
        Iterator<String> iterator = listMandetedUnsignedProperties.iterator();
        block18: while (iterator.hasNext()) {
            String propertie;
            switch (propertie = iterator.next()) {
                case "SignatureTimeStamp": {
                    this.checkSignatureTimeStampPropertie(signatureTag, signatureValue);
                    continue block18;
                }
                case "CompleteCertificateRefs": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    this.validationErrors.add(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    continue block18;
                }
                case "CompleteRevocationRefs": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    this.validationErrors.add(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    continue block18;
                }
                case "SigAndRefsTimeStamp": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    this.validationErrors.add(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    continue block18;
                }
                case "CertificateValues": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    this.validationErrors.add(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    continue block18;
                }
                case "RevocationValues": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    this.validationErrors.add(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    continue block18;
                }
                case "ArchiveTimeStamp": {
                    logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    this.validationErrors.add(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
                    continue block18;
                }
            }
            this.validationErrors.add(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
            logger.error(xadesMessagesBundle.getString("error.attribute.not.implemented", propertie));
        }
    }

    private void checkSignatureTimeStampPropertie(Element signatureTag, String signatureValue) {
        try {
            Security.addProvider(new BouncyCastleProvider());
            String timeStampForSignature = signatureTag.getElementsByTagName("xades:EncapsulatedTimeStamp").item(0).getTextContent();
            TimeStampOperator timeStampOperator = new TimeStampOperator();
            byte[] varTimeStamp = Base64.decode(timeStampForSignature);
            byte[] varSignature = Base64.decode(signatureValue);
            TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(varTimeStamp));
            Timestamp timeStampSigner = new Timestamp(timeStampToken);
            timeStampOperator.validate(varSignature, varTimeStamp, null);
            this.setVarTimestampToSignature(timeStampSigner);
        }
        catch (IOException | CMSException | TSPException | CertificateCoreException e) {
            this.setVarTimestampToSignature(null);
            this.validationErrors.add(xadesMessagesBundle.getString("error.xml.invalid.signature.timestamp", e.getMessage()));
        }
    }

    @Override
    public List<XMLSignatureInformations> getSignaturesInfo() {
        return this.signaturesInfo;
    }

    public Timestamp getVarTimestampToSignature() {
        return this.varTimestampToSignature;
    }

    private void setVarTimestampToSignature(Timestamp varTimestampToSignature) {
        this.varTimestampToSignature = varTimestampToSignature;
    }

    private boolean verifySignatureNoICPBrasil(Element signatureTag, X509Certificate cert) {
        PublicKey publicKey = cert.getPublicKey();
        DOMValidateContext valContext = new DOMValidateContext(publicKey, (Node)signatureTag);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        XMLSignature signature = null;
        try {
            signature = fac.unmarshalXMLSignature(valContext);
        }
        catch (MarshalException e) {
            return false;
        }
        try {
            return signature.validate(valContext);
        }
        catch (XMLSignatureException e) {
            return false;
        }
    }
}

