/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.xades.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.xml.security.Init;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.policy.impl.xades.XMLSignerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentUtils {
    private static final Logger logger = LoggerFactory.getLogger(DocumentUtils.class);
    private static MessagesBundle xadesMessagesBundle = new MessagesBundle();

    public static String getString(Document parmDocument, String parmTagName) throws XMLSignerException {
        NodeList subList;
        Init.init();
        Element rootElement = parmDocument.getDocumentElement();
        NodeList list = rootElement.getElementsByTagName(parmTagName);
        if (list != null && list.getLength() > 0 && (subList = list.item(0).getChildNodes()) != null && subList.getLength() > 0) {
            return subList.item(0).getNodeValue();
        }
        return null;
    }

    public static Document loadXMLDocument(String xmlFile) throws XMLSignerException {
        try {
            BOMInputStream inputStream = new BOMInputStream(new FileInputStream(xmlFile));
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            InputSource source = new InputSource(in);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document docRet = dbf.newDocumentBuilder().parse(source);
            docRet.setXmlStandalone(true);
            return docRet;
        }
        catch (UnsupportedEncodingException e) {
            logger.error(xadesMessagesBundle.getString("erro.unsupported.encoding.exception", "UTF-8"));
            throw new XMLSignerException(xadesMessagesBundle.getString("erro.unsupported.encoding.exception", "UTF-8"));
        }
        catch (FileNotFoundException e) {
            logger.error(xadesMessagesBundle.getString("error.file.not.found", xmlFile));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.file.not.found", xmlFile));
        }
        catch (SAXException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(xadesMessagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.io", e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
        }
    }

    public static Document loadXMLDocument(byte[] xmlContent) throws XMLSignerException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            Document retDoc = dbFactory.newDocumentBuilder().parse(new BOMInputStream(new ByteArrayInputStream(xmlContent)));
            retDoc.setXmlStandalone(true);
            return retDoc;
        }
        catch (SAXException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(xadesMessagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.io", e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
        }
    }

    public static Document loadXMLDocument(InputStream is) throws XMLSignerException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document retDoc = dbf.newDocumentBuilder().parse(new InputSource(new BOMInputStream(is)));
            retDoc.setXmlStandalone(true);
            return retDoc;
        }
        catch (SAXException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(xadesMessagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.io", e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
        }
    }

    public static Document loadXMLDocumentFromString(String xmlString) throws XMLSignerException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document retDoc = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(xmlString)));
            retDoc.setXmlStandalone(true);
            return retDoc;
        }
        catch (SAXException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(xadesMessagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.io", e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
        }
    }

    public static Element getDocumentData(Document doc) throws XMLSignerException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document bodyDoc = null;
            DocumentBuilder builder = dbf.newDocumentBuilder();
            bodyDoc = builder.newDocument();
            bodyDoc.setXmlStandalone(true);
            Node body = bodyDoc.importNode(doc.getDocumentElement(), true);
            bodyDoc.appendChild(body);
            NodeList signatures = bodyDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            int qtSig = signatures.getLength();
            for (int i = 0; i < qtSig; ++i) {
                signatures.item(0).getParentNode().removeChild(signatures.item(0));
            }
            return bodyDoc.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.parser", e.getMessage()));
        }
    }

    public static byte[] getShaCanonizedValue(String alg, Node xml, String canonical) throws XMLSignerException {
        MessageDigest messageDigest;
        Init.init();
        Canonicalizer c14n = null;
        try {
            c14n = Canonicalizer.getInstance(canonical);
        }
        catch (InvalidCanonicalizerException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.Invalid.Canonicalizer", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.Invalid.Canonicalizer", e.getMessage()));
        }
        try {
            messageDigest = MessageDigest.getInstance(alg);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(xadesMessagesBundle.getString("error.no.algorithm", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.no.algorithm", e.getMessage()));
        }
        try {
            return messageDigest.digest(c14n.canonicalizeSubtree(xml));
        }
        catch (CanonicalizationException e) {
            logger.error(xadesMessagesBundle.getString("error.xml.Invalid.Canonicalizer", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.xml.Invalid.Canonicalizer", e.getMessage()));
        }
    }

    public static byte[] readContent(String parmFile) {
        try {
            byte[] result = null;
            File file = new File(parmFile);
            FileInputStream is = new FileInputStream(parmFile);
            result = new byte[(int)file.length()];
            is.read(result);
            is.close();
            return result;
        }
        catch (IOException e) {
            logger.error(xadesMessagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(xadesMessagesBundle.getString("error.io", e.getMessage()));
        }
    }
}

