/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.pades.pkcs7.impl;

import java.io.IOException;
import java.security.Security;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.pades.pkcs7.PKCS7TimeStampSigner;
import org.demoiselle.signer.timestamp.Timestamp;
import org.demoiselle.signer.timestamp.connector.TimeStampOperator;

public class PAdESTimeStampSigner
implements PKCS7TimeStampSigner {
    @Override
    public Timestamp checkTimeStampPDFWithContent(byte[] timeStamp, byte[] content) {
        try {
            return this.checkTimeStampPDF(timeStamp, content, null);
        }
        catch (CertificateCoreException e) {
            throw new SignerException(e);
        }
    }

    @Override
    public Timestamp checkTimeStampPDFWithHash(byte[] timeStamp, byte[] hash) {
        try {
            return this.checkTimeStampPDF(timeStamp, null, hash);
        }
        catch (CertificateCoreException e) {
            throw new SignerException(e);
        }
    }

    private Timestamp checkTimeStampPDF(byte[] timeStamp, byte[] content, byte[] hash) {
        try {
            Security.addProvider(new BouncyCastleProvider());
            byte[] varTimeStamp = timeStamp;
            TimeStampOperator timeStampOperator = new TimeStampOperator();
            if (content != null) {
                timeStampOperator.validate(content, varTimeStamp, null);
            } else {
                timeStampOperator.validate(null, varTimeStamp, hash);
            }
            TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(varTimeStamp));
            Timestamp timeStampSigner = new Timestamp(timeStampToken);
            return timeStampSigner;
        }
        catch (IOException | CMSException | TSPException | CertificateCoreException e) {
            throw new SignerException(e);
        }
    }
}

