/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.impl;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.demoiselle.signer.core.timestamp.TimeStampGenerator;
import org.demoiselle.signer.core.timestamp.TimeStampGeneratorSelector;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.UnsignedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampToken
implements UnsignedAttribute {
    private static final Logger logger = LoggerFactory.getLogger(TimeStampToken.class);
    private static final TimeStampGenerator timeStampGenerator = TimeStampGeneratorSelector.selectReference();
    private static MessagesBundle cadesMessagesBundle = new MessagesBundle();
    private final ASN1ObjectIdentifier identifier = PKCSObjectIdentifiers.id_aa_signatureTimeStampToken;
    private PrivateKey privateKey = null;
    private Certificate[] certificates = null;
    byte[] content = null;
    byte[] hash = null;

    @Override
    public String getOID() {
        return this.identifier.getId();
    }

    @Override
    public void initialize(PrivateKey privateKey, Certificate[] certificates, byte[] content, SignaturePolicy signaturePolicy, byte[] hash) {
        this.privateKey = privateKey;
        this.certificates = certificates;
        this.content = content;
        this.hash = hash;
    }

    @Override
    public Attribute getValue() throws SignerException {
        try {
            logger.debug(cadesMessagesBundle.getString("info.tsa.connecting"));
            if (timeStampGenerator != null) {
                timeStampGenerator.initialize(this.content, this.privateKey, this.certificates, this.hash);
                byte[] response = timeStampGenerator.generateTimeStamp();
                timeStampGenerator.validateTimeStamp(this.content, response, this.hash);
                return new Attribute(this.identifier, new DERSet(ASN1Primitive.fromByteArray(response)));
            }
            throw new SignerException(cadesMessagesBundle.getString("error.tsa.not.found"));
        }
        catch (IOException | SecurityException ex) {
            throw new SignerException(ex.getMessage());
        }
    }
}

