/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.impl;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.CertificateList;
import org.demoiselle.signer.core.extension.ICPBR_CRL;
import org.demoiselle.signer.core.repository.CRLRepository;
import org.demoiselle.signer.core.repository.CRLRepositoryFactory;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.UnsignedAttribute;

public class RevocationValues
implements UnsignedAttribute {
    private final ASN1ObjectIdentifier identifier = PKCSObjectIdentifiers.id_aa_ets_revocationValues;
    private Certificate[] certificates = null;
    private static MessagesBundle cadesMessagesBundle = new MessagesBundle();
    private final CRLRepository crlRepository = CRLRepositoryFactory.factoryCRLRepository();

    @Override
    public void initialize(PrivateKey privateKey, Certificate[] certificates, byte[] content, SignaturePolicy signaturePolicy, byte[] hash) {
        this.certificates = certificates;
    }

    @Override
    public String getOID() {
        return this.identifier.getId();
    }

    @Override
    public Attribute getValue() throws SignerException {
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        ArrayList<CertificateList> crlVals = new ArrayList<CertificateList>();
        ArrayList ocspVals = new ArrayList();
        try {
            int chainSize = this.certificates.length - 1;
            for (int ix = 0; ix < chainSize; ++ix) {
                X509Certificate cert = (X509Certificate)this.certificates[ix];
                Collection<ICPBR_CRL> icpCrls = this.crlRepository.getX509CRL(cert);
                for (ICPBR_CRL icpCrl : icpCrls) {
                    crlList.add(icpCrl.getCRL());
                }
            }
            if (crlList.isEmpty()) {
                throw new SignerException(cadesMessagesBundle.getString("error.crl.list.empty"));
            }
            for (X509CRL varCrl : crlList) {
                crlVals.add(CertificateList.getInstance(varCrl.getEncoded()));
            }
            CertificateList[] crlValuesArray = new CertificateList[crlVals.size()];
            BasicOCSPResponse[] ocspValuesArray = new BasicOCSPResponse[ocspVals.size()];
            return new Attribute(this.identifier, new DERSet(new DERSequence(crlVals.toArray(crlValuesArray))));
        }
        catch (Exception e) {
            throw new SignerException(e.getMessage());
        }
    }
}

