/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.impl;

import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.esf.CrlIdentifier;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OtherHash;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.demoiselle.signer.core.extension.ICPBR_CRL;
import org.demoiselle.signer.core.repository.CRLRepository;
import org.demoiselle.signer.core.repository.CRLRepositoryFactory;
import org.demoiselle.signer.cryptography.Digest;
import org.demoiselle.signer.cryptography.DigestAlgorithmEnum;
import org.demoiselle.signer.cryptography.factory.DigestFactory;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.impl.cades.SignerException;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.UnsignedAttribute;

public class RevocationRefs
implements UnsignedAttribute {
    private final ASN1ObjectIdentifier identifier = PKCSObjectIdentifiers.id_aa_ets_revocationRefs;
    private Certificate[] certificates = null;
    private final CRLRepository crlRepository = CRLRepositoryFactory.factoryCRLRepository();

    @Override
    public void initialize(PrivateKey privateKey, Certificate[] certificates, byte[] content, SignaturePolicy signaturePolicy, byte[] hash) {
        this.certificates = certificates;
    }

    @Override
    public String getOID() {
        return this.identifier.getId();
    }

    @Override
    public Attribute getValue() throws SignerException {
        try {
            int chainSize = this.certificates.length - 1;
            ArrayList<CrlValidatedID> crls = new ArrayList<CrlValidatedID>();
            for (int ix = 0; ix < chainSize; ++ix) {
                Collection<ICPBR_CRL> icpCrls;
                X509Certificate cert = (X509Certificate)this.certificates[ix];
                try {
                    icpCrls = this.crlRepository.getX509CRL(cert);
                }
                catch (NoSuchProviderException e) {
                    throw new SignerException(e.getMessage());
                }
                for (ICPBR_CRL icpCrl : icpCrls) {
                    crls.add(this.makeCrlValidatedID(icpCrl.getCRL()));
                }
            }
            int crlsIdSize = crls.size();
            ASN1Encodable[] crlsForId = new CrlValidatedID[crlsIdSize];
            int i = 0;
            for (CrlValidatedID crlVID : crls) {
                crlsForId[i] = crlVID;
                ++i;
            }
            DERSequence crlValidatedIDSeq = new DERSequence(crlsForId);
            ASN1Encodable[] crlValidatedIDSeqArr = new ASN1Encodable[]{crlValidatedIDSeq};
            DERSequence crlListID = new DERSequence(crlValidatedIDSeqArr);
            DERTaggedObject crlListIDTagged = new DERTaggedObject(0, crlListID);
            ASN1Encodable[] crlListIDTaggedArr = new ASN1Encodable[]{crlListIDTagged};
            DERSequence crlOscpRef = new DERSequence(crlListIDTaggedArr);
            ASN1Encodable[] crlOscpRefArr = new ASN1Encodable[]{crlOscpRef};
            DERSequence completeRevocationRefs = new DERSequence(crlOscpRefArr);
            return new Attribute(this.identifier, new DERSet(completeRevocationRefs));
        }
        catch (CRLException e) {
            throw new SignerException(e.getMessage());
        }
    }

    private CrlValidatedID makeCrlValidatedID(X509CRL crl) throws CRLException {
        CrlIdentifier crlid;
        Digest digest = DigestFactory.getInstance().factoryDefault();
        digest.setAlgorithm(DigestAlgorithmEnum.SHA_256);
        OtherHashAlgAndValue otherHashAlgAndValue = new OtherHashAlgAndValue(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), new DEROctetString(digest.digest(crl.getEncoded())));
        OtherHash hash = new OtherHash(otherHashAlgAndValue);
        if (crl.getExtensionValue("2.5.29.20") != null) {
            ASN1Integer varASN1Integer = new ASN1Integer(crl.getExtensionValue("2.5.29.20"));
            BigInteger crlnumber = varASN1Integer.getPositiveValue();
            crlid = new CrlIdentifier(new X500Name(crl.getIssuerX500Principal().getName()), new DERUTCTime(crl.getThisUpdate()), crlnumber);
        } else {
            crlid = new CrlIdentifier(new X500Name(crl.getIssuerX500Principal().getName()), new DERUTCTime(crl.getThisUpdate()));
        }
        CrlValidatedID crlvid = new CrlValidatedID(hash, crlid);
        return crlvid;
    }
}

