/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.impl;

import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignaturePolicy;
import org.demoiselle.signer.policy.impl.cades.pkcs7.attribute.SignedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDigest
implements SignedAttribute {
    private static final Logger logger = LoggerFactory.getLogger(MessageDigest.class);
    private final ASN1ObjectIdentifier identifier = PKCSObjectIdentifiers.pkcs_9_at_messageDigest;
    private byte[] content = null;
    private SignaturePolicy signaturePolicy = null;
    private byte[] hash = null;

    @Override
    public String getOID() {
        return this.identifier.getId();
    }

    @Override
    public Attribute getValue() {
        try {
            if (this.hash == null) {
                java.security.MessageDigest md = java.security.MessageDigest.getInstance(this.signaturePolicy.getSignPolicyHashAlg().getAlgorithm().getValue());
                this.hash = md.digest(this.content);
            }
            return new Attribute(this.identifier, new DERSet(new DEROctetString(this.hash)));
        }
        catch (NoSuchAlgorithmException ex) {
            logger.info(ex.getMessage());
            return null;
        }
    }

    @Override
    public void initialize(PrivateKey privateKey, Certificate[] certificates, byte[] content, SignaturePolicy signaturePolicy, byte[] hash) {
        this.content = content;
        this.signaturePolicy = signaturePolicy;
        this.hash = hash;
    }
}

