/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.xml.icpb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.demoiselle.signer.policy.engine.util.MessagesBundle;
import org.demoiselle.signer.policy.engine.xml.icpb.XMLSignerAlgConstraint;
import org.demoiselle.signer.policy.engine.xml.icpb.XMLSignerRules;

public class XMLSignaturePolicy {
    private static MessagesBundle policyMessagesBundle = new MessagesBundle("messages_policy");
    private String policyIssuerName = null;
    private Date notBefore = null;
    private Date notAfter = null;
    private Date dateOfIssue = null;
    private String identifier = null;
    private String fieldOfApplication = null;
    private List<XMLSignerAlgConstraint> xmlSignerAlgConstraintList = new ArrayList<XMLSignerAlgConstraint>();
    private XMLSignerRules xmlSignerRules = new XMLSignerRules();

    public String getPolicyIssuerName() {
        return this.policyIssuerName;
    }

    public void setPolicyIssuerName(String policyIssuerName) {
        this.policyIssuerName = policyIssuerName;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Date getDateOfIssue() {
        return this.dateOfIssue;
    }

    public void setDateOfIssue(Date dateOfIssue) {
        this.dateOfIssue = dateOfIssue;
    }

    public String getFieldOfApplication() {
        return this.fieldOfApplication;
    }

    public void setFieldOfApplication(String fieldOfApplication) {
        this.fieldOfApplication = fieldOfApplication;
    }

    public List<XMLSignerAlgConstraint> getXmlSignerAlgConstraintList() {
        return this.xmlSignerAlgConstraintList;
    }

    public void setXmlSignerAlgConstraintList(List<XMLSignerAlgConstraint> xmlSignerAlgConstraintList) {
        this.xmlSignerAlgConstraintList = xmlSignerAlgConstraintList;
    }

    public XMLSignerRules getXmlSignerRules() {
        return this.xmlSignerRules;
    }

    public void setXmlSignerRules(XMLSignerRules xmlSignerRules) {
        this.xmlSignerRules = xmlSignerRules;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(policyMessagesBundle.getString("text.oid")).append(this.getIdentifier()).append("\n");
        builder.append(policyMessagesBundle.getString("text.launch.date")).append(this.getDateOfIssue()).append("\n");
        builder.append(policyMessagesBundle.getString("text.issuer")).append(this.getPolicyIssuerName()).append("\n");
        builder.append(policyMessagesBundle.getString("text.application")).append(this.getFieldOfApplication()).append("\n");
        builder.append(policyMessagesBundle.getString("text.valid")).append(this.getNotAfter()).append(this.getNotBefore()).append("\n");
        for (XMLSignerAlgConstraint sac : this.getXmlSignerAlgConstraintList()) {
            builder.append(policyMessagesBundle.getString("text.algo")).append(sac.getAlgId()).append("\n");
            builder.append(policyMessagesBundle.getString("text.key.min.size")).append(sac.getMinKeyLength()).append("\n");
        }
        builder.append("==============================================================").append("\n");
        for (String sr : this.xmlSignerRules.getMandatedSignedQProperties()) {
            builder.append(policyMessagesBundle.getString("text.signed.attr")).append(sr).append("\n");
        }
        builder.append("==============================================================").append("\n");
        for (String sr : this.xmlSignerRules.getMandatedUnsignedQProperties()) {
            builder.append(policyMessagesBundle.getString("text.unsigned.attr")).append(sr).append("\n");
        }
        return builder.toString();
    }
}

