/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.etsi;

import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.etsi.AlgAndLength;
import org.demoiselle.signer.policy.engine.asn1.etsi.AlgorithmIdentifier;
import org.demoiselle.signer.policy.engine.asn1.etsi.ObjectIdentifier;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignPolicyHash;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignPolicyInfo;
import org.demoiselle.signer.policy.engine.util.MessagesBundle;

public class SignaturePolicy {
    private AlgorithmIdentifier signPolicyHashAlg;
    private SignPolicyInfo signPolicyInfo;
    private SignPolicyHash signPolicyHash;
    private String signPolicyURI;
    private static MessagesBundle policyMessagesBundle = new MessagesBundle("messages_policy");

    public AlgorithmIdentifier getSignPolicyHashAlg() {
        return this.signPolicyHashAlg;
    }

    public void setSignPolicyHashAlg(AlgorithmIdentifier signPolicyHashAlg) {
        this.signPolicyHashAlg = signPolicyHashAlg;
    }

    public SignPolicyInfo getSignPolicyInfo() {
        return this.signPolicyInfo;
    }

    public void setSignPolicyInfo(SignPolicyInfo signPolicyInfo) {
        this.signPolicyInfo = signPolicyInfo;
    }

    public SignPolicyHash getSignPolicyHash() {
        return this.signPolicyHash;
    }

    public void setSignPolicyHash(SignPolicyHash signPolicyHash) {
        this.signPolicyHash = signPolicyHash;
    }

    public String getSignPolicyURI() {
        return this.signPolicyURI;
    }

    public void setSignPolicyURI(String signPolicyURI) {
        this.signPolicyURI = signPolicyURI;
    }

    public void parse(ASN1Primitive derObject) {
        ASN1Sequence derSequence = ASN1Object.getDERSequence(derObject);
        this.signPolicyHashAlg = new AlgorithmIdentifier();
        this.signPolicyHashAlg.parse(derSequence.getObjectAt(0).toASN1Primitive());
        this.signPolicyInfo = new SignPolicyInfo();
        this.signPolicyInfo.parse(derSequence.getObjectAt(1).toASN1Primitive());
        if (derSequence.size() == 3) {
            this.signPolicyHash = new SignPolicyHash((DEROctetString)derSequence.getObjectAt(2));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(policyMessagesBundle.getString("text.uri")).append(this.getSignPolicyURI()).append("\n");
        builder.append(policyMessagesBundle.getString("text.algo.hash")).append(this.getSignPolicyHashAlg().getAlgorithm().getValue()).append("\n");
        builder.append(policyMessagesBundle.getString("text.hash")).append(this.getSignPolicyHash().getValue()).append("\n");
        builder.append(policyMessagesBundle.getString("text.oid")).append(this.getSignPolicyInfo().getSignPolicyIdentifier().getValue()).append("\n");
        builder.append(policyMessagesBundle.getString("text.launch.date")).append(this.getSignPolicyInfo().getDateOfIssue().getDate()).append("\n");
        builder.append(policyMessagesBundle.getString("text.issuer")).append(this.getSignPolicyInfo().getPolicyIssuerName()).append("\n");
        builder.append(policyMessagesBundle.getString("text.application")).append(this.getSignPolicyInfo().getFieldOfApplication().getValue()).append("\n");
        builder.append(policyMessagesBundle.getString("text.valid")).append(this.getSignPolicyInfo().getSignatureValidationPolicy().getSigningPeriod()).append("\n");
        builder.append(policyMessagesBundle.getString("text.external")).append(this.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getExternalSignedData()).append("\n");
        builder.append(policyMessagesBundle.getString("text.mandated.ref")).append((Object)this.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedCertificateRef()).append("\n");
        builder.append(policyMessagesBundle.getString("text.mandated.info")).append((Object)this.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedCertificateInfo()).append("\n");
        for (AlgAndLength algAndLength : this.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getAlgorithmConstraintSet().getSignerAlgorithmConstraints().getAlgAndLengths()) {
            builder.append(policyMessagesBundle.getString("text.algo")).append(algAndLength.getAlgID()).append("\n");
            builder.append(policyMessagesBundle.getString("text.key.min.size")).append(algAndLength.getMinKeyLength()).append("\n");
        }
        builder.append("==============================================================").append("\n");
        for (ObjectIdentifier objectIdentifier : this.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedSignedAttr().getObjectIdentifiers()) {
            builder.append(policyMessagesBundle.getString("text.signed.attr.oid")).append(objectIdentifier.getValue()).append("\n");
        }
        builder.append("==============================================================").append("\n");
        if (this.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedUnsignedAttr().getObjectIdentifiers() != null) {
            for (ObjectIdentifier objectIdentifier : this.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getSignerRules().getMandatedUnsignedAttr().getObjectIdentifiers()) {
                builder.append(policyMessagesBundle.getString("text.unsigned.attr.oid")).append(objectIdentifier.getValue()).append("\n");
            }
        }
        if (this.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getVerifierRules().getMandatedUnsignedAttr().getObjectIdentifiers() != null) {
            builder.append("==============================================================").append("\n");
            for (ObjectIdentifier objectIdentifier : this.getSignPolicyInfo().getSignatureValidationPolicy().getCommonRules().getSignerAndVeriferRules().getVerifierRules().getMandatedUnsignedAttr().getObjectIdentifiers()) {
                builder.append(policyMessagesBundle.getString("text.unsigned.attr.oid")).append(objectIdentifier.getValue()).append("\n");
            }
        }
        return builder.toString();
    }
}

