/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.etsi;

import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.etsi.AcceptablePolicySet;
import org.demoiselle.signer.policy.engine.asn1.etsi.NameConstraints;
import org.demoiselle.signer.policy.engine.asn1.etsi.PathLenConstraint;
import org.demoiselle.signer.policy.engine.asn1.etsi.PolicyConstraints;

public class CertificateTrustPoint
extends ASN1Object {
    private X509Certificate trustpoint;
    private PathLenConstraint pathLenConstraint;
    private AcceptablePolicySet acceptablePolicySet;
    private NameConstraints nameConstraints;
    private PolicyConstraints policyConstraints;

    public X509Certificate getTrustpoint() {
        return this.trustpoint;
    }

    public void setTrustpoint(X509Certificate trustpoint) {
        this.trustpoint = trustpoint;
    }

    public PathLenConstraint getPathLenConstraint() {
        return this.pathLenConstraint;
    }

    public void setPathLenConstraint(PathLenConstraint pathLenConstraint) {
        this.pathLenConstraint = pathLenConstraint;
    }

    public AcceptablePolicySet getAcceptablePolicySet() {
        return this.acceptablePolicySet;
    }

    public void setAcceptablePolicySet(AcceptablePolicySet acceptablePolicySet) {
        this.acceptablePolicySet = acceptablePolicySet;
    }

    public NameConstraints getNameConstraints() {
        return this.nameConstraints;
    }

    public void setNameConstraints(NameConstraints nameConstraints) {
        this.nameConstraints = nameConstraints;
    }

    public PolicyConstraints getPolicyConstraints() {
        return this.policyConstraints;
    }

    public void setPolicyConstraints(PolicyConstraints policyConstraints) {
        this.policyConstraints = policyConstraints;
    }

    @Override
    public void parse(ASN1Primitive derObject) {
        ASN1Sequence derSequence = ASN1Object.getDERSequence(derObject);
        DERSequence x509Sequence = (DERSequence)derSequence.getObjectAt(0).toASN1Primitive();
        try {
            X509Certificate x509Cert;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Sequence.getEncoded());
            Security.addProvider(new BouncyCastleProvider());
            CertificateFactory fact = CertificateFactory.getInstance("X.509", "BC");
            this.trustpoint = x509Cert = (X509Certificate)fact.generateCertificate(byteArrayInputStream);
        }
        catch (Throwable error) {
            error.printStackTrace();
        }
        int total = derSequence.size();
        if (total > 0) {
            block8: for (int i = 0; i < total; ++i) {
                ASN1Primitive object = derSequence.getObjectAt(i).toASN1Primitive();
                if (!(object instanceof DERTaggedObject)) continue;
                DERTaggedObject derTaggedObject = (DERTaggedObject)object;
                TAG tag = TAG.getTag(derTaggedObject.getTagNo());
                switch (tag) {
                    case pathLenConstraint: {
                        this.pathLenConstraint = new PathLenConstraint();
                        this.pathLenConstraint.parse(object);
                        continue block8;
                    }
                    case acceptablePolicySet: {
                        this.acceptablePolicySet = new AcceptablePolicySet();
                        this.acceptablePolicySet.parse(object);
                        continue block8;
                    }
                    case nameConstraints: {
                        this.nameConstraints = new NameConstraints();
                        this.nameConstraints.parse(object);
                        continue block8;
                    }
                    case policyConstraints: {
                        this.policyConstraints = new PolicyConstraints();
                        this.policyConstraints.parse(object);
                        continue block8;
                    }
                }
            }
        }
    }

    static enum TAG {
        pathLenConstraint(0),
        acceptablePolicySet(1),
        nameConstraints(2),
        policyConstraints(3);

        int value;

        private TAG(int value) {
            this.value = value;
        }

        public static TAG getTag(int value) {
            for (TAG tag : TAG.values()) {
                if (tag.value != value) continue;
                return tag;
            }
            return null;
        }
    }
}

