/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.policy.engine.asn1.etsi;

import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.demoiselle.signer.policy.engine.asn1.ASN1Object;
import org.demoiselle.signer.policy.engine.asn1.etsi.ObjectIdentifier;
import org.demoiselle.signer.policy.engine.asn1.etsi.SignPolExtensions;

public class AlgAndLength
extends ASN1Object {
    private ObjectIdentifier algID;
    private Integer minKeyLength;
    private SignPolExtensions other;

    public ObjectIdentifier getAlgID() {
        return this.algID;
    }

    public void setAlgID(ObjectIdentifier algID) {
        this.algID = algID;
    }

    public Integer getMinKeyLength() {
        return this.minKeyLength;
    }

    public void setMinKeyLength(Integer minKeyLength) {
        this.minKeyLength = minKeyLength;
    }

    public SignPolExtensions getOther() {
        return this.other;
    }

    public void setOther(SignPolExtensions other) {
        this.other = other;
    }

    @Override
    public void parse(ASN1Primitive derObject) {
        ASN1Sequence derSequence = ASN1Object.getDERSequence(derObject);
        this.algID = new ObjectIdentifier();
        this.algID.parse(derSequence.getObjectAt(0).toASN1Primitive());
        if (derSequence.size() >= 2) {
            ASN1Integer derInteger = (ASN1Integer)derSequence.getObjectAt(1).toASN1Primitive();
            this.setMinKeyLength(derInteger.getValue().intValue());
        }
        if (derSequence.size() == 3) {
            this.other = new SignPolExtensions();
            this.other.parse(derSequence.getObjectAt(2).toASN1Primitive());
        }
    }
}

