/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.cryptography;

public enum AsymmetricAlgorithmEnum {
    RSA("RSA/ECB/PKCS1Padding"),
    ECDSA("ECDSA");

    public static AsymmetricAlgorithmEnum DEFAULT;
    private String algorithm;

    private AsymmetricAlgorithmEnum(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static AsymmetricAlgorithmEnum getAsymmetricAlgorithmEnum(String algorithm) {
        for (AsymmetricAlgorithmEnum value : AsymmetricAlgorithmEnum.values()) {
            if (!value.getAlgorithm().equalsIgnoreCase(algorithm)) continue;
            return value;
        }
        return null;
    }

    static {
        DEFAULT = RSA;
    }
}

