/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.validator;

import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.demoiselle.signer.core.IValidator;
import org.demoiselle.signer.core.exception.CertificateValidatorException;
import org.demoiselle.signer.core.util.MessagesBundle;

public class PeriodValidator
implements IValidator {
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    @Override
    public void validate(X509Certificate x509) throws CertificateValidatorException {
        try {
            if (x509 == null) {
                throw new CertificateValidatorException(coreMessagesBundle.getString("error.invalid.certificate"));
            }
            x509.checkValidity();
        }
        catch (Exception e) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
            throw new CertificateValidatorException(coreMessagesBundle.getString("error.certificate.out.date", formatter.format((Object)x509.getNotBefore()), formatter.format((Object)x509.getNotAfter())), e);
        }
    }

    public Date valDate(X509Certificate x509) throws CertificateValidatorException {
        try {
            if (x509 == null) {
                throw new CertificateValidatorException(coreMessagesBundle.getString("error.invalid.certificate"));
            }
            x509.checkValidity();
        }
        catch (Exception e) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
            throw new CertificateValidatorException(coreMessagesBundle.getString("error.certificate.out.date", formatter.format((Object)x509.getNotBefore()), formatter.format((Object)x509.getNotAfter())), e);
        }
        return x509.getNotAfter();
    }
}

