/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.validator;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.demoiselle.signer.core.IValidator;
import org.demoiselle.signer.core.exception.CertificateRevocationException;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.core.extension.ICPBR_CRL;
import org.demoiselle.signer.core.repository.CRLRepository;
import org.demoiselle.signer.core.repository.CRLRepositoryFactory;
import org.demoiselle.signer.core.util.MessagesBundle;

public class CRLValidator
implements IValidator {
    private final CRLRepository crlRepository = CRLRepositoryFactory.factoryCRLRepository();
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    @Override
    public void validate(X509Certificate x509) throws CertificateValidatorCRLException, CertificateRevocationException {
        if (x509 != null) {
            Collection<ICPBR_CRL> crls = null;
            try {
                crls = this.crlRepository.getX509CRL(x509);
            }
            catch (Exception e) {
                throw new CertificateValidatorCRLException(e.getMessage());
            }
            if (crls == null || crls.isEmpty()) {
                throw new CertificateValidatorCRLException(coreMessagesBundle.getString("error.validate.on.crl", "vazio ou nula"));
            }
            for (ICPBR_CRL icpbr_crl : crls) {
                if (!icpbr_crl.getCRL().isRevoked(x509)) continue;
                throw new CertificateRevocationException(coreMessagesBundle.getString("error.certificate.repealed"));
            }
        } else {
            throw new CertificateValidatorCRLException(coreMessagesBundle.getString("error.invalid.certificate"));
        }
    }
}

