/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.demoiselle.signer.core.exception.CertificateValidatorException;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryUtil {
    private static Logger logger = LoggerFactory.getLogger(RepositoryUtil.class);
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();
    private static int byteWritten;
    private static int byteWritten2;

    public static String urlToMD5(String url) {
        try {
            String ret = "";
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(url.getBytes(), 0, url.length());
            for (byte b : md.digest()) {
                ret = ret + String.format("%02x", b);
            }
            return ret;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveURL(String sUrl, File destinationFile) {
        RepositoryUtil.setByteWritten(0);
        FilterOutputStream outStream = null;
        URLConnection uCon = null;
        InputStream is = null;
        try {
            int ByteRead;
            logger.info(coreMessagesBundle.getString("info.file.destination", destinationFile));
            URL url = new URL(sUrl);
            ConfigurationRepo conf = ConfigurationRepo.getInstance();
            uCon = url.openConnection(conf.getProxy());
            uCon.setConnectTimeout(conf.getCrlTimeOut());
            uCon.setReadTimeout(conf.getCrlTimeOut());
            try {
                is = uCon.getInputStream();
            }
            catch (Exception e) {
                String newUrl = sUrl.replace("http://", "https://");
                logger.info(newUrl);
                url = new URL(newUrl);
                uCon = url.openConnection(conf.getProxy());
                uCon.setConnectTimeout(conf.getCrlTimeOut());
                uCon.setReadTimeout(conf.getCrlTimeOut());
                is = uCon.getInputStream();
            }
            outStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buf = new byte[1024];
            while ((ByteRead = is.read(buf)) != -1) {
                ((BufferedOutputStream)outStream).write(buf, 0, ByteRead);
                RepositoryUtil.setByteWritten(RepositoryUtil.getByteWritten() + ByteRead);
            }
            ((BufferedOutputStream)outStream).flush();
            if (destinationFile.length() <= 0L && !destinationFile.delete()) {
                logger.warn(coreMessagesBundle.getString("error.file.remove", destinationFile));
            }
            is.close();
        }
        catch (MalformedURLException e) {
            try {
                logger.error(coreMessagesBundle.getString("error.malformed.url", sUrl));
                throw new CertificateValidatorException(coreMessagesBundle.getString("error.malformed.url", sUrl), e);
                catch (FileNotFoundException e2) {
                    logger.error(coreMessagesBundle.getString("error.file.not.found", sUrl));
                    throw new CertificateValidatorException(coreMessagesBundle.getString("error.file.not.found", sUrl), e2);
                }
                catch (IOException e3) {
                    logger.error(coreMessagesBundle.getString("error.io", e3.getMessage()));
                    throw new CertificateValidatorException(coreMessagesBundle.getString("error.io", e3.getMessage()), e3);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (outStream == null) throw throwable;
                    outStream.close();
                    throw throwable;
                }
                catch (Throwable e4) {
                    logger.error(coreMessagesBundle.getString("error.crl.close.connection", sUrl));
                    throw new CertificateValidatorException(coreMessagesBundle.getString("error.crl.close.connection", sUrl), e4);
                }
            }
        }
        try {
            if (is != null) {
                is.close();
            }
            if (outStream == null) return;
            outStream.close();
            return;
        }
        catch (Throwable e) {
            logger.error(coreMessagesBundle.getString("error.crl.close.connection", sUrl));
            throw new CertificateValidatorException(coreMessagesBundle.getString("error.crl.close.connection", sUrl), e);
        }
    }

    public static List<String> filterValidURLs(List<String> listURL) {
        ArrayList<String> newURLlist = new ArrayList<String>();
        for (String sURL : listURL) {
            if (!RepositoryUtil.validateURL(sURL)) continue;
            newURLlist.add(sURL);
        }
        return newURLlist;
    }

    /*
     * Exception decompiling
     */
    private static boolean validateURL(String sUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int getByteWritten() {
        return byteWritten;
    }

    public static void setByteWritten(int byteWritten) {
        RepositoryUtil.byteWritten = byteWritten;
    }

    public static int getByteWritten2() {
        return byteWritten2;
    }

    public static void setByteWritten2(int byteWritten2) {
        RepositoryUtil.byteWritten2 = byteWritten2;
    }
}

