/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloads {
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();
    private static Logger logger = LoggerFactory.getLogger(Downloads.class);

    public static InputStream getInputStreamFromURL(String stringURL) throws RuntimeException {
        try {
            InputStream is = null;
            URL url = new URL(stringURL);
            ConfigurationRepo conf = ConfigurationRepo.getInstance();
            URLConnection connection = url.openConnection(conf.getProxy());
            connection.setConnectTimeout(conf.getCrlTimeOut());
            connection.setReadTimeout(conf.getCrlTimeOut());
            try {
                is = connection.getInputStream();
            }
            catch (IOException e) {
                String newUrl = stringURL.replace("http://", "https://");
                logger.info(newUrl);
                url = new URL(newUrl);
                connection = url.openConnection(conf.getProxy());
                connection.setConnectTimeout(conf.getCrlTimeOut());
                connection.setReadTimeout(conf.getCrlTimeOut());
                is = connection.getInputStream();
            }
            return is;
        }
        catch (MalformedURLException error) {
            throw new RuntimeException(coreMessagesBundle.getString("error.malformedURL", error.getMessage()), error);
        }
        catch (UnknownServiceException error) {
            throw new RuntimeException(coreMessagesBundle.getString("error.unknown.service", error.getMessage()), error);
        }
        catch (IOException error) {
            throw new RuntimeException(coreMessagesBundle.getString("error.io", error.getMessage()), error);
        }
    }
}

