/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.timestamp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.demoiselle.signer.core.Priority;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.timestamp.TimeStampGenerator;
import org.demoiselle.signer.core.util.MessagesBundle;

public final class TimeStampGeneratorSelector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();
    private static ServiceLoader<TimeStampGenerator> loader;

    private TimeStampGeneratorSelector() {
    }

    public static TimeStampGenerator selectReference() {
        TimeStampGenerator selected = TimeStampGeneratorSelector.selectClass(TimeStampGeneratorSelector.getOptions());
        return selected;
    }

    private static Collection<TimeStampGenerator> getOptions() {
        HashSet<TimeStampGenerator> result = new HashSet<TimeStampGenerator>();
        loader = ServiceLoader.load(TimeStampGenerator.class);
        for (TimeStampGenerator clazz : loader) {
            result.add(clazz);
        }
        return result;
    }

    private static TimeStampGenerator selectClass(Collection<TimeStampGenerator> options) {
        TimeStampGenerator selected = null;
        for (TimeStampGenerator option : options) {
            if (selected != null && TimeStampGeneratorSelector.getPriority(option) >= TimeStampGeneratorSelector.getPriority(selected)) continue;
            selected = option;
        }
        if (selected != null) {
            TimeStampGeneratorSelector.performAmbiguityCheck(TimeStampGenerator.class, selected, options);
        }
        return selected;
    }

    private static int getPriority(TimeStampGenerator clazz) {
        Priority priority = clazz.getClass().getAnnotation(Priority.class);
        if (priority == null) {
            new CertificateCoreException(coreMessagesBundle.getString("error.priority.null", clazz.getClass().getName()));
        }
        return priority != null ? priority.value() : Integer.MIN_VALUE;
    }

    private static <T> void performAmbiguityCheck(Class<T> type, TimeStampGenerator selected, Collection<TimeStampGenerator> options) {
        int selectedPriority = TimeStampGeneratorSelector.getPriority(selected);
        ArrayList<TimeStampGenerator> ambiguous = new ArrayList<TimeStampGenerator>();
        for (TimeStampGenerator option : options) {
            if (selected == option || selectedPriority != TimeStampGeneratorSelector.getPriority(option)) continue;
            ambiguous.add(option);
        }
        if (!ambiguous.isEmpty()) {
            ambiguous.add(selected);
            throw new CertificateCoreException(coreMessagesBundle.getString("error.priority.ambiguous", selected.getClass().getCanonicalName()));
        }
    }
}

