/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.demoiselle.signer.core.exception.CertificateValidatorException;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.repository.OffLineCRLRepository;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.core.util.RepositoryUtil;

public class RepositoryService {
    private static final String UPDATE = "update-crl-list";
    private static final String ADD = "add-crl";
    private static String rt = "";
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            RepositoryService.println(coreMessagesBundle.getString("error.repository.service.args"));
            return;
        }
        String op = args[0];
        if (op.equalsIgnoreCase(ADD)) {
            String url = args[1];
            String file_index = args[2];
            File file = new File(file_index);
            ConfigurationRepo.getInstance().setCrlIndex(file.getName());
            ConfigurationRepo.getInstance().setCrlPath(file.getParent());
            OffLineCRLRepository rp = new OffLineCRLRepository();
            rp.addFileIndex(url);
            RepositoryService.update(url);
            return;
        }
        if (op.equalsIgnoreCase(UPDATE)) {
            String file_index = args[1];
            File fileIndex = new File(file_index);
            ConfigurationRepo.getInstance().setCrlIndex(file_index);
            if (!fileIndex.exists()) {
                RepositoryService.println(coreMessagesBundle.getString("error.file.not.found", file_index));
                return;
            }
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(fileIndex));
            }
            catch (Exception e) {
                throw new CertificateValidatorException(coreMessagesBundle.getString("error.file.index.load", fileIndex), e);
            }
            Enumeration<Object> keys = prop.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                String url = (String)prop.get(key);
                RepositoryService.update(url);
            }
            try {
                prop.store(new FileOutputStream(fileIndex), null);
                return;
            }
            catch (IOException e) {
                throw new CertificateValidatorException(coreMessagesBundle.getString("error.file.index.load", fileIndex), e);
            }
        }
        RepositoryService.println(coreMessagesBundle.getString("error.repository.service.operation", op));
    }

    private static void update(String url) {
        try {
            ConfigurationRepo config = ConfigurationRepo.getInstance();
            File fileCLR = new File(config.getCrlPath(), RepositoryUtil.urlToMD5(url));
            RepositoryService.print(coreMessagesBundle.getString("info.repository.service.download", url));
            RepositoryUtil.saveURL(url, fileCLR);
            RepositoryService.println("...[Ok]");
        }
        catch (CertificateValidatorException e) {
            RepositoryService.println(coreMessagesBundle.getString("error.repository.service.fail"));
            RepositoryService.println(coreMessagesBundle.getString("error.repository.service.cause") + e.getMessage());
        }
    }

    public static String getReturn() {
        return rt;
    }

    private static void println(String msg) {
        rt = msg;
        System.out.println(msg);
    }

    private static void print(String msg) {
        rt = msg;
        System.out.print(msg);
    }
}

