/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.repository;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.extension.ICPBR_CRL;
import org.demoiselle.signer.core.repository.CRLRepository;
import org.demoiselle.signer.core.repository.CRLRepositoryException;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnLineCRLRepository
implements CRLRepository {
    private final Logger logger = LoggerFactory.getLogger(OnLineCRLRepository.class);
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();
    private Proxy proxy;

    public OnLineCRLRepository() {
        this.proxy = Proxy.NO_PROXY;
    }

    public OnLineCRLRepository(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Collection<ICPBR_CRL> getX509CRL(X509Certificate certificate) throws NoSuchProviderException {
        ArrayList<ICPBR_CRL> list = new ArrayList<ICPBR_CRL>();
        try {
            BasicCertificate cert = new BasicCertificate(certificate);
            List<String> ListaURLCRL = cert.getCRLDistributionPoint();
            if (ListaURLCRL == null || ListaURLCRL.isEmpty()) {
                this.logger.error(coreMessagesBundle.getString("error.invalid.crl"));
                throw new CRLRepositoryException(coreMessagesBundle.getString("error.invalid.crl"));
            }
            ICPBR_CRL validCrl = null;
            for (String URLCRL : ListaURLCRL) {
                validCrl = this.getICPBR_CRL(URLCRL);
                if (validCrl == null) continue;
                list.add(validCrl);
                this.logger.debug(coreMessagesBundle.getString("info.crl.found", URLCRL));
                break;
            }
            if (validCrl == null) {
                this.logger.error(coreMessagesBundle.getString("error.validate.on.crl", ListaURLCRL));
                throw new CRLRepositoryException(coreMessagesBundle.getString("error.validate.on.crl", ListaURLCRL));
            }
        }
        catch (IOException e) {
            this.logger.error(coreMessagesBundle.getString("error.invalid.crl") + e.getMessage());
            throw new CRLRepositoryException(coreMessagesBundle.getString("error.invalid.crl") + e.getMessage());
        }
        return list;
    }

    protected ICPBR_CRL getICPBR_CRL(String uRLCRL) throws NoSuchProviderException {
        ICPBR_CRL icpbr_crl = null;
        try {
            InputStream is;
            URL url = new URL(uRLCRL);
            URLConnection uCon = url.openConnection(this.proxy);
            ConfigurationRepo conf = ConfigurationRepo.getInstance();
            uCon.setConnectTimeout(conf.getCrlTimeOut());
            uCon.setReadTimeout(conf.getCrlTimeOut());
            try {
                is = uCon.getInputStream();
            }
            catch (IOException e) {
                String newUrl;
                this.logger.debug(e.getMessage());
                uRLCRL = newUrl = uRLCRL.replace("http://", "https://");
                this.logger.info(newUrl);
                url = new URL(newUrl);
                uCon = url.openConnection(conf.getProxy());
                uCon.setConnectTimeout(conf.getCrlTimeOut());
                uCon.setReadTimeout(conf.getCrlTimeOut());
                is = uCon.getInputStream();
            }
            DataInputStream inStream = new DataInputStream(is);
            icpbr_crl = new ICPBR_CRL(inStream);
            inStream.close();
        }
        catch (MalformedURLException e) {
            this.logger.error(coreMessagesBundle.getString("error.malformedURL", uRLCRL).concat(e.getMessage()));
            icpbr_crl = null;
        }
        catch (IOException e) {
            this.logger.error(coreMessagesBundle.getString("error.crl.connect", uRLCRL).concat(e.getMessage()));
            icpbr_crl = null;
        }
        catch (CRLException e) {
            this.logger.error(coreMessagesBundle.getString("error.crl.exception", uRLCRL).concat(e.getMessage()));
            icpbr_crl = null;
        }
        catch (CertificateException e) {
            this.logger.error(coreMessagesBundle.getString("error.crl.certificate", uRLCRL).concat(e.getMessage()));
            icpbr_crl = null;
        }
        return icpbr_crl;
    }
}

