/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.demoiselle.signer.core.exception.CertificateValidatorException;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.extension.ICPBR_CRL;
import org.demoiselle.signer.core.repository.CRLRepository;
import org.demoiselle.signer.core.repository.CRLRepositoryException;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.core.util.RepositoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffLineCRLRepository
implements CRLRepository {
    private final ConfigurationRepo config;
    private final Logger logger = LoggerFactory.getLogger(OffLineCRLRepository.class);
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    public OffLineCRLRepository() {
        this.config = ConfigurationRepo.getInstance();
    }

    @Override
    public Collection<ICPBR_CRL> getX509CRL(X509Certificate certificate) throws NoSuchProviderException {
        ArrayList<ICPBR_CRL> list = new ArrayList<ICPBR_CRL>();
        try {
            BasicCertificate cert = new BasicCertificate(certificate);
            List<String> ListaURLCRL = cert.getCRLDistributionPoint();
            if (ListaURLCRL == null || ListaURLCRL.isEmpty()) {
                this.logger.error(coreMessagesBundle.getString("error.invalid.crl"));
                throw new CRLRepositoryException(coreMessagesBundle.getString("error.invalid.crl"));
            }
            ICPBR_CRL validCrl = null;
            for (String URLCRL : ListaURLCRL) {
                validCrl = this.getICPBR_CRL(URLCRL);
                if (validCrl == null) continue;
                list.add(validCrl);
                this.logger.debug(coreMessagesBundle.getString("info.crl.offline.found"));
                break;
            }
            if (validCrl == null) {
                this.logger.error(coreMessagesBundle.getString("error.validate.on.crl", ListaURLCRL));
                throw new CRLRepositoryException(coreMessagesBundle.getString("error.validate.on.crl", ListaURLCRL));
            }
        }
        catch (IOException e) {
            this.logger.error(coreMessagesBundle.getString("error.invalid.crl") + e.getMessage());
            throw new CRLRepositoryException(coreMessagesBundle.getString("error.invalid.crl") + e.getMessage());
        }
        return list;
    }

    private ICPBR_CRL getICPBR_CRL(String uRLCRL) throws NoSuchProviderException {
        File fileCRL = null;
        try {
            ICPBR_CRL crl = null;
            if (new File(this.config.getCrlPath()).mkdirs()) {
                this.logger.debug(coreMessagesBundle.getString("info.creating.crl", this.config.getCrlPath()));
            } else {
                this.logger.debug(coreMessagesBundle.getString("info.created.crl", this.config.getCrlPath()));
            }
            fileCRL = new File(this.config.getCrlPath(), RepositoryUtil.urlToMD5(uRLCRL));
            if (!fileCRL.exists()) {
                RepositoryUtil.saveURL(uRLCRL, fileCRL);
            }
            if (fileCRL.length() != 0L) {
                crl = new ICPBR_CRL(new FileInputStream(fileCRL));
                if (crl.getCRL().getNextUpdate().before(new Date())) {
                    this.logger.info(coreMessagesBundle.getString("info.update.crl"));
                    RepositoryUtil.saveURL(uRLCRL, fileCRL);
                }
            } else if (!fileCRL.delete()) {
                this.logger.error(coreMessagesBundle.getString("error.file.remove", fileCRL));
                this.config.setOnline(true);
            }
            return crl;
        }
        catch (FileNotFoundException e) {
            this.addFileIndex(uRLCRL);
            this.logger.error(coreMessagesBundle.getString("error.file.not.found", fileCRL));
            this.config.setOnline(true);
        }
        catch (CRLException e) {
            this.addFileIndex(uRLCRL);
            this.logger.error(coreMessagesBundle.getString("error.file.corrupted", fileCRL, e.getMessage()));
            this.config.setOnline(true);
            if (!fileCRL.delete()) {
                this.logger.error(coreMessagesBundle.getString("error.file.remove", fileCRL));
            }
        }
        catch (CertificateException e) {
            this.addFileIndex(uRLCRL);
            this.config.setOnline(true);
            this.logger.error(coreMessagesBundle.getString("error.crl.certificate", e.getMessage()));
        }
        return null;
    }

    public void addFileIndex(String url) {
        String fileNameCRL = RepositoryUtil.urlToMD5(url);
        File fileIndex = new File(this.config.getCrlPath(), this.config.getCrlIndex());
        if (!fileIndex.exists()) {
            try {
                File diretory = new File(this.config.getCrlPath());
                diretory.mkdirs();
                fileIndex.createNewFile();
            }
            catch (Exception e) {
                this.logger.error(coreMessagesBundle.getString("error.file.index.create", fileIndex) + e.getMessage());
                throw new CertificateValidatorException(coreMessagesBundle.getString("error.file.index.create", fileIndex), e);
            }
        }
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(fileIndex));
        }
        catch (Exception e) {
            this.logger.error(coreMessagesBundle.getString("error.file.index.create", fileIndex) + e.getMessage());
            throw new CertificateValidatorException(coreMessagesBundle.getString("error.file.index.create", fileIndex), e);
        }
        prop.put(fileNameCRL, url);
        try {
            prop.store(new FileOutputStream(fileIndex), null);
        }
        catch (Exception e) {
            this.logger.error(coreMessagesBundle.getString("error.file.index.create", fileIndex) + e.getMessage());
            throw new CertificateValidatorException(coreMessagesBundle.getString("error.file.index.create", fileIndex), e);
        }
    }
}

