/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.repository;

import java.io.File;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.UnknownHostException;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationRepo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationRepo.class);
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();
    public static final String MODE_ONLINE = "signer.repository.online";
    public static final String ENV_MODE_ONLINE = "SIGNER_REPOSITORY_ONLINE";
    public static final String CRL_INDEX = "signer.repository.crl.index";
    public static final String ENV_CRL_INDEX = "SIGNER_REPOSITORY_CRL_INDEX";
    public static final String CRL_PATH = "signer.repository.crl.path";
    public static final String ENV_CRL_PATH = "SIGNER_REPOSITORY_CRL_PATH";
    public static final String LPA_PATH = "signer.repository.lpa.path";
    public static final String ENV_LPA_PATH = "SIGNER_REPOSITORY_LPA_PATH";
    public static final String LPA_ONLINE = "signer.repository.lpa.online";
    public static final String ENV_LPA_ONLINE = "SIGNER_REPOSITORY_LPA_ONLINE";
    public static final String PROXY_HOST = "signer.proxy.host";
    public static final String ENV_PROXY_HOST = "SIGNER_PROXY_HOST";
    public static final String PROXY_PORT = "signer.proxy.port";
    public static final String ENV_PROXY_PORT = "SIGNER_PROXY_PORT";
    public static final String PROXY_USER = "signer.proxy.user";
    public static final String ENV_PROXY_USER = "SIGNER_PROXY_USER";
    public static final String PROXY_PASSWORD = "signer.proxy.password";
    public static final String ENV_PROXY_PASSWORD = "SIGNER_PROXY_PASSWORD";
    public static final String PROXY_TYPE = "signer.proxy.type";
    public static final String ENV_PROXY_TYPE = "SIGNER_PROXY_TYPE";
    public static final String CRL_CONNECTION_TIMEOUT = "signer.crl.connection.timeout";
    public static final String ENV_CRL_CONNECTION_TIMEOUT = "SIGNER_CRL_CONNECTION_TIMEOUT";
    public static ConfigurationRepo instance = new ConfigurationRepo();
    private String crlIndex = null;
    private String crlPath = null;
    private String lpaPath = null;
    private boolean isOnlineLCR = true;
    private Proxy proxy = Proxy.NO_PROXY;
    private Proxy.Type type = Proxy.Type.HTTP;
    private boolean isOnlineLPA = false;
    private boolean validateLCR = true;
    private int crlTimeOut = 10000;

    public static ConfigurationRepo getInstance() {
        return instance;
    }

    private ConfigurationRepo() {
        String port;
        String proxyType;
        String mode_online = System.getenv(ENV_MODE_ONLINE);
        if (mode_online == null || mode_online.isEmpty()) {
            mode_online = (String)System.getProperties().get(MODE_ONLINE);
            if (mode_online == null || mode_online.isEmpty()) {
                this.setOnline(true);
            } else {
                this.setOnline(Boolean.valueOf(mode_online));
            }
        } else {
            this.setOnline(Boolean.valueOf(mode_online));
        }
        this.crlIndex = System.getenv(ENV_CRL_INDEX);
        if (this.crlIndex == null || this.crlIndex.isEmpty()) {
            this.crlIndex = (String)System.getProperties().get(CRL_INDEX);
            if (this.crlIndex == null || this.crlIndex.isEmpty()) {
                this.setCrlIndex(".crl_index");
            } else {
                this.setCrlIndex(this.crlIndex);
            }
        } else {
            this.setCrlIndex(this.crlIndex);
        }
        this.crlPath = System.getenv(ENV_CRL_PATH);
        if (this.crlPath == null || this.crlPath.isEmpty()) {
            this.crlPath = (String)System.getProperties().get(CRL_PATH);
            if (this.crlPath == null || this.crlPath.isEmpty()) {
                this.setCrlPath(System.getProperty("java.io.tmpdir") + File.separatorChar + "crls");
            } else {
                this.setCrlPath(this.crlPath);
            }
        } else {
            this.setCrlPath(this.crlPath);
        }
        this.lpaPath = System.getenv(ENV_LPA_PATH);
        if (this.lpaPath == null || this.lpaPath.isEmpty()) {
            this.lpaPath = (String)System.getProperties().get(LPA_PATH);
            if (this.lpaPath == null || this.lpaPath.isEmpty()) {
                this.setLpaPath(System.getProperty("java.io.tmpdir") + File.separatorChar + "lpas");
            } else {
                this.setLpaPath(this.lpaPath);
            }
        } else {
            this.setLpaPath(this.lpaPath);
        }
        String hostName = System.getenv(ENV_PROXY_HOST);
        if (hostName == null || hostName.isEmpty()) {
            hostName = (String)System.getProperties().get(PROXY_HOST);
            if (hostName == null || hostName.isEmpty()) {
                this.setProxy(Proxy.NO_PROXY);
            } else {
                proxyType = (String)System.getProperties().get(PROXY_TYPE);
                this.setType(proxyType);
                port = (String)System.getProperties().get(PROXY_PORT);
                String user = (String)System.getProperties().get(PROXY_USER);
                String password = (String)System.getProperties().get(PROXY_PASSWORD);
                this.setProxy(hostName, port, user, password);
            }
        } else {
            proxyType = System.getenv(ENV_PROXY_TYPE);
            this.setType(proxyType);
            port = System.getenv(ENV_PROXY_PORT);
            String user = System.getenv(ENV_PROXY_USER);
            String password = System.getenv(ENV_PROXY_PASSWORD);
            this.setProxy(hostName, port, user, password);
        }
        String lpa_online = System.getenv(ENV_LPA_ONLINE);
        if (lpa_online == null || lpa_online.isEmpty()) {
            lpa_online = (String)System.getProperties().get(LPA_ONLINE);
            if (lpa_online == null || lpa_online.isEmpty()) {
                this.setOnlineLPA(false);
            } else {
                this.setOnlineLPA(Boolean.valueOf(lpa_online));
            }
        } else {
            this.setOnlineLPA(Boolean.valueOf(lpa_online));
        }
        try {
            String varCrlTimeOut = System.getenv(ENV_CRL_CONNECTION_TIMEOUT);
            if (varCrlTimeOut == null || varCrlTimeOut.isEmpty()) {
                varCrlTimeOut = (String)System.getProperties().get(CRL_CONNECTION_TIMEOUT);
                if (varCrlTimeOut == null || varCrlTimeOut.isEmpty()) {
                    LOGGER.debug("DEFAULT");
                    this.setCrlTimeOut(5000);
                    LOGGER.debug(coreMessagesBundle.getString("info.crl.timeout", this.getCrlTimeOut()));
                } else {
                    LOGGER.debug("KEY");
                    this.setCrlTimeOut(Integer.valueOf(varCrlTimeOut));
                }
            } else {
                LOGGER.debug("ENV");
                this.setCrlTimeOut(Integer.valueOf(varCrlTimeOut));
            }
        }
        catch (Exception e) {
            LOGGER.debug(coreMessagesBundle.getString("info.crl.timeout", this.getCrlTimeOut()));
        }
    }

    public String getCrlIndex() {
        return this.crlIndex;
    }

    public void setCrlIndex(String crlIndex) {
        this.crlIndex = crlIndex;
        LOGGER.debug(coreMessagesBundle.getString("info.crl.index", this.getCrlIndex()));
    }

    public boolean isOnline() {
        return this.isOnlineLCR;
    }

    public void setOnline(boolean isOnline) {
        this.isOnlineLCR = isOnline;
        LOGGER.debug(coreMessagesBundle.getString("info.crl.online", this.isOnline()));
    }

    public String getCrlPath() {
        return this.crlPath;
    }

    public void setCrlPath(String crlPath) {
        this.crlPath = crlPath;
        LOGGER.debug(coreMessagesBundle.getString("info.crl.path", this.getCrlPath()));
    }

    public String getLpaPath() {
        return this.lpaPath;
    }

    public void setLpaPath(String lpaPath) {
        this.lpaPath = lpaPath;
        LOGGER.debug(coreMessagesBundle.getString("info.lpa.path", this.getLpaPath()));
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
        LOGGER.debug(coreMessagesBundle.getString("info.proxy.noproxy"));
    }

    public Proxy.Type getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type == null || type.isEmpty() ? Proxy.Type.HTTP : Proxy.Type.valueOf(type.toUpperCase());
    }

    public void setProxy(String hostName, String port, final String userName, final String password) {
        try {
            InetAddress inetAddress = InetAddress.getByName(hostName);
            InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, Integer.parseInt(port));
            this.proxy = new Proxy(this.type, socketAddress);
            if (userName != null && !userName.isEmpty()) {
                if (password != null && !password.isEmpty()) {
                    Authenticator authenticator = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(userName, password.toCharArray());
                        }
                    };
                    Authenticator.setDefault(authenticator);
                    LOGGER.debug(coreMessagesBundle.getString("info.proxy.running", hostName, port));
                } else {
                    LOGGER.error(coreMessagesBundle.getString("error.proxy.password.null"));
                }
            }
        }
        catch (UnknownHostException uhe) {
            LOGGER.error(coreMessagesBundle.getString("error.proxy.host", hostName, port, uhe.getMessage()));
            this.setProxy(Proxy.NO_PROXY);
        }
    }

    public boolean isOnlineLPA() {
        return this.isOnlineLPA;
    }

    public void setOnlineLPA(boolean isOnlineLPA) {
        this.isOnlineLPA = isOnlineLPA;
        LOGGER.debug(coreMessagesBundle.getString("info.lpa.online", this.isOnlineLPA()));
    }

    public boolean isValidateLCR() {
        return this.validateLCR;
    }

    public void setValidateLCR(boolean validateLCR) {
        this.validateLCR = validateLCR;
        LOGGER.debug(coreMessagesBundle.getString("info.crl.validate", this.isValidateLCR()));
    }

    public int getCrlTimeOut() {
        return this.crlTimeOut;
    }

    public void setCrlTimeOut(int crlTimeOut) {
        this.crlTimeOut = crlTimeOut;
        LOGGER.debug(coreMessagesBundle.getString("info.crl.timeout", this.getCrlTimeOut()));
    }
}

